;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       TMR1_18.ASM                                       *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    TMR1 DEMO PROGRAM                                                *
;    -----------------                                                *
;    "Vals idej ra" alkalmazs.                                    *
;    A Timer1 aszinkron mdban fut s 0,5 mp-knt megszaktst kr.   *
;    A TMR1 modul sajt oszcilltort hasznlja, az idzt elem az   *
;    RC0 s RC1 kivezetsek kz kapcsolt 32,768kHz-es kvarc.         *
;    1 mp idztssel villogtatja a LED-eket. (kitltsi tnyez=50%) *
;                                                                     *
;**********************************************************************
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)


;------------------------------------------------------------------------------
;
;
;
;------------------------------------------------------------------------------
;------------------------------------- FPROGRAM ------------------------------
;------------------------------------------------------------------------------
;

        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            

                bra             Start
;------------------------------------------------------------------------------

        org     KezdVect+8                        ; reset vektor
                bcf             PIR1,TMR1IF     ; Timer1 IT flag trls
                movlw   B'11111111'
                xorwf   LATD,1
                movlw   H'C0'           ; Timer1=C000h bellts
                movwf   TMR1H
                clrf    TMR1L
                retfie
;------------------------------------------------------------------------------
;
;
;
;------------------------------------------------------------------------------
; I/O portok konfigurlsa
;
Start
                movlw   14
                movwf   ADCON1          ; RA0 analg bemenet !!!
                movlw   B'00100001'     ; RA0, RA5 bemenet, RA1..4 kimenet
                movwf   TRISA
                setf    TRISC           ; PORTC bemenet, (default!)
                clrf    TRISD           ; PORTD kimenet
;------------------------------------------------------------------------------
; Timer1 konfigurlsa
;
                movlw   1               ; TMR1IE=1
                movwf   PIE1            ; Timer1 megszakts engedlyezs
                movlw   14              ; Timer1 bellts: TMR1 oszc. eng.,
                movwf   T1CON           ; eloszt=1, aszinkron md
                clrf    INTCON          ; megszaktsok tiltsa
;------------------------------------------------------------------------------
                bcf     T1CON,TMR1ON    ; Timer1 megllts
                bcf     PIR1,TMR1IF     ; Timer1 IT flag trls
                movlw   H'C0'           ; Timer1=C000h bellts,
                movwf   TMR1H           ; gy 0,5 mp-knt kr megszaktst
                clrf    TMR1L
                movlw   192             ; GIE=1, PEIE=1
                movwf   INTCON          ; Timer1 IT engedlyezs
                bsf     T1CON,TMR1ON    ; Timer1 start
                clrf    LATD
Loop            bra     Loop            ; resetre vr
;------------------------------------------------------------------------------
                end
