;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       93LC56_8.ASM                                      *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    93LC56 MICROWIRE SOROS EEPROM KEZEL PROGRAM                     *
;    --------------------------------------------                     *
;                                                                     *
;    A Txtemp kezdcim, 16 byte mret RAM buffer tartalmt a 0x10   *
;    cimtl kezdden az EEPROM-ba msolja, majd az ugyanarrl a      *
;    cimtartomanyl visszaolvasott adatokat a Txtemp kezdcimu RAM    *
;    bufferbe irja.                                                   *
;    A szinkron soros port vonalait szoftveresen kezeli.              *
;                                                                     *
;        JP2 jumper engedlyezi a memrit!                           *
;                                                                     *
;**********************************************************************
;
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;----------------------------------------------------------------------
; PORTA kivezetsek
;
CS              equ     2                       ; RA2, EEPROM Chip select, aktv H
;----------------------------------------------------------------------
; PORTC kivezetsek
;
SDO             equ     5                       ; RC5, EEPROM DI kivezetsre
SDI             equ     4                       ; RC4, EEPROM DO kivezetsre
CLK             equ     3                       ; RC3, EEPROM CLK kivezetsre
;----------------------------------------------------------------------
; EEPROM utastskdok
;
ROP             equ     192                     ; OLVASS utastskd
WROP            equ     160                     ; RS utastskd
EWEN            equ     152                     ; TRLS s RS engedlyezs kd
EWDS            equ     128                     ; TRLS s RS letilts utastskd
;----------------------------------------------------------------------
;
        CBLOCK
Temp                                            ; tmeneti trol az EE rutinokhoz
EE_data                                         ; EEPROM adat (EEwrite, EEread)
EE_addr                                         ; EEPROM cm (EEwrite, EEread)
Clocks                                          ; rajel ciklus szmll
Counter                                         ; foprogram segdvltozja
Timer0                                          ; Idztshez
Timer1:16                                       ; Idztshez
;
Rxtemp:16                                       ; kiolvasott adatok kezdcme a RAM-ban
;
Txtemp:16                                       ; berand adatok cme a RAM-ban
        ENDC
;
;
;
;----------------------------------------------------------------------
;

        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            

;----------------------------------------------------------------------
;
Start
            clrf    LATA
            clrf    LATC                        ; EEPROM vonalak inaktvak
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            movlw   B'11111011'                 ; RA2 kimenet
            movwf   TRISA
            movlw   B'11010111'                 ; RC3, RC5 kimenet
            movwf   TRISC

;----------------------------------------------------------------------
; A Txtemp kezdcm, 16 byte mret RAM buffer msolsa az EEPROM-ba
;
            rcall   Buffer_Load                 ; a RAM buffer feltltse
            rcall   EEnable                     ; EEPROM rs/trls engedlyezs
            movlw   16                          ; programozand rekeszek szma
            movwf   Counter
            movlw   16                          ; els EEPROM memriacm
            movwf   EE_addr
            lfsr    0, Txtemp                   ; adat msols indirekt cmzssel

;----------------------------------------------------------------------
Wrloop
            movff   POSTINC0, EE_data           ; adat msols indirekt cmzssel s pointer nvelssel
            rcall   EEwrite                     ; EEPROM rs
            incf    EE_addr,1                   ; EEPROM cm inkrementls
            decfsz  Counter,1                   ; 16 EEPROM rekesz rs megtrtnt?
            bra     Wrloop                      ; mg nem
;----------------------------------------------------------------------
            rcall   EEdisbl                     ; rs/trls tilts
;----------------------------------------------------------------------
; A Rxtemp kezcm, 16 byte mret RAM buffer feltltse az EEPROM-b
;
            movlw   16                          ; programozand rekeszek szma
            movwf   Counter
            movlw   16                          ; els EEPROM memriacm
            movwf   EE_addr
            lfsr    0, Rxtemp                   ; kiolvasott adatok kezdcme a RAM-ban
;----------------------------------------------------------------------
Rdloop
            rcall   EEread                      ; EEPROM olvass
            movff   EE_data, POSTINC0           ; indirekt adatmozgats a RAM-ba s pointer nvels
            incf    EE_addr,1                   ; EEPROM cm inkrementls
            decfsz  Counter,1                   ; 16 EEPROM rekesz olvass megtrtnt?
            bra     Rdloop                      ; mg nem
;----------------------------------------------------------------------
            nop
            lfsr    0, Rxtemp+15                ; indirekt mutatk belltsa
            lfsr    1, Txtemp+15
            movlw   16                          ; 16 adatot hasonltunk ssze
            movwf   Counter
            clrf    TRISD, 0
Hasonlit
            movff   Counter, LATD
            movf    POSTDEC0, W                 ; beolvass W-be nvelssel
            xorwf   POSTDEC1, W                 ; sszehasonltskor 0, ha egyezik. PTR1 nvekszik olvass utn
            bnz     Loop                        ; ha 0, akkor ugrik
            decfsz  Counter, F
            bra     Hasonlit
            setf    LATD                        ; minden LED vilgt
Loop
            movlw   0x80
            xorwf   LATD, F                     ; LED8 villogtatsa
            movlw   50
            movwf   Counter
Varakozik
            rcall   Delay
            decfsz  Counter,F
            bra     Varakozik
            bra     Loop                        ; vrakozs resetre
Delay
            movlw   66                          ; kb 10ms ksleltets Fosc=20MHz
            movwf   Timer1                      ; esetn
Delay1
            decfsz  Timer0,1
            bra     Delay1
            decfsz  Timer1,1
            bra     Delay1
            return

;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- SZUBRUTINOK ----------------------------
;----------------------------------------------------------------------
;
;----------------------------------------------------------------------
; A RAM buffer feltltse
;
Buffer_Load
            lfsr    0, Txtemp                   ; FSR0 Txtemp-re mutat
            clrf    TBLPTRU                     ; Tblzat mutat inicializlsa
            movlw   HIGH Adatok
            movwf   TBLPTRH
            movlw   LOW Adatok
            movwf   TBLPTRL
            movlw   16                          ; 16 byte beolvassa CODE memribl
            movwf   Counter
Bufld_loop
            tblrd*+                             ; Adat olvassa CODE memribl, pointer nvelssel
            movff   TABLAT, POSTINC0            ; Beolvasott adat msolsa, FSR0 pointer nvelssel
            decfsz  Counter                     ; Szmll cskkentse
            bra     Bufld_loop                  ; j byte olvassa, ha szmll <>
            return

Adatok                                          ; CODE memriba lv adatok
        data    "0123456789ABCDEF"
;-----------------------------------------------------------------------
; EEPROM rs/trls engedlyezse
;
EEnable
            bsf     LATA,CS                     ; EEPROM kivlasztsa
            movlw   12                          ; kilptetend bitek szma
            movwf   Clocks
            movlw   EWEN                        ; az engedlyezs kdjnak msolsa Temp-be
            movwf   Temp
            rcall   Bitout                      ; a kd kilptetse
            bcf     LATA,CS                     ; EEPROM kivlaszts megszntetse
            return
;-----------------------------------------------------------------------
; EEPROM rs/trls letiltsa
;
EEdisbl
            bsf     LATA,CS                     ; EEPROM kivlasztsa
            movlw   12                          ; kilptetend bitek szma
            movwf   Clocks
            movlw   EWDS                        ; az rs/trls tiltsi kd msolsa
            movwf   Temp
            rcall   Bitout                      ; a kd kilptetse
            bcf     LATA,CS                     ; EEPROM kivlaszts megszntetse
            return
;-----------------------------------------------------------------------
; Egy bjt beolvassa az EEPROM EE_addr cm rekeszbl az EE_data vltozba
;
EEread
            movlw   ROP                         ; az olvass kdjnak msolsa Temp-be
            movwf   Temp
            movlw   4                           ; kilptetend bitek szma
            movwf   Clocks
            bsf     LATA,CS                     ; EEPROM engedlyezse
            rcall   Bitout                      ; az olvass kd kilptetse
            movlw   8                           ; kilptetend bitek szma
            movwf   Clocks
            movf    EE_addr,0                   ; az aktulis EEPROM cm msolsa Temp-be
            movwf   Temp
            rcall   Bitout                      ; a cm kilptetse
            bcf     LATC,SDO
            movlw   8                           ; a beolvasand bitek szma
            movwf   Clocks
Read
            bsf     LATC,CLK                    ; CLK=1
            nop
            btfss   PORTC,SDI                   ; SDI bemenet msolsa a C bitbe
            bcf     STATUS,C
            btfsc   PORTC,SDI
            bsf     STATUS,C
            rlcf    EE_data,1                   ; C bit belptetse az EE_data regiszterbe
            bcf     PORTC,CLK                   ; CLK=0
            decfsz  Clocks,1                    ; az sszes bit beolvassa megtrtnt?
            bra     Read                        ; mg nem
;-----------------------------------------------------------------------
            bcf     LATA,CS                     ; EEPROM kivlaszts megszntetse
            return
;-----------------------------------------------------------------------
; Egy bjt bersa az EEPROM EE_addr cm rekeszbe
;
EEwrite
            movlw   WROP                        ; az rs kdjnak msolsa Temp-be
            movwf   Temp
            movlw   4                           ; kilptetend bitek szma
            movwf   Clocks
            bsf     LATA,CS                     ; EEPROM engedlyezse
            rcall   Bitout                      ; az rs kd kilptetse
            movlw   8                           ; kilptetend bitek szma
            movwf   Clocks
            movf    EE_addr,0                   ; az aktulis EEPROM cm msolsa Temp-be
            movwf   Temp
            rcall   Bitout                      ; a cm kilptetse
            movlw   8                           ; kilptetend bitek szma
            movwf   Clocks
            movf    EE_data,0                   ; az adat msolsa Temp-be
            movwf   Temp
            rcall   Bitout                      ; az adat kilptetse
            bcf     LATA,CS                     ; aktv L szint impulzus indtja az
            nop                                 ; nidzts rsi folyamatot
            bsf     LATA,CS
            nop
Busy
            btfss   PORTC,SDI                   ; vrakozs az rsi folyamat vgre
            bra     Busy
            bcf     LATA,CS                     ; EEPROM kivlaszts megszntetse
            return
;-----------------------------------------------------------------------
; A Clocks regiszterben meghatrozott szm bit kilptetse az SDO vonalon
;
Bitout
            rlcf    Temp,1                      ; Temp regiszter 7. bitjnek kilptetse
            bcf     LATC,SDO                    ; a Carry bitbe
            btfsc   STATUS,C                    ; C bit msolsa az SDO kimenet
            bsf     LATC,SDO
            nop
            bsf     LATC,CLK                    ; CLK=1
            nop
            nop
            nop
            bcf     LATC,CLK                    ; CLK=0
            decfsz  Clocks,1                    ; az sszes bit kilptetse megtrtnt
            bra     Bitout                      ; mg nem
            return
;-----------------------------------------------------------------------
        end