;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       OSCSW18.ASM                                       *
;    Dtum:         2002.09.06.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    rajel tkapcsolsi funkcit demonstrl program                 *
;    -----------------------------------------------------            *
;    A LED-soron 8 bites futfnyt valst meg.                       *
;    Az idzts a Timer3 segtsgvel, 2 ms lpsekben llthat,    *
;    ha a f OSC-rl fut.                                             *
;    amennyiben a kis teljesitmeny zemmdban van a processzor,      *
;    32,768 kHz kristlyrl mkdik, ezzel cskken a fogyaszas.       *
;    K0 nyomgomb nyomva tartsakor 32.768 kHz quartzrl mkdik a PIC*
;                                                                     *
;**********************************************************************
;
;
;
        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)


        CBLOCK
Timer1
Timer2
Timer3
Counter
        ENDC
;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            movlw   B'00111111'                 ; PORTA bemenet
            movwf   TRISA
            movlw   B'10101111'                 ; RB0..3 kimenet, RB4..7 bemenet
            movwf   TRISB
            clrf    TRISD                       ; PORTD kimenet
            bcf     INTCON2,NOT_RBPU            ; felhz ellenllsok konfigurlsa
            clrf    LATB

            setf    T1CON
;----------------------------------------------------------------------
Start
            movlw   33                          ; 33 elem a LED tblzat
            movwf   Counter
            clrf    TBLPTRU
            movlw   HIGH Table0
            movwf   TBLPTRH
            movlw   LOW Table0
            movwf   TBLPTRL

Start1
            tblrd*+
            movff   TABLAT, LATD
            rcall   Delay
            decfsz  Counter,F
            bra     Start1

;----------------------------------------------------------------------
            bra     Start
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;---------------------------- SZUBRUTINOK -----------------------------
;----------------------------------------------------------------------
;
Table0
        db      B'10000001', B'01000010'        ; '1'
        db      B'00100100', B'00011000'
        db      B'00100100', B'01000010'
        db      B'10000001', B'01000001'
        db      B'00100001', B'00010001'
        db      B'00001001', B'00000101'
        db      B'00000011', B'00000001'
        db      B'00000011', B'00000101'
        db      B'00001001', B'00010001'
        db      B'00100001', B'01000001'
        db      B'10000010', B'10000100'
        db      B'10001000', B'10010000'
        db      B'10100000', B'11000000'
        db      B'10000000', B'11000000'
        db      B'10100000', B'10010000'
        db      B'10001000', B'10000100'
        db      B'10000010'                     ; '32'
;----------------------------------------------------------------------
Delay
            movlw   10                          ; Timer3 x 20 ms
            movwf   Timer3
Delay0
            rcall   Delay1
            decfsz  Timer3,F
            bra     Delay0
            return
;----------------------------------------------------------------------
Delay1
            movlw   13                          ; kb. 2 ms ksleltets
            movwf   Timer2
Delay2
            decfsz  Timer1,1
            bra     Delay2
            btg     LATD, 4
            btg     LATD, 3
            btfsc   PORTB, 0                    ; ha a K0 gomb nincs lenyomva
            bcf     OSCCON, SCS                 ; OS1-OSC2 oszcilltor aktv
            btfss   PORTB, 0                    ; ha a K0 gomb le van nyomva
            bsf     OSCCON, SCS                 ; Timer1 az rajel forrsa (DS39564A pg. 20-21)
            decfsz  Timer2,1
            bra     Delay2
            return
;----------------------------------------------------------------------
        end
