;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       24LC16_8.ASM                                      *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    LED SOR KEZEL PROGRAM                                           *
;    ----------------------                                           *
;    A LED-soron 8 bites futfnyt valst meg.                       *
;    A sebessget a potencimter llsa hatrozza meg.               *
;    A program TMR0 megszaktst hasznl.                             *
;                                                                     *
;**********************************************************************
;
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;----------------------------------------------------------------------
;

	CBLOCK
Timer1
Timer2
Timer3
Counter
Temp
IT_Counter
AD_Result
	ENDC

;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
			bra		Start
;----------------------------------------------------------------------
; A szubrutin TMR0 tlcsordulskor hajtdik vgre. A szubrutin elmenti a 
; W s a STATUS regiszterek pillanatnyi llapott az aktulis bankba,
; visszatrskor pedig visszalltja azok elmentett rtkt.
; Minden 10. megszakts utn vgznk A/D konverzit.
;
        org     KezdVect+8                        ; reset vektor
			bcf     INTCON,T0IF
			decfsz	IT_Counter,1		; szmll dekrementlsa 
			bra		Subend						; mg nem 0
;----------------------------------------------------------------------
			movlw	10		; szmll visszallts
			movwf	IT_Counter	
			bsf		ADCON0,GO	; A/D konverzi indul
Subend
			retfie	FAST

Start
		nop
		movlw	B'11000001'				; RC oszcilltor, A/D engedlyezs
		movwf	ADCON0					; 0. csatorna (RA0) kivlaszts
		movlw	B'11000111'				; TMR0 eloszt= 1:256
		movwf	T0CON
		movlw	14
		movwf	ADCON1					; RA0 analg bemenet !!!
		setf	TRISA					; PORTA bemenet
		clrf	TRISD					; PORTD kimenet
		clrf	LATD
		movlw	10						; TMR0 tlcsorduls szmll kezdeti
		movwf	IT_Counter	; megszakts szmll bellts
		movlw	160
		movwf	INTCON		; TMR0 megszakts engedlyezs

;----------------------------------------------------------------------
			movlw	33				; 33 elem a LED tblzat
			movwf	Counter
			clrf	TBLPTRU
			movlw	HIGH Table0
			movwf	TBLPTRH
			movlw	LOW Table0
			movwf	TBLPTRL
			
Start1		tblrd*+
			movff	TABLAT, LATD
			rcall	Delay
			decfsz	Counter,F
			bra		Start1

;----------------------------------------------------------------------
			goto	Start
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;---------------------------- SZUBRUTINOK -----------------------------
;----------------------------------------------------------------------
;
Table0		
		db	B'10000001', B'01000010'	; '1'
		db	B'00100100', B'00011000'
		db	B'00100100', B'01000010'
		db	B'10000001', B'01000001'
		db	B'00100001', B'00010001'
		db	B'00001001', B'00000101'
		db	B'00000011', B'00000001'
		db	B'00000011', B'00000101'
		db	B'00001001', B'00010001'
		db	B'00100001', B'01000001'
		db	B'10000010', B'10000100'
		db	B'10001000', B'10010000'
		db	B'10100000', B'11000000'
		db	B'10000000', B'11000000'
		db	B'10100000', B'10010000'
		db	B'10001000', B'10000100'
		db	B'10000010'					; '32'
;----------------------------------------------------------------------
Delay			; Timer3 x 20 ms
			btfss	PIR1,ADIF			; vrakozs a teljes konverzira
   	  		bra		Ertekad
;----------------------------------------------------------------------
			bcf		PIR1, ADIF			; A/D bit trlse
			movff	ADRESH, AD_Result	; A/D konverzi eredmnynek msolsa
			tstfsz	AD_Result			; ha az eredmny 0, hozzadunk 1-et
			bra	Ertekad
			incf	AD_Result,1			; (ksleltets= A/D eredmny x 5ms)

Ertekad
			movff	AD_Result, Timer3

Delay0		rcall	Delay1
			decfsz	Timer3,F
			bra		Delay0
			return
;----------------------------------------------------------------------
Delay1		movlw	30		; kb. 20 ms
			movwf	Timer2
Delay2		decfsz	Timer1,1	
			bra		Delay2
			decfsz	Timer2,1	
			bra		Delay2
			return
;----------------------------------------------------------------------
		end

