;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       RS232S18.ASM                                      *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;    RS-232 INTERFSZ KEZELSE SZOFTVERES RUTINOKKAL                  *
;    -----------------------------------------------                  *
;    A program a 00h...FFh rtkek kztt vltoz Temp regiszter      *
;    tartalmt kldi ki a soros porton 9600 baud sebessggel.         *
;    Szoftveres ad/vev rutinokat hasznl.                           *
;    Az RS232 kommunikci adatformtuma: 9600-1-8-N-1.               *
;                                                                     *
;**********************************************************************
;
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)


	CBLOCK
Timer1
Bit_Cntr
Temp1
Temp
	ENDC
;----------------------------------------------------------------------
; PORTC bitek
;
	#define	TxData		LATC,6
	#define RxData		LATC,7
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
;----------------------------------------------------------------------
; PORTA, PORTC konfigurls
;
		movlw	14
		movwf	ADCON1		; RA0 analg bemenet !!!
		setf	TRISA    	; PORTA bemenet
		movlw	B'10111111'	; RC6 kimenet (TxD)
		movwf	TRISC
		movlw	64
		movwf	LATC		; TxD=1 nyugalmi jelszint bellts
;----------------------------------------------------------------------
		clrf	Temp
Loop
		incf	Temp,1		; Temp1 inkrementls
		movf	Temp,0		; Temp1 msolsa W-be
		rcall	RS232_Tx	; RS-232 ads
		bra		Loop		; 
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;---------------------------- SZUBRUTINOK -----------------------------
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
; Egy RS-232 bjt vtele
;
RS232_Rx
		        btfsc   RxData    ; start bit detektls (log0 szint)
                bra	    RS232_Rx	; nincs start jel, vrakozik tovbb
;----------------------------------------------------------------------
                rcall   Start_Delay     ; ft bitidnyi ksleltets
                movlw   8		; bitek szma
                movwf   Bit_Cntr
Rmit            
				rcall   Bit_Delay       ; teljes bitidnyi ksleltets
                btfss   RxData	; RxD bemenet msolsa C bitbe
				bcf     STATUS,C
                btfsc   RxData
				bsf     STATUS,C
				rrcf    Temp1,1		; Carry belptetse Temp1-be
				decfsz	Bit_Cntr,1	; sszes bit vtele megtrtnt?
				bra		Rmit		; mg nem
;----------------------------------------------------------------------
                rcall   Bit_Delay       ; Stop bit ksleltets
				return			; vtel ksz, vett adat Temp1-ben
;----------------------------------------------------------------------
; Egy RS-232 bjt adsa
;
RS232_Tx
		        movwf   Temp1		; adat msolsa Temp1-be
                movlw   8		; bitek szma
                movwf   Bit_Cntr
                bcf     TxData	; Start bit kikldse, log0 szint
                rcall   Bit_Delay       ; Start bit ksleltets
Xmit            rrcf    Temp1,1         ; kilptets LSB elszr, MSB utoljra
                btfss   STATUS,C	; Carry msolsa a TxD kimenetre
		        bcf     TxData
		        btfsc   STATUS,C
		        bsf     TxData
                rcall   Bit_Delay       ; bit ksleltets
Xmit2           decfsz  Bit_Cntr,1	; sszes bit adsa megtrtnt?
                bra     Xmit		; mg nem
;----------------------------------------------------------------------
                bsf     TxData
                rcall   Bit_Delay       ; Stop bit kikldse, log1 szint
                return
;----------------------------------------------------------------------
; RS232 startbit ksleltets
;
Start_Delay     movlw   85		; 52 us / 9600 Baud
                movwf   Timer1
Loop2           decfsz  Timer1,1
                bra     Loop2
                return
;----------------------------------------------------------------------
; RS232 bit id bellits
;
Bit_Delay       movlw   172		; 104,2 us / 9600 Baud
                movwf   Timer1 
Loop1           decfsz  Timer1,1
		        bra    Loop1
                return
;----------------------------------------------------------------------
		end

