;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       24LC16_8.ASM                                      *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    24LC16B I2C SOROS EEPROM BYTE/PAGE R/OLVAS PROGRAM            *
;    -----------------------------------------------------            *
;    Az EEPROM a mikrovezrl szinkron soros portjra csatlakozik,    *
;    melynek kivezetseit szoftveres rutinok kezelik.                 *
;    A program az EEPROM Start_Address cmtl kezdd 10 bjtos      *
;    terlett a mikrovezrl adatmemrija Datao cmtl kezdd      *
;    terletnek adataival rja fell.                                *
;    A visszaolvasott adatok a Datai kezdcm bufferbe kerlnek.     *
;                                                                     *
;**********************************************************************
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;
;----------------------------------------------------------------------
Start_Address   equ     0x302                   ; EEPROM clterletnek kezd cme
Slave           equ     B'10100000'             ; EEPROM I2C cme (B'1010xxxx')


        CBLOCK
Flag                                            ; program sttusz regiszter
Addr_Lo                                         ; EEPROM cm als bjt trolja
Addr_Hi                                         ; EEPROM cm 3 fels bit trolja
Txbuf                                           ; Tx buffer, tmeneti trol
Rxbuf                                           ; Rx buffer, tmeneti trol
Counter                                         ; bit szmll
Timer0                                          ; ksleltets szmll als bjt
Timer1                                          ; ksleltets szmll fels bjt
Byte_num                                        ; lap rs/olvass bjt szmll
; Bejv buffer
Datai:16                                        ; EEPROM-bl olvasott adatok kezdcme
; Kimeneti buffer
Datao:16                                        ; beprogramozand adatok kezdcme
        ENDC
;----------------------------------------------------------------------
;Flag                                           ; program sttusz regiszter
Err1            equ     0                       ; bit0: hiba flag
;----------------------------------------------------------------------
; PORTC kivezetsek
;
SCL             equ     3                       ; RC3, I2C soros rajel
SDA             equ     4                       ; RC4, I2C be/kimeneti adat
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
;----------------------------------------------------------------------
; PORTA, PORTC konfigurlsa
;
Start
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            setf    TRISA                       ; PORTA bemenet
            setf    TRISC                       ; PORTC bemenet
;----------------------------------------------------------------------
; Datao kezdcm adatmemria terlet feltltse
;
            lfsr    0, Datao                    ; Indirekt cmzs belltsa
            movlw   UPPER Tabla                 ; Tblzat mutat belltsa
            movwf   TBLPTRU
            movlw   HIGH Tabla
            movwf   TBLPTRH
            movlw   LOW Tabla
            movwf   TBLPTRL

            movlw   10                          ; 10 adatot olvasunk be
            movwf   Counter
Feltolt
            tblrd*+                             ; Tblzat olvassa mutat lptetssel
            movff   TABLAT, POSTINC0
            decfsz  Counter, F
            bra     Feltolt

;----------------------------------------------------------------------
; Az EEPROM adott terletnek feltltse s visszaolvassa
;
            movlw   low Start_Address
            movwf   Addr_Lo                     ; EEPROM cm als bjt msolsa
            movlw   high Start_Address
            movwf   Addr_Hi                     ; EEPROM cm fels bitek msolsa
            rcall   Wrpage                      ; laprs (max. 16 bjt)
;----------------------------------------------------------------------
            rcall   Delay                       ; vr a bels mkds befejezdsre
;----------------------------------------------------------------------
            movlw   low Start_Address
            movwf   Addr_Lo                     ; EEPROM cm als bjt msolsa
            movlw   high Start_Address
            movwf   Addr_Hi                     ; EEPROM cm fels bitek msolsa
            rcall   Rdpage                      ; szekvencilis olvass
;----------------------------------------------------------------------

;----------------------------------------------------------------------
;*********************** Ellenrzs ***********************************
; Hiba esetn az els hibs byte binris kombincija vilgt
; Helyes mvelet esetn minden LED vilgt
; Befejezett mveletet LED8 villogsa jelzi.
;----------------------------------------------------------------------

            lfsr    0, Datai+9                  ; Indirekt cmzs belltsa
            lfsr    1, Datao+9
            movlw   10
            movwf   Counter
            clrf    TRISD, 0                    ; LED-ek sttek
Hasonlit
            movff   Counter, LATD               ; Szmll megjelentse a LED soron
            movf    POSTDEC0, W                 ; Beolvass W-be, MUTAT0 lptetssel
            xorwf   POSTDEC1, W                 ; sszehasonlts MUTAT1 lptetssel
            bnz     Loop                        ; Amennyiben klnbzik a kt adat, hiba
            decfsz  Counter, F
            bra     Hasonlit
            setf    LATD                        ; Minden LED vilgt
Loop       
            movlw   0x80
            xorwf   LATD, F                     ; LED 8 villogtatsa
            movlw   50                          ; Ksleltets
            movwf   Counter
Varakozik
            rcall   Delay
            decfsz  Counter,F
            bra     Varakozik
            bra     Loop                        ; vrakozs resetre
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;***************************** SZUBRUTINOK ****************************
;----------------------------------------------------------------------
;
;----------------------------------------------------------------------
; Bjt rs, egy bjtot r az EEPROM adott cm rekeszbe
;
Wrbyte          
            rcall   Bstart                      ; START bit generls
            movlw   Slave                       ; Slave cm msolsa
            movwf   Txbuf                       ; a TXbuf regiszterbe
            bcf     STATUS,C                    ; R/W bitet 0-ba lltja
            rlcf    Addr_Hi,0                   ; Addr_Hi -> w
            addwf   Txbuf,1                     ; Txbuf a cmbiteket is tartalmazza
            rcall   Tx                          ; slave cm kikldse (ACK detektls)
            movff   Addr_Lo,Txbuf               ; EEPROM cm als bjt msolsa a Txbuf regiszterbe
            rcall   Tx                          ; cm kikldse (ACK detektls)
            movff   Datao,Txbuf                 ; programozand adat msolsa a Txbuf regiszterbe
            rcall   Tx                          ; adat kikldse (ACK detektls)
            rcall   Bstop                       ; STOP bit generls
            return
;----------------------------------------------------------------------
; Bjt olvass, egy bjtot olvas az EEPROM adott cm rekeszbl
;
Rdbyte
            rcall   Bstart                      ; START bit generls
            movlw   Slave                       ; Slave cm msolsa a TXbuf
            movwf   Txbuf                       ; regiszterbe
            bcf     STATUS,C                    ; R/W bitet 0-ba lltja
            rlcf    Addr_Hi,0                   ; Addr_Hi -> w
            addwf   Txbuf,1                     ; Txbuf a cmbiteket is tartalmazza
            rcall   Tx                          ; slave cm kikldse (ACK detektls)
            movff   Addr_Lo, Txbuf              ; EEPROM cm als bjt msolsa a Txbuf regiszterbe
            rcall   Tx                          ; cm kikldse (ACK detektls)
            rcall   Bstart                      ; ismtelt START bit generls
            movlw   Slave                       ; Slave cm msolsa a TXbuf
            movwf   Txbuf                       ; regiszterbe
            bsf     STATUS,C                    ; olvass md bellts (R/W = 1)
            rlcf    Addr_Hi,0                   ; Addr_Hi -> w
            addwf   Txbuf,1                     ; Txbuf a cmbiteket is tartalmazza
            rcall   Tx                          ; slave cm kikldse (ACK detektls)
            rcall   Rx                          ; adat beolvass
            rcall   Bstop                       ; STOP bit generls
            movff   Rxbuf, Datai                ; a vett adat msolsa a Datai regiszterbe
            return
;----------------------------------------------------------------------
; Laprs, max 16 bjt rsa az EEPROM-ba
;
Wrpage
            rcall   Bstart                      ; START bit generls
            movlw   Slave                       ; Slave cm msolsa a TXbuf
            movwf   Txbuf                       ; regiszterbe
            bcf     STATUS,C                    ; R/W bitet 0-ba lltja
            rlcf    Addr_Hi,0                   ; Addr_Hi -> w
            addwf   Txbuf,1                     ; Txbuf a cmbiteket is tartalmazza
            rcall   Tx                          ; slave cm kikldse (ACK detektls)
            movff   Addr_Lo,Txbuf               ; EEPROM cm als bjt msolsa a Txbuf regiszterbe
            rcall   Tx                          ; cm kikldse (ACK detektls)
            movlw   10                          ; kikldend bjtok szma
            movwf   Byte_num

            lfsr    0, Datao                    ; adatmemria kezdcm -> FSR
Wrpage1
            movff   POSTINC0,Txbuf              ; adatmozgats indirekt cmzssel a bufferbe, novelessel
            rcall   Tx                          ; adat kiklds (ACK detektls)
            decfsz  Byte_num,f                  ; az sszes bjtot kikldtk?
            bra     Wrpage1                     ; mg nem
;----------------------------------------------------------------------
            rcall   Bstop                       ; STOP bit generls
            return


;----------------------------------------------------------------------
; Szekvencilis adat olvass az EEPROM-bl
; ACKNOWLEDGE jelet most a master adja!
;
Rdpage
            rcall   Bstart                      ; START bit generls
            movlw   Slave                       ; Slave cm msolsa a TXbuf
            movwf   Txbuf                       ; regiszterbe
            bcf     STATUS,C                    ; R/W bitet 0-ba lltja
            rlcf    Addr_Hi,W                   ; Addr_Hi -> w
            addwf   Txbuf,1                     ; Txbuf a cmbiteket is tartalmazza
            rcall   Tx                          ; slave cm kikldse (ACK detektls)
            movff   Addr_Lo, Txbuf              ; EEPROM cm als bjt msolsa a Txbuf regiszterbe
            rcall   Tx                          ; cm kikldse (ACK detektls)
            rcall   Bstart                      ; ismtelt START bit generls
            movlw   Slave                       ; Slave cm msolsa a TXbuf
            movwf   Txbuf                       ; regiszterbe
            bsf     STATUS,C                    ; olvass md bellts (R/W = 1)
            rlcf    Addr_Hi,W                   ; Addr_Hi -> w
            addwf   Txbuf,1                     ; Txbuf a cmbiteket is tartalmazza
            rcall   Tx                          ; slave cm kikldse (ACK detektls)
            movlw   10                          ; beolvasand btok szma
            movwf   Byte_num
            lfsr    0, Datai                    ; adatmemria kezdcm -> FSR
Rdpage1
            rcall   Rx                          ; adatbeolvass
            rcall   Ackn_rx                     ; acknowledge bit ellenrzse
            movff   Rxbuf, POSTINC0
            decfsz  Byte_num,1                  ; az sszes bjtot beolvastuk?
            bra     Rdpage1                     ; mg nem
;----------------------------------------------------------------------
            rcall   Bstop                       ; STOP bit generls
            return
;----------------------------------------------------------------------
; START bit generls (SCL magas szintje mellett SDA magasbl alacsonyba megy)
;
Bstart
            movlw   24                          ; SCL, SDA magas szintek
            movwf   LATC
            movlw   B'11100111'                 ; SCL, SDA vonalak kimenetek
            movwf   TRISC
            bcf     LATC,SDA                    ; SDA magasbl alacsonyba megy
            nop                                 ; idzts
            nop
            nop
            bcf     LATC,SCL                    ; rajel is alacsony szint lesz
            return
;----------------------------------------------------------------------
; STOP bit generls (SDA alacsonybl magasba megy SCL magas szintje mellett)
;
Bstop
            bcf     PORTC,SDA                   ; SDA alacsony szint
            movlw   B'11100111'                 ; SCL, SDA vonalak kimenetek
            movwf   TRISC
            nop
            bsf     PORTC,SCL                   ; SCL magas szint
            nop
            nop
            nop
            bsf     PORTC,SDA                   ; SDA alacsonybl magasba megy
            setf    TRISC
            return
;----------------------------------------------------------------------
Delay
            movlw   66                          ; kb 10ms ksleltets Fosc=20MHz
            movwf   Timer1                      ; esetn
Delay1
            decfsz  Timer0,1
            bra     Delay1
            decfsz  Timer1,1
            bra     Delay1
            return
;----------------------------------------------------------------------
; Adatbjt ads szubrutin
; 8 bitet lptet ki az SDA vonalon, mg az rajelet az SCL vonalon adja.
;
Tx
            movlw   B'11100111'                 ; SCL, SDA vonalak kimenetek
            movwf   TRISC
            movlw   8                           ; bitek szma 8
            movwf   Counter
Txloop
            btfsc   Txbuf,7                     ; Txbuf bit7 msolsa SDA vonalra
            bsf     LATC,SDA
            btfss   Txbuf,7
            bcf     LATC,SDA
            nop
            bsf     PORTC,SCL                   ; SCL=1, rajel magas szint
            rlcf    Txbuf,F                     ; Txbuf lptetse (Carry-n keresztl)
            nop
            nop
            nop
            nop
            nop
            nop
            nop
            bcf     LATC,SCL                    ; SCL=0, rajel alacsony szint
            decfsz  Counter,F                   ; 8 bit tvitele megtrtnt?
            bra     Txloop                      ; mg nem
;----------------------------------------------------------------------
            bcf     LATC,SDA                    ; SDA vonal alacsonyba lltsa
Ackn_test
            movlw   B'11110111'                 ; SDA vonal bemenet, SCL kimenet
            movwf   TRISC
            bsf     LATC,SCL                    ; SCL=1, rajel magas szint
            btfsc   PORTC,SDA                   ; acknowledge bit ellenrzse
            bsf     Flag,Err1                   ; hiba esetn Err1 bitet 1-be lltja
            nop
            nop
            nop
            bcf     LATC,SCL                    ; SCL=0, rajel alacsony szint
            return
;----------------------------------------------------------------------
; Adatbjt vteli szubrutin
;
Rx
            movlw   B'11110111'                 ; SDA vonal bemenet, SCL kimenet
            movwf   TRISC
            movlw   8
            movwf   Counter                     ; bitek szma 8
Rxloop
            bsf     LATC,SCL                    ; SCL=1, rajel magas szint
            nop
            btfsc   PORTC,SDA                   ; SDA msolsa Carry bitbe
            bsf     STATUS,C
            btfss   PORTC,SDA
            bcf     STATUS,C
            rlcf    Rxbuf,F                     ; carry belptetse RXbuf regiszterbe
            nop
            bcf     LATC,SCL                    ; SCL=0, rajel alacsony szint
            decfsz  Counter,1                   ; sszes bit vtele megtrtnt
            bra     Rxloop                      ; mg nem
            return

;----------------------------------------------------------------------
; Adatbjt vtel utn a master adja az ACKNOWLWDGE bitet
;
Ackn_rx
            movlw   B'11100111'                 ; SDA, SCL vonalak kimenetek
            movwf   TRISC
            bcf     LATC,SDA                    ; SDA=0, adatbit trlse
            nop
            nop
            bsf     LATC,SCL                    ; SCL=1, rajel magas szint
            nop
            nop
            nop
            nop
            nop
            bcf     LATC,SCL                    ; SCL=0, rajel alacsony szint
            return
;----------------------------------------------------------------------

Tabla

        dw      0x0011, 0x2233, 0x4455, 0x6677, 0x8899

            end
