;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       EEPROM18.ASM                                      *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    PIC18F442 ADAT EEPROM MEMRIA R/OLVAS DEMO PROGRAM            *
;    -----------------------------------------------------            *
;    A program a 0, 1, 2 s 3 cm EEPROM rekeszekbe rendre a 66H,    *
;    77H, 88H illetve 99H bjtokat rja, majd a 2-es cm rekesz      *
;    tartalmt visszaolvassa az EEPROM_Data vltozba.                *
;                                                                     *
;**********************************************************************
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;

;----------------------------------------------------------------------
;

        CBLOCK
EEPROM_Address                                  ; EEPROM cm tmeneti tr
EEPROM_Data                                     ; EEPROM adat tmeneti tr
Counter
Timer0
Timer1
        ENDC
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAM ------------------------------
;----------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
;
;----------------------------------------------------------------------
; I/O portok konfigurlsa
;
Start
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            movlw   B'00111111'                 ; PORTA bemenet
            movwf   TRISA

;----------------------------------------------------------------------
; EEPROM adatmemria rs/olvass
;
            movlw   0                           ; cm bellts
            movwf   EEPROM_Address
            movlw   H'66'                       ; adat bellts
            movwf   EEPROM_Data
            rcall   EE_Write                    ; EEPROM rs
            movlw   1
            movwf   EEPROM_Address
            movlw   H'77'
            movwf   EEPROM_Data
            rcall   EE_Write
            movlw   2
            movwf   EEPROM_Address
            movlw   H'88'
            movwf   EEPROM_Data
            rcall   EE_Write
            movlw   3
            movwf   EEPROM_Address
            movlw   H'99'
            movwf   EEPROM_Data
            rcall   EE_Write
;----------------------------------------------------------------------
            movlw   2                           ; cm bellts
            movwf   EEPROM_Address
            rcall   EE_Read                     ; EEPROM olvass
;----------------------------------------------------------------------

            clrf    TRISD                       ; PORTD kimenet
            setf    LATD                        ; Minden LED vilgt
            movf    EEPROM_Data, W              ; Beolvasott adat komparlsa
            xorlw   H'88'                       ; a Bert adattal
            bz      Loop                        ; Ha helyes, akkor ugrik
            clrf    LATD                        ; LEDEK kioltsa
Loop
            movlw   0x80
            xorwf   LATD, F
            movlw   50
            movwf   Counter
Varakozik
            rcall   Delay
            decfsz  Counter,F
            bra     Varakozik
            bra     Loop                        ; vrakozs resetre

Delay
            movlw   66                          ; kb 10ms ksleltets Fosc=20MHz
            movwf   Timer1                      ; esetn
Delay1
            decfsz  Timer0,1
            bra     Delay1
            decfsz  Timer1,1
            bra     Delay1
            return
;----------------------------------------------------------------------
;
;
;
;----------------------------------------------------------------------
;***************************** SZUBRUTINOK ****************************
;----------------------------------------------------------------------
;
;----------------------------------------------------------------------
;                               Adat EEPROM rsa
;----------------------------------------------------------------------
EE_Write

            movff   EEPROM_Address, EEADR       ; EEPROM cm
            movff   EEPROM_Data, EEDATA         ; Berand adat
            clrf    EECON1                      ; Adat EEPROM memria kivlaszts
            bsf     EECON1,WREN                 ; rs engedlyezs
            bcf     INTCON,GIE                  ; Megszaktsok tiltsa
;----------------------------------------------------------------------
            movlw   0x55                        ; ********************
            movwf   EECON2                      ; * rsi szekvencia *
            movlw   0xAA                        ; *                  *
            movwf   EECON2                      ; ********************
            bsf     EECON1,WR                   ; rsi folyamat indtsa
;----------------------------------------------------------------------
Busy
            btfss   PIR2, EEIF                  ; vr az nidzts rsi
            bra     Busy                        ; folyamat vgre
            bcf     EECON1, WREN
;----------------------------------------------------------------------
            bcf     PIR2,EEIF                   ; EEPROM rs komplett flag trlse
            return
;----------------------------------------------------------------------

;----------------------------------------------------------------------
;                               Adat EEPROM olvassa
;----------------------------------------------------------------------
EE_Read
            movff   EEPROM_Address, EEADR       ; Cm megadsa
            bcf     EECON1, EEPGD               ; Adat EEPROM olvass
            bsf     EECON1, RD                  ; Olvass indtsa
            movf    EEDATA, W
            movwf   EEPROM_Data                 ; Eredmny elmentse (ERRATA doc. DS80122D)
            return
;----------------------------------------------------------------------
        end
