;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       FESZME8.ASM                                       *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    FESZLTSGMR PROGRAM                                           *
;    ----------------------                                           *
;    Az A/D konverzi eredmnyt vilgt fnycsk formjban         *
;    az LCD kijelzn jelenti meg. A fnycsk hossza az analg jel    *
;    nagysgval arnyos.                                             *
;    A mintavtel gyakorisgt a TMR0 tlcsordulsa hatrozza meg.    *
;                                                                     *
;**********************************************************************
;
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)


        CBLOCK
Timer1
Timer2
Counter
OvfCntr
        ENDC
;-------------------------------------------------------------------------------
; PORTE kivezetsek
;
RS              equ     0                       ; 0= utasts, 1= adat reg. vlaszts
RdWr            equ     1                       ; R/W=0 LCD rs, R/W=1 LCD memria olvass
E               equ     2                       ; 0= LCD tilts, 1= engedlyezs
;-------------------------------------------------------------------------------
;
;
;
;------------------------------------------------------------------------------
;--------------------------------- FPROGRAM ----------------------------------
;------------------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
;------------------------------------------------------------------------------
; Port bellts
;
            movlw   B'11000001'                 ; RC oszcilltor, A/D engedlyezs
            movwf   ADCON0                      ; 0. csatorna (RA0) kivlaszts
            clrf    LATD
            clrf    LATE
            movlw   B'11000111'                 ; TMR0 eloszt= 1:256, 8 bites zemmd
            movwf   T0CON
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            setf    TRISA                       ; PORTA bemenet
            clrf    TRISD                       ; PORTD kimenet
            clrf    TRISE                       ; PORTE kimenet
            movlw   7                           ; tlcsorduls szmll kezdeti rtke
            movwf   OvfCntr
;-------------------------------------------------------------------------------
; LCD kijelz inicializlsa
;
            bcf     LATE,RS                     ; LCD parancs kvetkezik
            movlw   56                          ; 38h, 8 bit interface set
            rcall   Write
            rcall   Kesl                        ; Busy flag olvasst "helyettesti"
            movlw   56
            rcall   Write
            movlw   6                           ; 06h, Entry mode set: increment
            rcall   Write
            movlw   12                          ; 0dh, Display on, cursor/blink off
            rcall   Write
            movlw   16                          ; 10h, Display/cursor shift: cursor
            rcall   Write
            movlw   1                           ; 01h, Display clear
            rcall   Write
            rcall   Kesl2                       ; Busy flag olvasst "helyettesti"
;-------------------------------------------------------------------------------
; A TMR0 tlcsorduls nem okoz megszaktst, (hiszen azt nem is engedlyeztk)
; de bekvetkeztt a T0IF flag vizsglatval figyeljk.
; A/D konverzit minden 7. TMR0 tlcsordulsra vgznk (kb 0,1 mp-knt).
;
Start
            btfss   INTCON,T0IF                 ; TMR0 tlcsorduls volt?
            bra     Start                       ; mg nem
;------------------------------------------------------------------------------
            bcf     INTCON,T0IF                 ; igen, flag trls
            decfsz  OvfCntr,1                   ; tlcsorduls szmll dekrementlsa
            bra     Start                       ; mg nem 0
;------------------------------------------------------------------------------
            movlw   7                           ; mintavtel 10 tlcsordulsonknt
            movwf   OvfCntr                     ; szmll visszallts
            bsf     ADCON0,GO                   ; A/D konverzi start
Wait
            btfss   PIR1,ADIF                   ; vrakozs a teljes konverzira
            bra     Wait
;------------------------------------------------------------------------------
; Szintkijelzs az LCD kijelzn
;
            bcf     LATE,RS                     ; LCD parancs
            movlw   1                           ; 01h, Display clear
            rcall   Write
            rcall   Kesl2
            bsf     LATE,RS                     ; LCD adat kvetkezik
            swapf   ADRESH,W                    ; ADRESH fels flbjt msols W-be
            andlw   15
            movwf   Counter
            xorlw   0                           ; ha a fels 4 bit 0, nincs kijelzs
            bz      Start                       ; ha 0, akkor ugrik
;------------------------------------------------------------------------------
Kijelzes
            movlw   255
            rcall   Write
            decfsz  Counter,1
            goto    Kijelzes
;------------------------------------------------------------------------------
            bra             Start
;------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;---------------------------- SZUBRUTINOK --------------------------------------
;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
; LCD rs lpsei:
; -----------------
;   1/   RS, R/W belltsa
;   2/   E=1
;   3/   adat kiklds
;   4/   ksleltets (100us)
;   5/   E=0
;
Write
            movwf   LATD
            bsf     LATE,E
            rcall   Kesl100                     ; Busy flag olvasst "helyettesti"
            bcf     PORTE,E
            return
;-------------------------------------------------------------------------------
Kesl100
            movlw   165                         ; 100us ksleltets
            movwf   Timer1
Kesl1
            decfsz  Timer1,1
            bra     Kesl1
            return
;-------------------------------------------------------------------------------
Kesl2
            clrf    Timer1                      ; 2ms ksleltets
            movlw   20
            movwf   Timer2
Kesl21
            rcall   Kesl100
            decfsz  Timer2,1
            bra     Kesl21
            return
;-------------------------------------------------------------------------------
Kesl
            rcall   Kesl2
            rcall   Kesl2
            rcall   Kesl2
            rcall   Kesl2
            rcall   Kesl2
            return                              ; 5x2ms ksleltets
;-------------------------------------------------------------------------------
        end
