;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       FREQ18.ASM                                        *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    FORDULATSZM/FREKVENCIAMR (TMR0, TMR1 DEMO) PROGRAM            *
;    -----------------------------------------------------            *
;    A Timer1 aszinkron mdban fut s 1msodpercenknt megszaktst   *
;    kr. A TMR1 modul sajt oszcilltort hasznlja, az idzt      *
;    elem az RC0 s az RC1 kivezetsek kz kapcsolt 32,768kHz-es     *
;    kvarc. A Timer0 az RA4 bemenetre rkez impulzusok lefut leit  *
;    szmolja. A szmllls eredmnye a Timer1 temezsvel a LED    *
;    soron jelenik meg, binris formban.                             *
;    A Timer0 elosztja 1/1, gy a max. bemen frekvencia 255Hz.     *
;    (Ez a frekvenciartk egy 4 tem, 4 hengeres motor esetn kb.   *
;    15000 percenknti fordulatszmnak felel meg.)                    *
;                                                                     *
;**********************************************************************
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;------------------------------------------------------------------------------
;
;
;
;------------------------------------------------------------------------------
;-------------------------------- PROGRAM START -------------------------------
;------------------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
            bra             Start
;------------------------------------------------------------------------------
;
;
;------------------------------------------------------------------------------
;------------------------------- INTERRUPT RUTIN ------------------------------
;------------------------------------------------------------------------------
;
        org     8                               ; Alacson prioritsu IT vektor
            bcf     PIR1,TMR1IF                 ; Timer1 IT flag trls
            movff   TMR0L,LATD                  ; kijelzs
            clrf    TMR0L
            movlw   H'80'                       ; Timer1=8000h bellts
            movwf   TMR1H
            clrf    TMR1L
            retfie
;------------------------------------------------------------------------------
;
;
;------------------------------------------------------------------------------
;----------------------------------- FPROGRAM --------------------------------
;------------------------------------------------------------------------------
;
;
;------------------------------------------------------------------------------
; I/O portok konfigurlsa
;
Start
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            movlw   B'00111111'                 ; RA0..RA5 bemenet
            movwf   TRISA
            setf    TRISC
            clrf    TRISD                       ; PORTD kimenet
;------------------------------------------------------------------------------
; Timer0 konfigurlsa
;
            setf    T0CON                       ; default rtk: eloszt=1 s TMR0 az RA4 lefut leit szmllja
;------------------------------------------------------------------------------
; Timer1 konfigurlsa
;
            movlw   1                           ; TMR1IE=1
            movwf   PIE1                        ; Timer1 megszakts engedlyezs
            clrf    LATD                        ; PORTD trls
            movlw   14                          ; Timer1 bellts: TMR1 oszc. eng.,
            movwf   T1CON                       ; eloszt=1, aszinkron md
            clrf    INTCON                      ; megszaktsok tiltsa
;------------------------------------------------------------------------------
            bcf     T1CON,TMR1ON                ; Timer1 megllts
            bcf     PIR1,TMR1IF                 ; Timer1 IT flag trls
            movlw   H'80'                       ; Timer1=8000h bellts,
            movwf   TMR1H                       ; gy 1 msodpercenknt kr megszaktst
            clrf    TMR1L
            movlw   192                         ; GIE=1, PEIE=1
            movwf   INTCON                      ; Timer1 IT engedlyezs
            bsf     T1CON,TMR1ON                ; Timer1 start
Loop
            bra     Loop                        ; resetre vr
;------------------------------------------------------------------------------
        end
