;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       GOMBOK18.ASM                                      *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    4X4-ES BILLENTYZET KEZEL SPROGRAM                              *
;    ----------------------------------                               *
;    A LED soron a lenyomott billenty kdjt jeleniti meg.           *
;    0x10 kd jelentse: nincs  lenyomott billenty.                  *
;    A billentyzet sorainak vezrlst a PIC16F877 mikrovezrl      *
;    RB0...RB3 kivezetsei vgzik, mg a fggleges vezetkek         *
;    jeleinek beolvassa az RB4 s RB5, illetve az RA3 s RA5         *
;    kivezetsek feladata.                                            *
;    A portkivezetsek ilyen konfigurlsnak elnye, hogy egy        *
;    lenyomott billenty felbresztheti a SLEEP md mikrovezrlt.   *
;                                                                     *
;**********************************************************************
;
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;-------------------------------------------------------------------------------
;
        CBLOCK
Timer1                                          ; ksleltet szubrutin szmllja, LO
Timer2                                          ; ksleltet szubrutin szmllja, HI
Rows                                            ; sor szmll
Key                                             ; billenty kd trolja
Temp
        ENDC

;-------------------------------------------------------------------------------
; PORTA s PORTB kivezetsek, melyek a billentyzetet olvassk
;
#define         Col1    PORTB,4                 ; RB4
#define         Col2    PORTB,5                 ; RB5
#define         Col3    PORTA,3                 ; RA3
#define         Col4    PORTA,5                 ; RA5
;
;
;
;-------------------------------------------------------------------------------
;----------------------------- FPROGRAM ---------------------------------------
;-------------------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
;-------------------------------------------------------------------------------
; PORTA, PORTB, PORTD konfigurlsa
;
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            movlw   B'00111111'                 ; PORTA bemenet
            movwf   TRISA
            movlw   B'11110000'                 ; RB0..3 kimenet, RB4..7 bemenet
            movwf   TRISB
            clrf    TRISD                       ; PORTD kimenet
            bcf     INTCON2, NOT_RBPU           ; felhz ellenllsok konfigurlsa
;-------------------------------------------------------------------------------
Start
            rcall   Scan                        ; billentyzet vizsglata
            movf    Key,0                       ; lenyomott billenty kd -> W
            movwf   LATD                        ; W -> PORTD
            rcall   Delay                       ; ksleltets
            bra     Start                       ; ismt
;-------------------------------------------------------------------------------
;
;
;
;-------------------------------------------------------------------------------
;---------------------------- SZUBRUTINOK --------------------------------------
;-------------------------------------------------------------------------------
;
;
;-------------------------------------------------------------------------------
Delay
            decfsz  Timer1,1                    ; ksleltet szubrutin
            bra     Delay
            decfsz  Timer2,1
            bra     Delay
            return
;-------------------------------------------------------------------------------
; 4x4-es billentyzet vizsglata.
; Ha lenyomott gombot tall, a szubrutin befejezdik, s a Key vltoz
; a billenty kdjt tartalmazza. Ha nincs lenyomott billenty Key rtke
; 0x10 lesz. A szubrutin a billentyket egyenknt tapogatja le.
; A K0 jel nyomgombhoz Key=0, a K1-hez Key=1, a K2-hz Key=2, ... stb.
; mg vgl a K15 jel nyomgombhoz Key=15 rtk tartozik.
;
Scan
            clrf    Key                         ; Key vltoz trlse
            movlw   4
            movwf   Rows                        ; 4 nyomgomb sor van
            movlw   14
            movwf   Temp                        ; Temp kezdeti rtke 14, gy
            bra     Scan1                       ; a B portra xxxx1110 kerl ki!
;-----------------------------------------------------------------------------
Scan0
            bsf     STATUS,C
            rlcf    Temp,1                      ; Carry belptetse a Temp regiszterbe
Scan1
            movff   Temp,LATB                   ; Temp msolsa PORTB-re
            nop
            btfss   Col1                        ; els oszlopban van-e lenyomott gomb?
            return                              ; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
            incf    Key,1                       ; billenty kd inkrementls
            btfss   Col2                        ; 2. oszlopban van-e lenyomott gomb?
            return                              ; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
            incf    Key,1                       ; billenty kd inkrementls
            btfss   Col3                        ; 3. oszlopban van-e lenyomott gomb?
            return                              ; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
            incf    Key,1                       ; billenty kd inkrementls
            btfss   Col4                        ; 4. oszlopban van-e lenyomott gomb?
            return                              ; ha igen, vge a vizsglatnak
;-----------------------------------------------------------------------------
            incf    Key,1                       ; billenty kd inkrementls
            decfsz  Rows,1                      ; sor szmll cskkents
            bra     Scan0                       ; mg nem vizsgltunk meg mind a 4 sort
;-----------------------------------------------------------------------------
            return
;-----------------------------------------------------------------------------
        end