;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       LCD18.ASM                                         *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    LCD kijelz vezrl program                                      *
;    ---------------------------                                      *
;    Ktsoros szveg kiiratsa az LCD kijelzre.                      *
;                                                                     *
;**********************************************************************
;
;
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;-------------------------------------------------------------------------------
;
;                          LCD UTASTSOK
;-------------------------------------------------------------------------------
;              LCD kijelz kivezetsei
;   RS   R/W  DB7 DB6 DB5 DB4 DB3 DB2 DB1 DB0   Funkci  (vgrehajtsi id)
;-------------------------------------------------------------------------------
;    0    0   0   0   0   0   0   0   0   1     Display clear        (1,6ms)
;    0    0   0   0   0   0   0   0   1   x     Display, cursor home (1,6ms)
;    0    0   0   0   0   0   0   1  I/D  S     Entry mode set       (40us)
;    0    0   0   0   0   0   1   D   C   B     Display ON/OFF       (40us)
;    0    0   0   0   0   1  S/C R/L  x   x     Display/Cursor shift (40us)
;    0    0   0   0   1   DL  N   x   x   x     Function set         (40us)
;    0    0   0   1   ------ CG ADDR ------     CG RAM address set   (40us)
;    0    0   1   ------- DD ADDR ---------     DD RAM address set   (40us)
;    1    0   --------- Write data --------     CG/DD RAM data write (40us)
;-------------------------------------------------------------------------------
;    0    1   BF  ----- Address counter ---     Busy flag/Addr cnt read (0)
;    1    1   ---------- Read data --------     CG/DD RAM data read  (40us)
;-------------------------------------------------------------------------------
;
;       I/D=1 inkrementls, I/D=0 dekrementls
;       S=1 display lptets, S=0 display "rgztett"
;       D=1 display on, D=0 display off
;       C=1 kurzor on, C=0 kurzor off
;       B=1 karakter a kurzor helyn villog, B=0 nem villog
;       S/C=1 display lptets, S/C=0 kurzor mozog
;       R/L=1 lptets jobbra, R/L=0 lptets balra
;       DL=1 8 bites, DL=0 4 bites interfsz
;       N=1 kt soros, N=0 egy soros zemmd
;       CG ADDR : karakter genertor RAM cm
;       DD ADDR : display adat RAM cm
;
;-------------------------------------------------------------------------------

		CBLOCK

Timer1
Timer2
Counter
		ENDC
;-------------------------------------------------------------------------------
; PORTE kivezetsek
;
RS              equ     0               		; 0= utasts, 1= adat reg. vlaszts
RdWr            equ     1                       ; R/W=0 LCD rs, R/W=1 LCD memria olvass
E               equ     2               		; 0= LCD tilts, 1= engedlyezs
;-------------------------------------------------------------------------------
;
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
            bra		Main

        ; A magas priorits megszaktsok a 0x208 cmre vannak tirnytva
        org     KezdVect+8                      ; megszakitas vektor (magas priorits)
            retfie


        ; Az alacsony priorits megszaktsok a 0x218 cmre vannak tirnytva
        org     KezdVect+18                     ; megszakitas vektor (alacsony priorits)
            retfie

        ; A felhasznli program folytatsa...

Main:
;===============================================================================
; Port bellts
;
            clrf    PORTD
            clrf    LATD
            clrf    PORTE
            clrf    LATE
Start
            movlw   14
            movwf   ADCON1                      ; RA0 analg bemenet !!!
            setf    TRISA, 0                    ; PORTA bemenet
            clrf    TRISD                       ; PORTD kimenet
            clrf    TRISE                       ; PORTE kimenet
;-------------------------------------------------------------------------------
; LCD kijelz inicializlsa
;
            bcf     LATE,RS                     ; LCD parancs kvetkezik
            movlw   56                          ; 38h, 8 bit interface set
            rcall   Write
            rcall   Kesl                        ; Busy flag olvasst "helyettesti"
            movlw   56
            rcall   Write
            movlw   6                           ; 06h, Entry mode set: increment
            rcall   Write
            movlw   13                          ; 0dh, Display on, cursor/blink off
            rcall   Write
            movlw   16                          ; 10h, Display/cursor shift: cursor
            rcall   Write
            movlw   1                           ; 01h, Display clear
            rcall   Write
            rcall   Kesl2                       ; Busy flag olvasst "helyettesti"

;-------------------------------------------------------------------------------
; Adatklds LCD-re
;
            movlw   128                         ; LCD cm= 0 (+128), els LCD sor
            rcall   Write
            bsf     LATE,RS                     ; LCD adat kvetkezik

            movlw   15                          ; 15 adat kiiratsa
            movwf   Counter
            clrf    TBLPTRU                     ; Tblzat mutat belltsa
            movlw   HIGH LCD_Tabla
            movwf   TBLPTRH
            movlw   LOW LCD_Tabla
            movwf   TBLPTRL
Start1
			tblrd*+                             ; tblzat olvassa mutat lptetssel
            movf    TABLAT, W
            rcall   Write                       ; kirs LCD-re
            decfsz  Counter,F
            bra     Start1
;-------------------------------------------------------------------------------

            bcf     PORTE,RS                    ; LCD parancs
            movlw   192                         ; LCD cm= 40h (+128), msodik sor
            rcall   Write
            bsf     PORTE,RS                    ; LCD adat kvetkezik
            movlw   15                          ; 15 adat kiiratsa
            movwf   Counter
Start2
            tblrd*+                             ; tblzat olvassa
            movf    TABLAT, W
            rcall   Write                       ; kirs LCD-re
            decfsz  Counter,F
            bra     Start2
;-------------------------------------------------------------------------------
            clrf    LATD
Stop
            bra     Stop                        ; resetre vr

;-------------------------------------------------------------------------------
; LCD rs lpsei:
; -----------------
;   1/   RS, R/W belltsa
;   2/   E=1
;   3/   adat kiklds
;   4/   ksleltets (100us)
;   5/   E=0
;
Write
            movwf   LATD
            bsf     LATE, E
            rcall   Kesl100                     ; Busy flag olvasst "helyettesti"
            bcf     LATE,E
            return
;-------------------------------------------------------------------------------
Kesl100
            movlw   165                         ; 100us ksleltets
            movwf   Timer1
Kesl1
            decfsz  Timer1,F
            bra     Kesl1
            return
;-------------------------------------------------------------------------------
Kesl2
            clrf    Timer1                      ; 2ms ksleltets
            movlw   50
            movwf   Timer2
Kesl21
            rcall   Kesl100
            decfsz  Timer2,1
            bra     Kesl21
            return
;-------------------------------------------------------------------------------
Kesl
            rcall   Kesl2
            rcall   Kesl2
            rcall   Kesl2
            rcall   Kesl2
            rcall   Kesl2
            return                              ; 5x2ms ksleltets
;-------------------------------------------------------------------------------

LCD_Tabla
        dt      "FD-2 PROBAPANELINFO@CHIPCAD.HU"
    end
