;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       ORAIC_18.ASM                                      *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    RS5C372A RAMODUL KEZEL PROGRAM                                 *
;    --------------------------------                                 *
;                                                                     *
;    1. Az ramodult az albbiak szerint programozza fel:             *
;       - 32,768 kHz kristly frekvencia kivlaszts (default),       *
;       - rajel megjenenik az INTRB kivezetsen (default),           *
;       - 24 rs zemmd,                                            *
;       - id: 12:00:00,                                              *
;       - dtum: (20)01-02-04.                                        *
;                                                                     *
;    2. Kb. 0,5 msodpercenknt lekrdezi az idt, s az LCD          *
;       modulon kijelzi.                                              *
;                                                                     *
;**********************************************************************
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;
;------------------------------------------------------------------------------
        #define Slave    B'01100100'
;------------------------------------------------------------------------------
        CBLOCK
Timer1                                          ; ksleltets szmll als bjt
Timer2                                          ; ksleltets szmll fels bjt
Sec                                             ; tmeneti regiszterek
Min
Hour
Day_of_week
Day
Month
Year
Timer3
        ENDC

;------------------------------------------------------------------------------
; PORTE kivezetsek
;
        #define RS                   0               ; 0= utasts, 1= adat reg. vlaszts
        #define RdWr                 1               ; R/W=0 LCD rs, R/W=1 LCD memria olvass
        #define E                    2               ; 0= LCD tilts, 1= engedlyezs
;------------------------------------------------------------------------------
;
;
;------------------------------------------------------------------------------
;********************************* FPROGRAM **********************************
;------------------------------------------------------------------------------
;
        org     KezdVect                ; reset vektor
        #ifdef ICD
                nop                     ; MPLAB-ICD miatt
        #endif            
;==============================================================================
; Port bellts
;
Start
                clrf    LATD
                clrf    LATE
                movlw   14
                movwf   ADCON1          ; RA0 analg bemenet !!!
                setf    TRISA           ; PORTA bemenet
                setf    TRISC           ; PORTC bemenet
                clrf    TRISD           ; PORTD kimenet
                clrf    TRISE           ; PORTE kimenet
;------------------------------------------------------------------------------
; Az I2C port konfigurlsa
;
                clrf    PIE1            ; a perifria megszaktsok tiltsa
                clrf    INTCON          ;
                movlw   0x80
                movwf   SSPSTAT         ; slew rate vezrls tiltva
                movlw   0x31            ; SSPADD=49
                movwf   SSPADD
                clrf    LATD
                movlw   B'00101000'     ; SSPEN=1, soros port engedlyezs
                movwf   SSPCON1         ; I2C master, Fosc/(4*(SSPADD+1))
                clrf    PIR1
;------------------------------------------------------------------------------
; LCD kijelz inicializlsa
;
                rcall   Delay
                bcf     LATE,RS         ; LCD parancs kvetkezik
                movlw   H'38'           ; 8 bites interfsz, 2 sor
                rcall   Write
                rcall   Delay2          ; Busy flag olvasst "helyettesti"
                movlw   H'38'
                rcall   Write
                movlw   6               ; 06h, Entry mode set: increment
                rcall   Write
                movlw   12              ; 0ch, Display on, blink off
                rcall   Write
                movlw   16              ; 10h, Display/cursor shift: cursor
                rcall   Write
                movlw   1               ; 01h, Display clear
                rcall   Write
                rcall   Delay2          ; Busy flag olvasst "helyettesti"
;------------------------------------------------------------------------------
; RA MODUL rs
;
Clock_Write
                bsf     SSPCON2,SEN     ; start bit
                rcall   Wait
                movlw   Slave           ; W= slave + R/W (=0)
                movwf   SSPBUF
                rcall   Wait
                movlw   0xF0            ; kezdcm= 0Fh, tv. formtum reg.= 0
                movwf   SSPBUF
                rcall   Wait
                movlw   0x20            ; CONTROL2 regiszter rs, 24 rs zemmd
                movwf   SSPBUF
                rcall   Wait
                movlw   0x00            ; SEC regiszter rs
                movwf   SSPBUF
                rcall   Wait
                movlw   0x00            ; MIN regiszter rs
                movwf   SSPBUF
                rcall   Wait
                movlw   0x12            ; HOUR regiszter rs
                movwf   SSPBUF
                rcall   Wait
                movlw   0x00            ; DAY OF WEEK regiszter rs (=vasrnap !)
                movwf   SSPBUF
                rcall   Wait
                movlw   0x04            ; DAY regiszter rs
                movwf   SSPBUF
                rcall   Wait
                movlw   0x02            ; MONTH regiszter rs
                movwf   SSPBUF
                rcall   Wait
                movlw   0x01            ; YEAR regiszter rs (2001)
                movwf   SSPBUF
                rcall   Wait
                bsf     SSPCON2,PEN     ; stop bit
                rcall   Wait
                rcall   Delay           ; vrakozs az rs vgre (kb. 10ms)
;------------------------------------------------------------------------------
; RA MODUL olvass
;
Clock_Read
                bsf     SSPCON2,SEN     ; start bit
                rcall   Wait
                movlw   Slave           ; W= slave + R/W (=0)
                movwf   SSPBUF
                rcall   Wait
                movlw   0x00            ; SEC regiszter cme
                movwf   SSPBUF
                rcall   Wait
;------------------------------------------------------------------------------
                bsf     SSPCON2,RSEN    ; ismtelt start bit !!!
                rcall   Wait
                movlw   Slave
                addlw   1               ; W= slave + R/W (=1), olvass !
                movwf   SSPBUF
                rcall   Wait
;------------------------------------------------------------------------------
                bsf     SSPCON2,RCEN    ; vtel engedlyezs
                rcall   Wait
                movf    SSPBUF,0
                movwf   Sec             ; vett adat msolsa SEC regiszterbe
                bsf     SSPCON2,ACKEN   ; acknowledge bit generls
                rcall   Wait
                bsf     SSPCON2,RCEN    ; vtel ismtelt engedlyezse
                rcall   Wait
                movf    SSPBUF,0
                movwf   Min             ; vett adat msolsa MIN regiszterbe
                bsf     SSPCON2,ACKEN   ; acknowledge bit generls
                rcall   Wait
                bsf     SSPCON2,RCEN    ; vtel ismtelt engedlyezse
                rcall   Wait
                movf    SSPBUF,0
                movwf   Hour            ; vett adat msolsa HOUR regiszterbe
                bsf     SSPCON2,ACKEN   ; acknowledge bit generls
                rcall   Wait
                bsf     SSPCON2,RCEN    ; vtel ismtelt engedlyezse
                rcall   Wait
                movf    SSPBUF,0
                movwf   Day_of_week     ; vett adat msolsa DAY OF WEEK regiszterbe
                bsf     SSPCON2,ACKEN   ; acknowledge bit generls
                rcall   Wait
                bsf     SSPCON2,RCEN    ; vtel ismtelt engedlyezse
                rcall   Wait
                movf    SSPBUF,0
                movwf   Day             ; vett adat msolsa DAY regiszterbe
                bsf     SSPCON2,ACKEN   ; acknowledge bit generls
                rcall   Wait
                bsf     SSPCON2,RCEN    ; vtel ismtelt engedlyezse
                rcall   Wait
                movf    SSPBUF,0
                movwf   Month           ; vett adat msolsa MONTH regiszterbe
                bsf     SSPCON2,ACKEN   ; acknowledge bit generls
                rcall   Wait
                bsf     SSPCON2,RCEN    ; vtel ismtelt engedlyezse
                rcall   Wait
                movf    SSPBUF,0
                movwf   Year            ; vett adat msolsa YEAR regiszterbe
                bsf     SSPCON2,PEN     ; stop bit
                rcall   Wait
;------------------------------------------------------------------------------
; Dtum s id kiirats az LCD kijelzn
;
LCD_Write
                bcf     LATE,RS ; cm
                movlw   129             ; LCD cm= 1 (+128, els sor)
                rcall   Write
                bsf     LATE,RS         ; adat
                movlw   '2'
                rcall   Write
                movlw   '0'
                rcall   Write
                swapf   Year,0
                andlw   15
                addlw   48
                rcall   Write           ; v tizesek kiiratsa
                movf    Year,0
                andlw   15
                addlw   48
                rcall   Write           ; v egyesek kiiratsa
                movlw   '-'
                rcall   Write
                swapf   Month,0
                andlw   15
                addlw   48
                rcall   Write           ; hnap tizesek kiiratsa
                movf    Month,0
                andlw   15
                addlw   48
                rcall   Write           ; hnap egyesek kiiratsa
                movlw   '-'
                rcall   Write
                swapf   Day,0
                andlw   15
                addlw   48
                rcall   Write           ; nap tizesek kiiratsa
                movf    Day,0
                andlw   15
                addlw   48
                rcall   Write           ; nap egyesek kiiratsa
                bcf     LATE,RS         ; cm
                movlw   193             ; LCD cm= 1 (+192, msodik sor)
                rcall   Write
                bsf     LATE,RS         ; adat
                swapf   Hour,0
                andlw   15
                addlw   48
                rcall   Write           ; ra tizesek kiiratsa
                movf    Hour,0
                andlw   15
                addlw   48
                rcall   Write           ; ra egyesek kiiratsa
                movlw   ':'
                rcall   Write
                swapf   Min,0
                andlw   15
                addlw   48
                rcall   Write           ; perc tizesek kiiratsa
                movf    Min,0
                andlw   15
                addlw   48
                rcall   Write           ; perc egyesek kiiratsa
                movlw   ':'
                rcall   Write
                swapf   Sec,0
                andlw   15
                addlw   48
                rcall   Write           ; msodperc tizesek kiiratsa
                movf    Sec,0
                andlw   15
                addlw   48
                rcall   Write           ; msodperc egyesek kiiratsa
                rcall   Delay05

                bra     Clock_Read      ; kb. 0,5 mp mlva jabb olvass
;==============================================================================
;
;
;
;------------------------------------------------------------------------------
;******************************* SZUBRUTINOK **********************************
;------------------------------------------------------------------------------
;
;------------------------------------------------------------------------------
Wait            btfss   PIR1,SSPIF      ; SSPIF megszakts flagre vr
                bra     Wait
;------------------------------------------------------------------------------
                bcf     PIR1,SSPIF      ; SSPIF flag trlse
                return
;------------------------------------------------------------------------------
Delay           movlw   70              ; kb. 10ms ksleltets
                movwf   Timer2
Delay1          decfsz  Timer1,1
                bra    Delay1
                decfsz  Timer2,1
                bra    Delay1
                return
;------------------------------------------------------------------------------
; LCD rs lpsei:
; -----------------
;   1/   RS, R/W belltsa
;   2/   E=1
;   3/   adat kiklds
;   4/   ksleltets (100us)
;   5/   E=0
;
Write           movwf   LATD
                bsf     LATE,E
                rcall   Delay100        ; Busy flag olvasst "helyettesti"
                bcf     LATE,E
                return
;-------------------------------------------------------------------------------
Delay100        movlw   165             ; 100us ksleltets
                movwf   Timer1
Del11           decfsz  Timer1,1
                goto    Del11
                return
;-------------------------------------------------------------------------------
Delay2          clrf    Timer1          ; 2ms ksleltets
                movlw   20
                movwf   Timer2
Del21           rcall   Delay100
                decfsz  Timer2,1
                bra    Del21
                return
;-------------------------------------------------------------------------------
Delay05         movlw   50              ; kb. 0,5 mp ksleltets
                movwf   Timer3
Del31           rcall   Delay
                decfsz  Timer3,1
                bra    Del31
                return
;-------------------------------------------------------------------------------
        end
