;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       POTM18.ASM                                        *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    LED SOR KEZEL PROGRAM                                           *
;    ----------------------                                           *
;    Az A/D konverzi eredmnyt a LED soron jelenti meg.            *
;    A mintavtel gyakorisgt a TMR0 tlcsordulsa hatrozza meg.    *
;                                                                     *
;**********************************************************************
;
;
;

        #include BEALLIT.INC                                    ; ltalnos belltsok (proc, fejleszt, stb.)

        CBLOCK
DlyCntr
OvfCntr
Mutato
        ENDC
;
;
;
;------------------------------------------------------------------------------
;------------------------------------- FPROGRAM ------------------------------
;------------------------------------------------------------------------------
;
        org     KezdVect                                        ; reset vektor
        #ifdef ICD
                nop                                             ; MPLAB-ICD miatt
        #endif            
                movlw   B'11000001'                             ; RC oszcilltor, A/D engedlyezs
                movwf   ADCON0                                  ; 0. csatorna (RA0) kivlaszts
                movlw   B'11000111'                             ; TMR0 eloszt= 1:256
                movwf   T0CON
                movlw   14
                movwf   ADCON1                                  ; RA0 analg bemenet !!!
                setf    TRISA                                   ; PORTA bemenet
                clrf    TRISD                                   ; PORTD kimenet
                clrf    LATD
                movlw   10                                      ; TMR0 tlcsorduls szmll kezdeti
                movwf   OvfCntr                                 ; rtke 10
;------------------------------------------------------------------------------
; A TMR0 tlcsorduls nem okoz megszaktst, (hiszen azt nem is engedlyeztk)
; de bekvetkeztt a T0IF flag vizsglatval figyeljk.
; A/D konverzit minden 10. TMR0 tlcsordulsra vgznk.
;

Start
                btfss   INTCON,T0IF                             ; TMR0 tlcsorduls volt?
                bra     Start                                   ; mg nem
;------------------------------------------------------------------------------
                bcf     INTCON,T0IF                             ; igen, flag trls
                decfsz  OvfCntr,1                               ; tlcsorduls szmll dekrementlsa
                bra     Start                                   ; mg nem 0
;------------------------------------------------------------------------------
                movlw   10                                              ; mintavtel 10 tlcsordulsonknt
                movwf   OvfCntr                                 ; szmll visszallts
                bcf     INTCON,T0IF                             ; igen, flag trls
                bsf     ADCON0,GO                               ; A/D konverzi start
Wait
                btfss   PIR1,ADIF                               ; vrakozs a teljes konverzira
                bra     Wait
;------------------------------------------------------------------------------
                movff   ADRESH, LATD                            ; ADRESH tartalmnak kijelzse a LED soron
                bra     Start
;------------------------------------------------------------------------------
        end

