;**********************************************************************
;                                                                     *
;    FD-2 FLASH DEMO PRBAPANEL PROJEKT                               *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fjlnv:       SPI_18.ASM                                        *
;    Dtum:         2002.09.23.                                       *
;    Verziszm:    V1.0                                              *
;    #2                                                               *
;                                                                     *
;    Szerz:        Kolinger Attila                                   *
;    Cg neve:      ChipCAD kft.                                      *
;    E-mail:        info@chipcad.hu                                   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    93LC56 MICROWIRE SOROS EEPROM KEZEL PROGRAM                     *
;    --------------------------------------------                     *
;    Az EEPROM CLK, DI, DO vonalait az SPI port kezeli.               *
;    Az EEPROM kivlasztst - a CS jellel - az RA2 vonal vgzi.      *
;                                                                     *
;**********************************************************************
;

        #include BEALLIT.INC                    ; ltalnos belltsok (proc, fejleszt, stb.)

;
;----------------------------------------------------------------------
        CBLOCK
Rxdata          ; SPI kimeneti adat
Txdata          ; SPI bemeneti adat
EE_Addr         ; EEPROM cm tmeneti trol
EE_Data         ; EEPROM adat tmeneti trol
Opcode          ; utastskd tmeneti trol
        ENDC
;----------------------------------------------------------------------
; PORTA kivezetsek
;
CS              equ     2               ; RA2, EEPROM Chip select, aktv H
;
;
;----------------------------------------------------------------------
;----------------------------- FPROGRAMOK ----------------------------
;----------------------------------------------------------------------
        org     KezdVect                        ; reset vektor
        #ifdef ICD
            nop                                 ; MPLAB-ICD miatt
        #endif            
;----------------------------------------------------------------------
; Port konfigurls
;
Start
                clrf    LATA            ; EEPROM nincs kivlasztva
                clrf    LATC            ; EEPROM vonalak inaktvak
                movlw   14
                movwf   ADCON1          ; RA0 analg bemenet !!!
                movlw   B'11111011'     ; RA2 kimenet
                movwf   TRISA
                movlw   B'11010111'     ; RC3, RC5 kimenet
                movwf   TRISC
                clrf    TRISD
;----------------------------------------------------------------------
; SPI inicializls
;
                clrf    PIE1            ; a perifria megszaktsok tiltsa
                clrf    INTCON          ;
                clrf    SSPSTAT         ; SMP=CKE=0
                movlw   0x32            ; SPI master, Fosc/64, CKP=1
                movwf   SSPCON1         ; SSPEN=1, soros port engedlyezs
;----------------------------------------------------------------------
; Egy bjt rsa az EEPROM-ba
;
                rcall   Ewen            ; EEPROM trls/rs engedlyezse
                movlw   B'00001010'     ; Start bit, utastskd s A8 betlts
                movwf   Opcode          ; az Opcode regiszterbe
                movlw   0x24            ; EEPROM cm betltse az EE_Addr
                movwf   EE_Addr         ; regiszterbe
                movlw   0x51            ; adat az EEPROM szmra
                movwf   EE_Data
                rcall   Write           ; EEPROM rs
                nop                     ; CS alacsony, majd ismt magas
                bsf             LATA,CS ;   -> EEPROM nidzts indul
Rdbusy
                btfss   PORTC,SDI       ; EEPROM ready jel vizsglata
                bra             Rdbusy          ; ha SDI=0, mg nem ksz
;----------------------------------------------------------------------
; Egy bjt olvass az EEPROM-bl
; Az olvassnl az rjel polaritst (inaktv szintjt) meg kell fordtani:
; az EEPROM az adatot az rajel felfut lnl teszi a DO kimenetre (SDI vonal),
; a mikrovezrl pedig a lefut lnl olvassa be azt.
;
                bcf             LATA, CS        ;
                movlw   B'00001100'     ; Start bit, utastskd s A8 betlts
                movwf   Opcode          ; az Opcode regiszterbe
                movlw   0x24            ; EEPROM cm betltse az EE_Addr
                movwf   EE_Addr         ; regiszterbe
                rcall   Read            ; EEPROM olvass
                nop                     ; beolvasott adat -> EE_Data
                nop
                movwf   LATD
Stop            bra     Stop            ; vrakozs resetre
;----------------------------------------------------------------------
;
;
;----------------------------------------------------------------------
;----------------------------- SZUBRUTINOK ----------------------------
;----------------------------------------------------------------------
;
Ewen
                bsf             LATA,CS ; CS=1, EEPROM kivlaszts
                movlw   B'00001001'     ; Start bit, utastskd, A8 kiklds
                rcall   Output          ; kiklds az SPI porton
                movlw   B'10000000'     ; tovbbi 1 bit az EWEN kdjhoz
                rcall   Output          ; kiklds az SPI porton
                bcf             LATA,CS ; EEPROM inaktv
                return
;----------------------------------------------------------------------
Ewds
                bsf             LATA,CS ; CS=1, EEPROM kivlaszts
                movlw   B'00001000'     ; Start bit, utastskd, A8 kiklds
                rcall   Output          ;
                movlw   B'00000000'     ; tovbbi 1 bit az EWDS kdjhoz
                rcall   Output          ; kiklds az SPI porton
                bcf             LATA,CS ; EEPROM inaktv
                return
;----------------------------------------------------------------------
Output
                movwf   SSPBUF          ; betlts az SPI shift regiszterbe
Loop
                btfss   SSPSTAT,BF      ; ads/vtel ksz?
                bra             Loop            ; mg nem
;----------------------------------------------------------------------
                movf    SSPBUF,0        ;
                movwf   Rxdata          ; a vett adat az Rxdata regiszterbe
                return                  ; kerl
;----------------------------------------------------------------------
Write
                bsf             LATA,CS ; CS=1, EEPROM kivlaszts
                movf    Opcode,0        ; rs kd kiklds
                rcall   Output          ;
                movf    EE_Addr,0       ; EEPROM cm kiklds
                rcall   Output          ;
                movf    EE_Data,0       ; programozand adat
                rcall   Output          ;
                bcf             LATA,CS
                return
;----------------------------------------------------------------------
Read
                bsf             LATA,CS ; CS=1, EEPROM kivlaszts
                movf    Opcode,0        ; olvass kd kiklds
                rcall   Output          ;
                movf    EE_Addr, 0      ; EEPROM cm kiklds
                rcall   Output          ;
                bcf             SSPCON1, CKP    ; rajel polarits vlts, CKP=0
                movlw   0x00            ; "dummy" adat kiklds
                rcall   Output          ;
                movf    Rxdata,0
                movwf   EE_Data         ; beolvasott adat -> EE_Data
                bcf             LATA,CS ; olvass lezrs, CS=0
                bsf             SSPCON1, CKP    ; CKP=1, rajel polarts vlts
                return
;----------------------------------------------------------------------
          end
