#include <stdio.h>
#include <conio.h>

/* I2C-porttimääritykset */
#define del        32000 	/* Length of delay */
#define LPT1    0x378 		/* Address of LPT1 */

/* I2C CLK high SELECT_LN# = 0 -> SCL = 1 */
void SCL(void) {outp(LPT1+2,0x08);}

/* I2C CLK low  SELECT_LN# = 1 -> SCL = 0*/
void _SCL(void) {outp(LPT1+2,0x00);}

/* I2C DATA high DA7 = 0 -> SDA = 1 */
void SDA(void) {outp(LPT1,0x00);}

/* I2C DATA low DA7 = 1 -> SDA = 0 */
void _SDA(void) {outp(LPT1,0x80);}

/* Delay function */
void delay(int time)
{
int j;
for(j = 0;j < time; j++);
}

/* Write of one byte */
void wr_i2c(unsigned char data)
{
	int i=0;
	delay(del);
	_SCL();
	delay(del);
	for (i=0;i<8;i++)
	{
	if ((data & 0x80) == 0x80)
		{
		SDA();
		printf("1");
	}
		else
		{
			_SDA();
			printf("0");
		}
		data = data << 1;  
		delay(del);
		SCL();
		delay(del);
		_SCL();
		delay(del);
	}
	printf("\n");
	_SDA();
	delay(del);
	SCL();
	delay(del);
	_SCL();
	delay(del);
}

/* I2C STOP function */
void stop_i2c(void)
{
	 delay(del);
	 _SDA();	/* data low */
	 delay(del);
	 SCL();		/* clk high */
	 delay(del);
	 SDA();		/* data high */
	 delay(del);
}

/* I2C START function*/
void start_i2c(void)
{
	 delay(del);
	 SDA();             /* data high */
	 delay(del);
	 SCL();             /* clk high */
	 delay(del);
	 _SDA();    	    /* data low */
	 delay(del);
	 _SCL();            /* clk low */
	 delay(del);
}

/* Controlling of Philips LCD-controller PCF8576 */
void LCD_PCF8576(void)
{
start_i2c();

/* commands */
wr_i2c(0x70);		/* PCF8576 address */
wr_i2c(0xE0);		/* Device select   */
wr_i2c(0xCD);		/* Mode set (Static) */
wr_i2c(0xFB);		/* Bank select 2 */
wr_i2c(0xF0);		/* Blink select (0xF0= off/0xF2= on) */
wr_i2c(0x00);		/* Switch to data and reset pointer */

/* Data begins here */
wr_i2c(220);		/* H */
wr_i2c(62);		/* E */
wr_i2c(20);		/* L */
wr_i2c(20);		/* L */
wr_i2c(120);		/* o */
stop_i2c();
}

void main()
{
LCD_PCF8576(); /* Chip initialization and writing to LCD */
}
