#include <avr/io.h>
#include <avr/iom8.h>
#include <avr/interrupt.h>
#include <compat/deprecated.h>	// sbi

//#include "t6963c.h"
//#include "graphic.h"

#define  OSCB  500;              // Oszcillator bazis frekvencia

unsigned cnt0=0;                 // Idozito szamlalok
unsigned cnt1=0;
unsigned cnt2=0;
unsigned cnt3=0;
unsigned cnt4=0;
unsigned cnt5=0;
unsigned cnto=OSCB;
unsigned char osc=0;             // Oszcillator bit

void  timinit(void);             // Timer inicializalo rutin

void  timinit(void)              // Timer inicializalasa
  {
  sbi(TCCR1B,WGM12);              //Timer/Counter1 Control Register A: CTC mode  (135.o)
  cbi(TCCR1B,CS12);               //Timer/Counter1 Control Register B: clk/1 (139.o)
  cbi(TCCR1B,CS11);
  sbi(TCCR1B,CS10);
  OCR1A=10000;                    // 10MHz 10000 1ms
  sbi(TIMSK,OCIE1A);             //Interrupt mask register:Output Compare A Match Interrupt Enable(142.o)
  cnto=2;
  }
 
ISR (TIMER1_COMPA_vect)          //Timer1 Compare Match A Interrupt Vector
{
 
  if(cnt0)  cnt0--;              // Ha a szamlalo erteke nem null, akkor 
  if(cnt1)  cnt1--;              // csokkentjuk. 
  if(cnt2)  cnt2--;              // Ha nulla, akkor lejart az ido
  if(cnt3)  cnt3--;
  if(cnt4)  cnt4--;
  if(cnt5)  cnt5--;
 
  cnto--;                        // Oszcillator szekcio
  if(cnto==0)                    // Lejart-e az ido?   
    {
    osc^=1;                      // Az oszcillator bitet invertalja
    cnto=OSCB;                   // Ujra toltjuk az oszcillator szamlalojat
		if(osc) sbi(PORTC,1);             // Ha a osc igaz, bekapcsolja a LCD_M-et 
    else    cbi(PORTC,1);             // Ha nem kikapcsolja
    }
}    
 

int main(void)
{
/* INITIALIZE */
GLCD_Initalize(); // Initalize LCD
GLCD_ClearText(); // Clear text area
GLCD_ClearCG(); // Clear character generator area
GLCD_ClearGraphic(); // Clear graphic area

timinit ();

	DDRC = 0B11111111;	// PortD minden bitje kimenet
	sei();
	
	
GLCD_TextGoTo(1,1);
GLCD_WriteString("Szeva !!!           "); // write text
GLCD_Circle(32,32,20); // draw circle
GLCD_Circle(208,32,20); // draw circle

GLCD_Rectangle(8,8,224, 48); // draw rectangle
while (1);
	
return 0;
}
