#include <avr/io.h>
#include <stdio.h>
#include <avr/iom8.h>
#include <avr/interrupt.h>
#include <compat/deprecated.h>	// sbi

#include "t6963c.h"
#include "graphic.h"

#define OSCB	10

unsigned cnt0=0;                 // Idozito szamlalok
unsigned cnt1=0;
unsigned cnt2=0;
unsigned cnt3=0;
unsigned cnt4=0;
unsigned cnt5=0;
unsigned cnto=OSCB;
unsigned char osc=0;             // Oszcillator bit

void  timinit(void);             // Timer inicializalo rutin

void  timinit(void)              // Timer inicializalasa
  {
  sbi(TCCR1B,WGM12);              //Timer/Counter1 Control Register A: CTC mode  (135.o)
  cbi(TCCR1B,CS12);               //Timer/Counter1 Control Register B: clk/1 (139.o)
  cbi(TCCR1B,CS11);
  sbi(TCCR1B,CS10);
  OCR1A=1000;                    // 10MHz 10000 1ms
  sbi(TIMSK,OCIE1A);             //Interrupt mask register:Output Compare A Match Interrupt Enable(142.o)
  cnto=2;
	  
  }
 
ISR (TIMER1_COMPA_vect)          //Timer1 Compare Match A Interrupt Vector
{
	cli(); 
  if(cnt0)  cnt0--;              // Ha a szamlalo erteke nem null, akkor 
  if(cnt1)  cnt1--;              // csokkentjuk. 
  if(cnt2)  cnt2--;              // Ha nulla, akkor lejart az ido
  if(cnt3)  cnt3--;
  if(cnt4)  cnt4--;
  if(cnt5)  cnt5--;
 
  cnto--;                        // Oszcillator szekcio
  if(cnto==0)                    // Lejart-e az ido?   
    {
    osc^=1;                      // Az oszcillator bitet invertalja
    cnto=OSCB;                   // Ujra toltjuk az oszcillator szamlalojat
		if(osc) sbi(PORTC,1);             // Ha a osc igaz, bekapcsolja a LCD_M-et 
    else    cbi(PORTC,1);             // Ha nem kikapcsolja
    }
	sei();
}    
 

void nyil_fel(int ax, int ay)
{
	GLCD_Line(ax+5,ay,ax,ay+10,1);
	GLCD_Line(ax+5,ay,ax+10,ay+10,1);
	GLCD_Line(ax,ay+10,ax+10,ay+10,1);
}	

void nyil_le(int ax, int ay)
{
	GLCD_Line(ax,ay,ax+5,ay+10,1);
	GLCD_Line(ax,ay,ax+10,ay,1);
	GLCD_Line(ax+5,ay+10,ax+10,ay,1);
}

void Box(int ax, int ay, int alen, int acolor)
{
	int i;
			GLCD_HLine(ax+2,ay,alen-4,acolor);
			GLCD_HLine(ax+1,ay+1,alen-2,acolor);
	for (i=2; i<8; i++)
		GLCD_HLine(ax,ay+i,alen,acolor);
			GLCD_HLine(ax-1,ay+8,alen+2,acolor);

}

void kijeloles_ures(int ax, int ay, int alen, int acolor)
{
		GLCD_Rectangle(ax,ay,alen,8,acolor);
}

//#define TELEFONSZAMOK	7
#define TELEFONSZAMOK	12
#define MENUK_SZAMA	3
#define MENUK_HOSSZA	4
#define AKTIV_ELEM	3

int main(void)
{
	int i;
	char MyStr[20];
	char Telefonkonyv[TELEFONSZAMOK][20] = {
		"Anyu",			"Apu",				"Bako Robert",
		"Bognar Jozsi",	"Don Puli",			"Dorka", 
		"EuroSys",		"Fordan",			"Gody Papa",
		"Gong Radio",	"Gyarmati Jozsef",	"Gyarmati Szilvi"};
	char TelefonMenu[3][6] = {
		"Menu", "Hivas", "SMS "};
		
	
timinit ();

	DDRC = 0B11111111;	// PortD minden bitje kimenet
	sei();

GLCD_Initalize(); // Initalize LCD
GLCD_ClearText(); // Clear text area
GLCD_ClearCG(); // Clear character generator area
GLCD_ClearGraphic(); // Clear graphic area

	
	for (i=0;i<TELEFONSZAMOK;i++)
	{
		sprintf(MyStr, "%2.d:%s",i+1,Telefonkonyv[i]);
		GLCD_TextGoto(2,i+2);
		GLCD_WriteString(MyStr);
	}

		GLCD_TextGoto(2,0);

		GLCD_WriteString("Menu  Hivas  SMS  Naplo");
		GLCD_TextGoto(0,15);
		GLCD_WriteString("|SMS 0|Bejovo hivas|Kihang.BE|");
	
	nyil_fel(0,16);
	nyil_le(0,46);
	GLCD_VLine(14,11,105,1);
	GLCD_VLine(15,10,106,1);

	GLCD_HLine(16,9,224,1);
	GLCD_HLine(16,10,224,1);
	GLCD_HLine(16,115,224,1);
	GLCD_SetPixel(16,11,1);

//	Box(8*8,0*8,7*8,1);	// Menupont inverz
	Box(60,	0,	52,	1);	// Menupont inverz

//	GLCD_WriteCommand(T6963_DISPLAY_MODE  | T6963_GRAPHIC_DISPLAY_ON   | T6963_TEXT_DISPLAY_ON /*| T6963_CURSOR_DISPLAY_ON*/);
//	GLCD_WriteCommand(T6963_DISPLAY_MODE  | T6963_TEXT_DISPLAY_ON /*| T6963_CURSOR_DISPLAY_ON*/);
//	GLCD_WriteCommand(T6963_MODE_SET | T6963_EXOR_MODE);

	while (1)
	{
		for (i=1;i<TELEFONSZAMOK+1;i++)
		{
			if (i==1)
				GLCD_Rectangle(2*8,(TELEFONSZAMOK+1)*8-1,160,8,0);
			else
				GLCD_Rectangle(2*8,i*8-1,160,8,0);
			GLCD_Rectangle(2*8,(i+1)*8-1,160,8,1);
			
		}
		

	}
return 0;
}
