// Systick teszt

#include <stdio.h>
#include <string.h>
#include "diag/Trace.h"
#include "stm32f10x_conf.h"
#include "sysTick.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#pragma GCC diagnostic ignored "-Wreturn-type"

volatile uint32_t sec10 = 0;
volatile uint32_t mainuptimer = 0;
volatile uint32_t maindowntimer1 = 0;
volatile uint32_t maindowntimer2 = 0;

extern "C" void sectimer10(void)
{
  sec10++;
}

void setup(void)
{
  systick_init();
  trace_printf("\ndelay start");
  systick_delay(4000);
  trace_printf("\ndelay stop");
}

void loop(void)
{
  if(!maindowntimer1)
  {
    maindowntimer1 = 1001;
    trace_printf("\nuptimer = %d, downtimer1 = %d", mainuptimer, maindowntimer1);
  }

  if(!maindowntimer2)
  {
    maindowntimer2 = 1202;
    trace_printf("\nuptimer = %d, downtimer2 = %d", mainuptimer, maindowntimer2);
  }

  static uint32_t oldsec10 = 0;
  if(sec10 != oldsec10)
  {
    oldsec10 = sec10;
    trace_printf("\nuptimer = %d, sec10 = %d", mainuptimer, sec10);
  }
}

int main(int argc, char* argv[])
{
  setup();
  while(1)
  {
    loop();
  }
}

#pragma GCC diagnostic pop

// ----------------------------------------------------------------------------
