#include <stdio.h>
#include "stm32f10x_conf.h"
#include "systick.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#pragma GCC diagnostic ignored "-Wreturn-type"

#define CALLBACKPROC_(a, b)    a
#define CALLBACKMS_(a, b)      b
#define CALLBACKPROC(x)        CALLBACKPROC_(x)
#define CALLBACKMS(x)          CALLBACKMS_(x)

#ifdef SYSTICKCALLBACK01
void CALLBACKPROC(SYSTICKCALLBACK01);
#endif

#ifdef SYSTICKCALLBACK02
void CALLBACKPROC(SYSTICKCALLBACK02);
#endif

#ifdef SYSTICKCALLBACK03
void CALLBACKPROC(SYSTICKCALLBACK03);
#endif

#ifdef SYSTICKCALLBACK04
void CALLBACKPROC(SYSTICKCALLBACK04);
#endif

#ifdef SYSTICKCALLBACK05
void CALLBACKPROC(SYSTICKCALLBACK05);
#endif

#ifdef SYSTICKCALLBACK06
void CALLBACKPROC(SYSTICKCALLBACK06);
#endif

#ifdef SYSTICKUPTIMER01
extern uint32_t SYSTICKUPTIMER01;
#endif

#ifdef SYSTICKUPTIMER02
extern uint32_t SYSTICKUPTIMER02;
#endif

#ifdef SYSTICKUPTIMER03
extern uint32_t SYSTICKUPTIMER03;
#endif

#ifdef SYSTICKUPTIMER04
extern uint32_t SYSTICKUPTIMER04;
#endif

#ifdef SYSTICKUPTIMER05
extern uint32_t SYSTICKUPTIMER05;
#endif

#ifdef SYSTICKUPTIMER06
extern uint32_t SYSTICKUPTIMER06;
#endif

#ifdef SYSTICKDOWNTIMER01
extern uint32_t SYSTICKDOWNTIMER01;
#endif

#ifdef SYSTICKDOWNTIMER02
extern uint32_t SYSTICKDOWNTIMER02;
#endif

#ifdef SYSTICKDOWNTIMER03
extern uint32_t SYSTICKDOWNTIMER03;
#endif

#ifdef SYSTICKDOWNTIMER04
extern uint32_t SYSTICKDOWNTIMER04;
#endif

#ifdef SYSTICKDOWNTIMER05
extern uint32_t SYSTICKDOWNTIMER05;
#endif

#ifdef SYSTICKDOWNTIMER06
extern uint32_t SYSTICKDOWNTIMER06;
#endif

static volatile uint32_t sysTickCount = 0;
void delay(uint32_t nTime)
{
  sysTickCount = nTime;
  while(sysTickCount != 0);
}

void systick_init(void)
{
  SysTick_Config(SystemCoreClock / 1000u);
}

void systick_delay(uint32_t nTime)
{
  sysTickCount = nTime;
  while(sysTickCount != 0);
}


void SysTick_Handler(void)
{
  if (sysTickCount != 0)
  {
    sysTickCount--;
  }

  #ifdef SYSTICKCALLBACK01
  static uint32_t countcallback01 = CALLBACKMS(SYSTICKCALLBACK01) - 1;
  if(countcallback01)
    countcallback01--;
  else
  {
    CALLBACKPROC(SYSTICKCALLBACK01);
    countcallback01 = CALLBACKMS(SYSTICKCALLBACK01) - 1;
  }
  #endif

  #ifdef SYSTICKCALLBACK02
  static uint32_t countcallback02 = CALLBACKMS(SYSTICKCALLBACK02) - 1;
  if(countcallback02)
    countcallback02--;
  else
  {
    CALLBACKPROC(SYSTICKCALLBACK02);
    countcallback02 = CALLBACKMS(SYSTICKCALLBACK02) - 1;
  }
  #endif

  #ifdef SYSTICKCALLBACK03
  static uint32_t countcallback03 = CALLBACKMS(SYSTICKCALLBACK03) - 1;
  if(countcallback03)
    countcallback03--;
  else
  {
    CALLBACKPROC(SYSTICKCALLBACK03);
    countcallback03 = CALLBACKMS(SYSTICKCALLBACK03) - 1;
  }
  #endif

  #ifdef SYSTICKCALLBACK04
  static uint32_t countcallback04 = CALLBACKMS(SYSTICKCALLBACK04) - 1;
  if(countcallback04)
    countcallback04--;
  else
  {
    CALLBACKPROC(SYSTICKCALLBACK04);
    countcallback04 = CALLBACKMS(SYSTICKCALLBACK04) - 1;
  }
  #endif

  #ifdef SYSTICKCALLBACK05
  static uint32_t countcallback05 = CALLBACKMS(SYSTICKCALLBACK05) - 1;
  if(countcallback05)
    countcallback05--;
  else
  {
    CALLBACKPROC(SYSTICKCALLBACK05);
    countcallback05 = CALLBACKMS(SYSTICKCALLBACK05) - 1;
  }
  #endif

  #ifdef SYSTICKCALLBACK06
  static uint32_t countcallback06 = CALLBACKMS(SYSTICKCALLBACK06) - 1;
  if(countcallback06)
    countcallback06--;
  else
  {
    CALLBACKPROC(SYSTICKCALLBACK06);
    countcallback06 = CALLBACKMS(SYSTICKCALLBACK06) - 1;
  }
  #endif

  #ifdef SYSTICKUPTIMER01
  SYSTICKUPTIMER01++;
  #endif

  #ifdef SYSTICKUPTIMER02
  SYSTICKUPTIMER02++;
  #endif

  #ifdef SYSTICKUPTIMER03
  SYSTICKUPTIMER03++;
  #endif

  #ifdef SYSTICKUPTIMER04
  SYSTICKUPTIMER04++;
  #endif

  #ifdef SYSTICKUPTIMER05
  SYSTICKUPTIMER05++;
  #endif

  #ifdef SYSTICKUPTIMER06
  SYSTICKUPTIMER06++;
  #endif

  #ifdef SYSTICKDOWNTIMER01
  if (SYSTICKDOWNTIMER01 != 0)
  {
    SYSTICKDOWNTIMER01--;
  }
  #endif

  #ifdef SYSTICKDOWNTIMER02
  if (SYSTICKDOWNTIMER02 != 0)
  {
    SYSTICKDOWNTIMER02--;
  }
  #endif

  #ifdef SYSTICKDOWNTIMER03
  if (SYSTICKDOWNTIMER03 != 0)
  {
    SYSTICKDOWNTIMER03--;
  }
  #endif

  #ifdef SYSTICKDOWNTIMER04
  if (SYSTICKDOWNTIMER04 != 0)
  {
    SYSTICKDOWNTIMER04--;
  }
  #endif

  #ifdef SYSTICKDOWNTIMER05
  if (SYSTICKDOWNTIMER05 != 0)
  {
    SYSTICKDOWNTIMER05--;
  }
  #endif

  #ifdef SYSTICKDOWNTIMER06
  if (SYSTICKDOWNTIMER06 != 0)
  {
    SYSTICKDOWNTIMER06--;
  }
  #endif
}

#pragma GCC diagnostic pop
