// 128k teszt
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "uart.h"
#include "stm32f10x_conf.h"

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#pragma GCC diagnostic ignored "-Wreturn-type"

#define FLASH_ADDR_LO 0x0800FFF0
#define FLASH_ADDR_HI 0x0801FFF0

uint8_t lastByte = 0;

void dumpFlash(int address)
{
  uint8_t * data = (uint8_t *)(address);

  printf("%08x: ", (uint32_t)data);
  for(int i=0; i < 16; i++) {
    printf("%02x ", lastByte = data[i]);
  }
  printf("\n");
}

void writeFlash(int address)
{
  FLASH_Unlock();
  FLASH_ErasePage(address & 0xFFFFFC00 );

  for(int i=0; i < 16; i+=2)
  {
    uint16_t hword = (++lastByte);
    hword |= (uint16_t)(++lastByte) << 8;

    FLASH_ProgramHalfWord(address+i, hword);
  }

  FLASH_Lock();
}

int main(int argc, char* argv[])
{
  uart_init(115200);
  printf("Flash teszt!\n");

  dumpFlash(FLASH_ADDR_LO);
  dumpFlash(FLASH_ADDR_HI);

  printf("Most trjuk a fels rszt!\n");

  writeFlash(FLASH_ADDR_HI);

  dumpFlash(FLASH_ADDR_LO);
  dumpFlash(FLASH_ADDR_HI);

  while(1);
}

#pragma GCC diagnostic pop

// ----------------------------------------------------------------------------
