#include <LEDFader.h>
#define LED_NUM 3
LEDFader leds[LED_NUM] = { // 3 LEDs (perhaps 1 RGB LED)
  LEDFader(6),
  LEDFader(9),
  LEDFader(10),
};
void setup() {}
void loop() {
  for (byte i = 0; i < LED_NUM; i++) {  // Update all LEDs and start new fades if any are done
    LEDFader *led = &leds[i];
    led->update();
   if (led->is_fading() == false) {    // Set new fade
      int duration = random(1000, 3000); // between 1 - 3 seconds
      if (led->get_value() == 0) {      // Up
        byte color = random(100, 255);
        led->fade(color, duration);
      } else {      // Down
        led->fade(0, duration);
      }
    }
  }
}
