'
'                                ___________
'                                |    U    |
'                          RST  =|1      20|= Vcc
'                                |         |                   __________
'    nc.             (RXD) P3.0 =|2      19|= P1.7             Volume LED
'                                |         |                   ___________
'    nc.             (TXD) P3.1 =|3      18|= P1.6             Balance LED
'                                |         |                   __________
'                         XTAL2 =|4      17|= P1.5             Treble LED
'                                |         |                   ________
'                         XTAL1 =|5      16|= P1.4             Bass LED
'    __                          |         |                   ________
'    Ir             (INT0) P3.2 =|6      15|= P1.3             Mute LED
'                                |         |                   ______
'    Power enable   (INT1) P3.3 =|7      14|= P1.2             Ir_LED
'                                |         |                   _______
'    SDA              (T0) P3.4 =|8      13|= P1.1 (AIN1)      CH3 LED
'                                |         |                   _______
'    SCL              (T1) P3.5 =|9      12|= P1.0 (AIN2)      CH2 LED
'                                |         |                   _______
'                          GND  =|10     11|= P3.7             CH1 LED
'                                |_________|
'
'
'



Declare Sub Scl_0
Declare Sub Scl_1
Declare Sub Sda_0
Declare Sub Sda_1
Declare Sub Start_i2c
Declare Sub Stop_i2c
Declare Sub I2c_wr
Declare Sub I2c_rd
Declare Sub Peek_i2c (i2c_address As Byte)
Declare Sub Poke_i2c (i2c_address As Byte , I2c_data As Byte)
Declare Sub I2c_out (i2c_data As Byte )
Declare Sub I2c_in


Declare Sub Adjust

'$large
$crystal = 11059000
'Config Lcd = 20 * 2


Ir Alias P3.2
Power_enable Alias P3.3
Volume_led Alias P1.7
Balance_led Alias P1.6
Treble_led Alias P1.5
Bass_led Alias P1.4
Mute_led Alias P1.3
Ir_led Alias P1.2
Ch3_led Alias P1.1
Ch2_led Alias P1.0
Ch1_led Alias P3.7


Power_enable = 0



Dim New As Bit
Dim Valt As Bit
Dim Address As Byte
Dim Command As Byte
Dim Temp1 As Byte
Dim Temp2 As Byte


Dim Slave_address As Byte
Dim I2c_address As Byte
Dim I2c_data As Byte
Dim I2c_byte As Byte
Dim I2c_tmp0 As Byte
Dim I2c_tmp1 As Byte

Sda_pin Alias P3.4
Scl_pin Alias P3.5


Config Timer1 = Timer , Gate = Internal , Mode = 0
Start Timer1

On Int0 Rc5decoder
Enable Int0
Enable Interrupts


Const Sw_power_on = &H75
Const Sw_power_off = &H34
Const Sw_mute = &H74
Const Sw_channel = &H1F
Const Sw_back = &H71
Const Sw_next = &H31
Const Sw_down = &H72
Const Sw_up = &H32

Const Tda7318_addr = &B10001000
Slave_address = Tda7318_addr

Dim Volume As Byte
Dim Balance As Byte
Dim Treble As Byte
Dim Bass As Byte
Dim Channel As Byte
Dim Mute As Bit
Dim Delay_mute As Word

Dim Menu As Byte
Dim Tmp0_byte As Byte

Volume = 63
Balance = 31
Treble = 7
Bass = 7
Channel = 0
Mute = 0
Delay_mute = 0
Menu = 0

Command = Sw_power_off
New = 1




I2c_out &B00100100

I2c_out &B10011100
I2c_out &B10111100
I2c_out &B11011100
I2c_out &B11111100

I2c_out &B01000000


Do
   If New = 1 Then
      Disable Int0
      Reset Ir_led


      If Command = Sw_power_off Then
         I2c_out &B00111111
         Waitms 255
         Power_enable = 0
         Mute = 1
         P3.7 = 1
         P1 = &B11111011
         Goto Comm_end
      End If

      If Command = Sw_power_on Then
         If Power_enable = 0 Then
            Power_enable = 1
            Delay_mute = 2000
            Mute = 0
         End If
      End If

      If Power_enable = 0 Then Goto Comm_end

      If Command = Sw_mute Then
         If Mute = 0 Then
            Mute = 1
            Reset Mute_led
         Else
            Mute = 0
            Set Mute_led
         End If
         Waitms 255
      End If

      If Command = Sw_next Then
         If Menu < 3 Then
            Incr Menu
            Waitms 150
         End If
      End If

      If Command = Sw_back Then
         If Menu > 0 Then
            Decr Menu
            Waitms 150
         End If
      End If

      If Command = Sw_channel Then
         Incr Channel
         If Channel > 2 Then Channel = 0
         Delay_mute = 500
         Waitms 150
      End If


'      Locate 1 , 1
'      Lcd "Cmd:" ; Command ; " Mute:" ; Mute ; " Ch:" ; Channel ; "      "
'      Locate 2 , 1
'      Lcd "V:" ; Volume ; " B:" ; Balance ; " T:" ; Treble ; " B:" ; Bass;"   "


      Tmp0_byte = P1 Or &B11110000
      Adjust


      'Out volume
      Volume = Volume And &B00111111
      If Mute = 0 Then
         If Delay_mute = 0 Then
            I2c_out Volume
         Else
            I2c_out &B00111111
         End If
      Else
            I2c_out &B00111111
      End If

      'Out balance
      If Balance <= 31 Then
         Tmp0_byte = Balance And &B00011111
         Tmp0_byte = 255 - Tmp0_byte
         Tmp0_byte = Tmp0_byte And &B00011111

         Tmp0_byte = Tmp0_byte Or &B10000000
         I2c_out Tmp0_byte
         I2c_out &B10100000
      Else
         Tmp0_byte = Balance And &B00011111

         Tmp0_byte = Tmp0_byte And &B00011111
         Tmp0_byte = Tmp0_byte Or &B10100000
         I2c_out Tmp0_byte
         I2c_out &B10000000
      End If


      'Out treble
      Tmp0_byte = Treble And &B00001111
      If Tmp0_byte < 8 Then
         Tmp0_byte = Tmp0_byte Or &B01110000
      Else
         Tmp0_byte = 255 - Tmp0_byte
         Tmp0_byte = Tmp0_byte And &B00001111
         Tmp0_byte = Tmp0_byte Or &B01111000
      End If
      I2c_out Tmp0_byte


      'Out bass
      Tmp0_byte = Bass And &B00001111
      If Tmp0_byte < 8 Then
         Tmp0_byte = Tmp0_byte Or &B01100000
      Else
         Tmp0_byte = 255 - Tmp0_byte
         Tmp0_byte = Tmp0_byte And &B00001111
         Tmp0_byte = Tmp0_byte Or &B01101000
      End If
      I2c_out Tmp0_byte


      If Channel = 0 Then
         Ch1_led = 0
         I2c_out &B01011010
      Else
         Ch1_led = 1
      End If

      If Channel = 1 Then
         Ch2_led = 0
         I2c_out &B01011001
      Else
         Ch2_led = 1
      End If

      If Channel = 2 Then
         Ch3_led = 0
         I2c_out &B01011000
      Else
         Ch3_led = 1
      End If


Comm_end:
      New = 0
      Enable Int0
   End If


   If Delay_mute <> 0 Then
      Delay_mute = Delay_mute - 1
   End If

   If Delay_mute = 1 Then
      If Mute = 0 Then
         Volume = Volume And &B00111111
         I2c_out Volume
      End If
   End If

   If Delay_mute > 1 Then
      I2c_out &B00111111
   End If



   If Power_enable = 1 Then
      Set Ir_led
   Else
      Reset Ir_led
   End If

   Enable Int0
'   If Delay_mute = 0 Then Idle
Loop













Sub Adjust

   Select Case Menu
      Case 0 : Goto Volume_controll
      Case 1 : Goto Balance_controll
      Case 2 : Goto Treble_controll
      Case 3 : Goto Bass_controll
      Case Else Exit Sub
   End Select

Volume_controll:
   Reset Volume_led
   Set Balance_led
   Set Treble_led
   Set Bass_led
   If Command = Sw_down Then
      If Volume < 63 Then
         Incr Volume
      Else
         Waitms 200
      End If
   End If

   If Command = Sw_up Then
      If Volume > 0 Then
         Decr Volume
      Else
         Waitms 200
      End If
   End If
   Exit Sub

Balance_controll:
   Set Volume_led
   Reset Balance_led
   Set Treble_led
   Set Bass_led

   If Command = Sw_up Then
      If Balance < 63 Then
         Incr Balance
      Else
         Waitms 200
      End If
   End If

   If Command = Sw_down Then
      If Balance > 0 Then
         Decr Balance
      Else
         Waitms 200
      End If
   End If
   Exit Sub

Treble_controll:
   Set Volume_led
   Set Balance_led
   Reset Treble_led
   Set Bass_led

   If Command = Sw_up Then
      If Treble < 15 Then
         Incr Treble
      Else
         Waitms 200
      End If
   End If

   If Command = Sw_down Then
      If Treble > 0 Then
         Decr Treble
      Else
         Waitms 200
      End If
   End If
   Exit Sub

Bass_controll:
   Set Volume_led
   Set Balance_led
   Set Treble_led
   Reset Bass_led

   If Command = Sw_up Then
      If Bass < 15 Then
         Incr Bass
      Else
         Waitms 200
      End If
   End If

   If Command = Sw_down Then
      If Bass > 0 Then
         Decr Bass
      Else
         Waitms 200
      End If
   End If
   Exit Sub



End Sub







Sub I2c_out (i2c_data As Byte)
   Start_i2c
   I2c_byte = Slave_address : I2c_wr
   I2c_byte = I2c_data : I2c_wr
   Stop_i2c
End Sub

Sub I2c_in
   Start_i2c
   I2c_byte = Slave_address + 1 : I2c_wr
   I2c_rd : I2c_data = I2c_byte
   Stop_i2c
End Sub

Sub Peek_i2c (i2c_address As Byte )
   Start_i2c
   I2c_byte = Slave_address : I2c_wr
   I2c_byte = I2c_address : I2c_wr
   Start_i2c
   I2c_byte = Slave_address + 1 : I2c_wr
   I2c_rd : I2c_data = I2c_byte
   Stop_i2c
End Sub

Sub Poke_i2c (i2c_address As Byte , I2c_data As Byte )
   Start_i2c
   I2c_byte = Slave_address : I2c_wr
   I2c_byte = I2c_address : I2c_wr
   I2c_byte = I2c_data : I2c_wr
   Stop_i2c
End Sub

Sub I2c_wr
   I2c_tmp1 = 128
   Do
      I2c_tmp0 = I2c_byte And I2c_tmp1
      Scl_0
      If I2c_tmp0 = 0 Then
         Sda_0
         Scl_1
      Else
         Sda_1
         Scl_1
      End If
      Rotate I2c_tmp1 , Right , 1
   Loop Until I2c_tmp1 = 128
   Scl_0
   Sda_1
   Scl_1
   Scl_0
End Sub

Sub I2c_rd
   I2c_byte = 0
   For I2c_tmp0 = 1 To 8
      Scl_0
      Rotate I2c_byte , Left , 1
      If Sda_pin = 1 Then Incr I2c_byte
      Scl_1
   Next I2c_tmp0
   Scl_0
   Sda_1
   Scl_1
   Scl_0
End Sub

Sub Scl_0
   Reset Scl_pin
   nop
   nop
End Sub

Sub Scl_1
   Set Scl_pin
   nop
   nop
End Sub

Sub Sda_0
   Reset Sda_pin
   nop
   nop
End Sub

Sub Sda_1
   Set Sda_pin
   nop
   nop
End Sub

Sub Start_i2c
   Sda_1
   Scl_1
   Sda_0
End Sub

Sub Stop_i2c
   Scl_0
   Sda_0
   Scl_1
   Sda_1
End Sub


Rc5decoder:

   Disable Int0
   Reset Pcon.0
$asm
Irw:
   acall check_l          ' ha a startbit L szintje < 40
   mov a,r3                ' akkor nem a start bitet kapta el
   clr c
   subb a,#18
   jc Decoder_hiba
   acall check_h          ' ha a startbit H szintje < 20
   mov a,r3                ' akkor nem a start bitet kapta el
   clr c
   subb a,#18
   jc Decoder_hiba

   acall check_l
   mov a,r3
   clr c
   subb a,#40
   jc Gvalt
   clr {Valt}
   ajmp Nvalt
Gvalt:
   setb {Valt}
Nvalt:
   acall check_h
   mov a,r3
   clr c
   subb a,#20
   jc Decoder_hiba


' Az Rc5 Cim Beolvasasa

   mov {Temp1},#0
   mov r4,#8
Address_byte:
      acall check_l       ' ha a bit elvalaszto L szint < 2
      mov a,r3             ' akkor hiba a jelben
      clr c
      subb a,#20 '2
      jc Decoder_hiba
      acall check_h
      mov a,r3
      clr c
      subb a,#40 '6
      jc abit_h
Abit_l:
      clr c
Abit_h:
      mov a,{Temp1}
      rrc a
      mov {Temp1},a
   djnz r4,Address_byte
   cpl a
   mov {Address},a


' Az RC5 parancs beolvasasa

   mov {Temp2},#0
   mov r4,#3
Command_byte:
      acall check_l       ' ha a bit elvalaszto L szint < 2
      mov a,r3             ' akkor hiba a jelben
      clr c
      subb a,#20 '2
      jc Decoder_hiba
      acall check_h
      mov a,r3
      clr c
      subb a,#40 '6
      jc cbit_h
Cbit_l:
      clr c
Cbit_h:
      mov a,{Temp2}
      rrc a
      mov {Temp2},a
   djnz r4,Command_byte
   cpl a
   mov {Command},a

   acall check_l 'h
   mov a,r3
   clr c
   subb a,#80
   jnc Decoder_hiba
   setb {New}
   ajmp Decoder_end

Decoder_hiba:
   mov a,r4
   dec a
   jz Ch9bit
   dec a
   jz Ch9bit
   clr {New}
   ajmp Decoder_end


Ch9bit:
   acall check_h
   mov a,r3
   clr c
   subb a,#128
   mov a,{Temp2}
   cpl a
   mov {Command},a
   setb {New}

   mov a,{Address}
   rr a
   rr a
   rr a
   rr a
   anl a,#&H0F
   anl {Command},#&HF0
   orl a,{Command}
   mov {Command},a

Decoder_end:
   nop
$end Asm

Return

$asm
Check_l:
   mov tl1,#0
   mov th1,#0
   mov tl1,#0
   clr tcon.7
Lw1:
   jb tcon.7,Lw_end
   jnb ir,Lw1
Lw_end:
   mov r3,th1
   mov r0,tl1
   ret

Check_h:
   mov tl1,#0
   mov th1,#0
   mov tl1,#0
   clr tcon.7
Hw1:
   jb  tcon.7,Hw_end
   jb ir,Hw1
Hw_end:
   mov r3,th1
   mov r0,tl1
   ret
$end Asm