/** INCLUDES *******************************************************/
//#include "../Microchip/Include/GenericTypeDefs.h"
#include "../Microchip/Include/Compiler.h"

/**********************
 * Configuration Bits *
 **********************/
#pragma config UPLLEN   = ON            // USB PLL Enabled
#pragma config FPLLMUL  = MUL_20        // PLL Multiplier
#pragma config UPLLIDIV = DIV_2         // USB PLL Input Divider
#pragma config FPLLIDIV = DIV_2         // PLL Input Divider
#pragma config FPLLODIV = DIV_1         // PLL Output Divider
#pragma config FPBDIV   = DIV_1         // Peripheral Clock divisor
#pragma config FWDTEN   = OFF           // Watchdog Timer
#pragma config WDTPS    = PS1           // Watchdog Timer Postscale
#pragma config FCKSM    = CSDCMD        // Clock Switching & Fail Safe Clock Monitor
#pragma config OSCIOFNC = OFF           // CLKO Enable
#pragma config POSCMOD  = HS            // Primary Oscillator
#pragma config IESO     = OFF           // Internal/External Switch-over
#pragma config FSOSCEN  = OFF           // Secondary Oscillator Enable
#pragma config FNOSC    = PRIPLL        // Oscillator Selection
#pragma config CP       = OFF           // Code Protect
#pragma config BWP      = OFF           // Boot Flash Write Protect
#pragma config PWP      = OFF           // Program Flash Write Protect
#pragma config ICESEL   = ICS_PGx2      // ICE/ICD Comm Channel Select
#pragma config DEBUG    = OFF           // Debugger Disabled for Starter Kit

#define SPI_CS_TRIS		TRISDbits.TRISD1		//D1 chip vlaszts
#define SPI_CS			LATDbits.LATD1			//D1 chip vlaszts
#define SPI_SO_TRIS		TRISDbits.TRISD0		//B0-s bit
#define SPI_SCK_TRIS	TRISDbits.TRISD10		//D10-es bit rajel
#define SPI_SI			TRISCbits.TRISC4		//C4 adat ki*/

int main(void){
	int rData;
	int i;

	TRISA = 0; PORTA = 0; LATA = 0;
    TRISB = 0; PORTB = 0; LATB = 0;
    TRISC = 0; PORTC = 0; LATC = 0;
    TRISD = 0; PORTD = 0; LATD = 0;
    TRISE = 0; PORTE = 0; LATE = 0;
    TRISF = 0; PORTF = 0; LATF = 0;
    TRISG = 0; PORTG = 0; LATG = 0;

	SPI_CS_TRIS = 0;
	SPI_CS = 1;
	SPI_SO_TRIS = 0;
	SPI_SCK_TRIS = 0;
	SPI_SI = 1;

	LATEbits.LATE3 = 1;	// LED1
	LATEbits.LATE2 = 1;	// LED2
	LATEbits.LATE1 = 1;	// LED3
	LATEbits.LATE0 = 1;	// LED4

	INTCON = 0;
    AD1CON1 = 0;
	AD1PCFG = 0xFFFF;      // Configure AN pins as digital I/O
    DDPCONbits.JTAGEN = 0; // disable the JTAG port
	CM1CON = 0;
	CM2CON = 0;
	CVRCON = 0;
    U1CON = 0;	

    // Configure the proper PB frequency and the number of wait states
	SYSTEMConfigWaitStatesAndPB(80000000L);

    // Enable the cache for the best performance
	CheKseg0CacheOn();	

 	mJTAGPortEnable(0);
	PMCONbits.ON = 0;

	IEC0CLR=0x03800000; // disable all interrupts
    SPI1CON = 0; // Stops and resets the SPI1.
    rData=SPI1BUF; // clears the receive buffer
    IFS0CLR=0x03800000; // clear any existing event
    IPC5CLR=0x1f000000; // clear the priority
    IPC5SET=0x0d000000; // Set IPL=3, Subpriority 1
    IEC0SET=0x03800000; // Enable RX, TX and Error interrupts
    SPI1BRG=99; // 400KHz clock frequency
    SPI1STATCLR=0x40; // clear the Overflow
    SPI1CON=0x8220; // SPI ON, 8 bits transfer, SMP=1, Master mode
    // from now on, the device is ready to transmit and receive data
    SPI1BUF='A'; // transmit an A character
	i=1;
    while(1){
		rData=SPI1BUF; // clears the receive buffer
        SPI1BUF= 'A'; // transmit an A character
        while(i < 1000){i++;}
        i = 0;
    }

}
