#include <avr/io.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include <math.h>
#include "menu.h"
#include "eestruct.h"
#include "hardware.h"
#include "adelay.h"

#ifndef F_CPU
    #warning "H F_CPU not defined. Will default to 16000000"
    #define F_CPU 16000000UL
#endif


#define enter PB5 // Enter key.
#define up    PB4 // Up key.
#define down  PB3 // Down key.

#define delay(_ms) Delay_ms(_ms)


void ultofix(uint32_t,char *);




void ultofix(uint32_t x, char *s){

    uint32_t temp;
    char str[10];

    temp = x/10;
    ultoa(temp,str,10);
    strcpy(s,str);
    strcat(s,".");
    temp = (x%10);
    ultoa(temp,str,10);
    strcat(s,str);

}

extern struct {

    uint16_t n_time_on,n_time_off;
    uint32_t s_time_on, s_time_off;
    uint32_t w_time,w_time_on,w_time_off;
    uint32_t f_time, i_time, i_air_time;
    uint32_t c_time;

    unsigned int ver,crc16;

} vars;

void menu() {

    char s[10];
    uint8_t page=0, change=1, menu_change=0, save=0;

    DDRB &= ~((1<<enter)|(1<<up)|(1<<down));     // PB5, PB4, PB3 as input.
    PORTB |= (1<<enter)|(1<<up)|(1<<down);       // PB5, PB4, PB3 pull up enabled.

    lcd_clrscr();
    lcd_puts_P("MENU");

    delay(1000);

    while(bit_is_clear(PINB,enter));            // Wait for the menu key (enter) to be released.

    delay(1000);

    lcd_clrscr();


    while(1){


        if (bit_is_clear(PINB,enter)){

            delay(25);                          // Some Debounce time.

            if (bit_is_clear(PINB,enter)) {

                delay(200);
                change=1;
                menu_change=1;
                page++;
                if (page >= 11) page = 0;
            };
        };


        if (bit_is_clear(PINB,up)){

            delay(25);

            if (bit_is_clear(PINB,up)){

                change=1;
                save=1;

                delay(100);

                switch (page) {

                case 0:
                    vars.n_time_on++;
                    if (vars.n_time_on>=200) vars.n_time_on=200;
                    break;

                case 1:
                    vars.n_time_off++;
                    if (vars.n_time_off>=200) vars.n_time_off=200;

                    break;

                case 2:
                    vars.s_time_on++;
                    if (vars.s_time_on>=100) vars.s_time_on=100;

                    break;

                case 3:
                    vars.s_time_off++;
                    if (vars.s_time_off>=60) vars.s_time_off=60;

                    break;

                case 4:
                    vars.w_time++;
                    if (vars.w_time>=300) vars.w_time=300;

                    break;

                case 5:
                    vars.w_time_on++;
                    if(vars.w_time_on>=10) vars.w_time_on=10;

                    break;

                case 6:
                    vars.w_time_off++;
                    if(vars.w_time_off>=120) vars.w_time_off=120;

                    break;

                case 7:
                    vars.f_time++;
                    if(vars.f_time>=120) vars.f_time=120;

                    break;

                case 8:
                    vars.i_time++;
                    if(vars.i_time>=240) vars.i_time=240;

                    break;

                case 9:
                    vars.i_air_time++;
                    if(vars.i_air_time>=240) vars.i_air_time=240;

                    break;

                case 10:
                    vars.c_time++;
                    if(vars.c_time>=600) vars.c_time=600;

                    break;
            };


            };
        };


        if (bit_is_clear(PINB,down)){

            delay(25);

            if (bit_is_clear(PINB,down)){

                change=1;
                save=1;

                delay(100);

                switch (page) {

                case 0:
                    vars.n_time_on--;
                    if (vars.n_time_on<=10) vars.n_time_on=10;
                    break;

                case 1:
                    vars.n_time_off--;
                    if (vars.n_time_off<=10) vars.n_time_off=10;

                    break;

                case 2:
                    vars.s_time_on--;
                    if (vars.s_time_on<=10) vars.s_time_on=10;

                    break;

                case 3:
                    vars.s_time_off--;
                    if (vars.s_time_off<=10) vars.s_time_off=10;

                    break;

                case 4:
                    vars.w_time--;
                    if (vars.w_time<=60) vars.w_time=60;

                    break;

                case 5:
                    vars.w_time_on--;
                    if(vars.w_time_on<=1) vars.w_time_on=1;

                    break;

                case 6:
                    vars.w_time_off--;
                    if(vars.w_time_off<=10) vars.w_time_off=10;

                    break;

                case 7:
                    vars.f_time--;
                    if(vars.f_time<=5) vars.f_time=5;

                    break;

                case 8:
                    vars.i_time--;
                    if(vars.i_time<=60) vars.i_time=60;

                    break;

                case 9:
                    vars.i_air_time--;
                    if(vars.i_air_time<=60) vars.i_air_time=60;

                    break;

                case 10:
                    vars.c_time--;
                    if(vars.c_time<=60) vars.c_time=60;

                    break;

            };



            };
        };


        if (change){

            change=0;

            if (menu_change) {
                lcd_clrscr();
                menu_change=0;
            };

            switch (page) {

                case 0:
                    lcd_home();
                    lcd_puts_P("NORMAL TIME ON:");
                    ultofix(vars.n_time_on,s);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 1:
                    lcd_home();
                    lcd_puts_P("NORMAL TIME OFF:");
                    ultofix(vars.n_time_off,s);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 2:
                    lcd_home();
                    lcd_puts_P("STBY TIME ON:");
                    ultofix(vars.s_time_on,s);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 3:
                    lcd_home();
                    lcd_puts_P("STBY TIME OFF:");
                    ultoa(vars.s_time_off,s,10);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 4:
                    lcd_home();
                    lcd_puts_P("WARM TIME:");
                    ultoa(vars.w_time,s,10);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 5:
                    lcd_home();
                    lcd_puts_P("WARM TIME ON:");
                    ultoa(vars.w_time_on,s,10);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 6:
                    lcd_home();
                    lcd_puts_P("WARM TIME OFF:");
                    ultoa(vars.w_time_off,s,10);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 7:
                    lcd_home();
                    lcd_puts_P("FEED TIME:");
                    ultoa(vars.f_time,s,10);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 8:
                    lcd_home();
                    lcd_puts_P("IGNITION TIME:");
                    ultoa(vars.i_time,s,10);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 9:
                    lcd_home();
                    lcd_puts_P("IGN AIR TIME:");
                    ultoa(vars.i_air_time,s,10);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

                case 10:
                    lcd_home();
                    lcd_puts_P("CLEANING TIME:");
                    ultoa(vars.c_time,s,10);
                    lcd_gotoxy(0,1);
                    lcd_puts(s);
                    lcd_puts_P(" secs  ");

                    break;

            };

        };


        if (!bit_is_clear(PINB,up) && !bit_is_clear(PINB,down) && save) {

                SaveEEPROMStructure(0,&vars);
                save=0;
        };

    };

}
