#include <avr/io.h>
#include <avr/sleep.h>
#include "hardware.h"


void millis_init(void){

    TIMSK0 |= (1 << TOIE0);           // Enable overflow Interrupt υπερχείλισης for Timer/Counter0.
    TCNT0 = 6;                        // Preload Timer with the calculated value for 1 msec.
    TCCR0B |= (1<<CS01) | (1<<CS00);  // Start Timer/Counter0 with Prescaler 64.
}

void adc_init(){

    // ADC in single conversion mode.

    ADMUX |= (1<<REFS0);                         // AVCC with external capacitor at AREF pin.

    ADCSRA |= (1<<ADPS2)|(1<<ADPS1)|(1<<ADPS0);  // Prescaler 128 (16 MHz/64=125KHz).

    ADCSRA |= (1<<ADEN);                         // Enable ADC.

    ADCSRA |= (1<<ADSC);                        // Start ADC conversion

    set_sleep_mode(SLEEP_MODE_ADC);             // Set sleep mode for ADC noise reduction conversion

}
