#include "string.h"
#include "avr/eeprom.h"
#include "util/crc16.h"
#include "eestruct.h"

#define MAX_EEPROM_SEGMENTS 2

struct
  {
    unsigned int Offset,Size,StructureSize,Slots,Slot,Ver;
    unsigned char Loaded;
  } Eeprom[MAX_EEPROM_SEGMENTS];

unsigned int Crc16Memory(void *AData, unsigned int ASize)
{
  unsigned int crc,i1;

  crc=0xffff;
  for (i1=0;i1<ASize;i1++)
    crc=_crc16_update(crc,((unsigned char*)AData)[i1]); 
  return ~crc;
}

unsigned char SetEEPROMStructureParameters(unsigned char ASegment, unsigned int AOffset, unsigned int ASize, unsigned AStructureSize)
{
  if (!AStructureSize || ASize<16 || AStructureSize<8 || AOffset%4!=0 || ASize%4!=0 || ASegment>=MAX_EEPROM_SEGMENTS)
    return 0;
  Eeprom[ASegment].Slot=Eeprom[ASegment].Ver=65535;
  Eeprom[ASegment].Loaded=0;
  Eeprom[ASegment].Offset=AOffset;
  Eeprom[ASegment].Size=ASize;
  Eeprom[ASegment].StructureSize=AStructureSize;
  Eeprom[ASegment].Slots=((ASize/2)/AStructureSize);
  if (Eeprom[ASegment].Slots<1)
    return 0;
  return 1;
}

void ClearEEPROM(unsigned char ASegment)
{
  unsigned int i1;
  unsigned long ul1=0xffffffff;

  for (i1=0;i1<Eeprom[ASegment].Size;i1+=4)
    eeprom_write_block(&ul1,(void*)(i1+Eeprom[ASegment].Offset),4);
  Eeprom[ASegment].Slot=65535;
  Eeprom[ASegment].Ver=65535;
  Eeprom[ASegment].Loaded=1;
}

unsigned char LoadEEPROMStructure(unsigned char ASegment,void *AStructure)
{
  unsigned int i1,i2,crc,crc2,ver;
  unsigned char found=0;
  void *ptr,*ptr2=NULL;

  Eeprom[ASegment].Loaded=1;
  for (i1=0;i1<2;i1++)
    for (i2=0;i2<Eeprom[ASegment].Slots;i2++)
      {
        ptr=(void*)(i2*Eeprom[ASegment].StructureSize+i1*(Eeprom[ASegment].Size/2)+Eeprom[ASegment].Offset);
        eeprom_read_block(AStructure,ptr,Eeprom[ASegment].StructureSize);
        crc=Crc16Memory(AStructure,Eeprom[ASegment].StructureSize-2);
        memcpy(&crc2,AStructure+Eeprom[ASegment].StructureSize-2,2);
        if (crc==crc2)
          {
            memcpy(&ver,AStructure+Eeprom[ASegment].StructureSize-4,2);
            if ((!found) || (ver<16384 && Eeprom[ASegment].Ver>=49152) || (ver>Eeprom[ASegment].Ver && !(ver>=49152 && Eeprom[ASegment].Ver<16384)))
              {
                ptr2=ptr;
                Eeprom[ASegment].Slot=i2;
                Eeprom[ASegment].Ver=ver;
                found=1;
              }
          }
      }
  if (found)
    eeprom_read_block(AStructure,ptr2,Eeprom[ASegment].StructureSize);
  return found;
}

unsigned char SaveEEPROMStructure(unsigned char ASegment,void *AStructure)
{
  unsigned int crc;

  if (!Eeprom[ASegment].Loaded)
    return 0;
  Eeprom[ASegment].Slot++;
  if (Eeprom[ASegment].Slot>=Eeprom[ASegment].Slots)
    Eeprom[ASegment].Slot=0;
  Eeprom[ASegment].Ver++; //It may roll over but that is ok
  memcpy(AStructure+Eeprom[ASegment].StructureSize-4,&Eeprom[ASegment].Ver,2);
  crc=Crc16Memory(AStructure,Eeprom[ASegment].StructureSize-2);
  memcpy(AStructure+Eeprom[ASegment].StructureSize-2,&crc,2);
  eeprom_write_block(AStructure,(void*)(Eeprom[ASegment].Slot*Eeprom[ASegment].StructureSize+Eeprom[ASegment].Offset),Eeprom[ASegment].StructureSize);
  eeprom_write_block(AStructure,(void*)(Eeprom[ASegment].Slot*Eeprom[ASegment].StructureSize+(Eeprom[ASegment].Size/2)+Eeprom[ASegment].Offset),Eeprom[ASegment].StructureSize);
  return 1;
}
