/* Copyright (C) 2017, Attila Kovs
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation  and/or other materials provided with the distribution.
 * 3. Neither the names of the copyright holders nor the names of any
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* This file is part of LwOS (Lightweight runtime Operating System).
 */

#ifndef LWOS_CONFIG_H_INCLUDED
#define LWOS_CONFIG_H_INCLUDED

#define STACK_DEBUG                           // Enable debugging for stack overflow faults
#define TASK_DEBUG                            // Stores additional task information in header
#define NESTED_IRQ_LOCK                       // IRQ locking uses counting semaphore for disabling/enabling interrupts
#define LOCKING_DEBUG                         // Enable debugging for locking issues (only for nested IRQ locks)
#define MAIN_TASK_CONTINUES                   // The main task (LwOS starting point) continues to run (like any other tasks)
#define HIGH_PRIORITY_OVER_OTHERS             // High priority tasks blocks other tasks (if not blocked or sleeping)

// The following definitions need to be adjusted according to the current application linker script
#define STACK_TOP             __StackTop      // Linker variable (beginning of main stack memory)
#define STACK_LIMIT           __StackLimit    // Linker variable (end of main stack memory)
#define HEAP_LIMIT            __HeapLimit     // Linker variable, in most cases it should be equal to __bss_end__

#define LWOS_TICK             2000            // Time-slice frequency per second (must be a divisor of 10000 for accurate timekeeping), also sets the resolution of time reference
typedef uint64_t              LwOS_TimeRef_t; // Time reference base type (depends on maximum running time of application)

#endif /* LWOS_CONFIG_H_INCLUDED */
