/* Copyright (C) 2017, Attila Kovs
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation  and/or other materials provided with the distribution.
 * 3. Neither the names of the copyright holders nor the names of any
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* This file is part of LwOS (Lightweight runtime Operating System).
 */

#ifndef MACRO_CM3_H_INCLUDED
#define MACRO_CM3_H_INCLUDED

#define PRIORITY_SVCALL                     0
#define PRIORITY_SYSTICK                    0
#define PRIORITY_PENDSV                     (0xFF >> (8 - __NVIC_PRIO_BITS))
#define PRIORITY_MAX                        (PRIORITY_SVCALL + 1)
#define PRIORITY_MIN                        (PRIORITY_PENDSV - 1)
#define MAX_IRQ_FILTER                      (PRIORITY_MAX << (8 - __NVIC_PRIO_BITS))
#define MEM_ALIGN                           sizeof(int)
#define MEM_ALIGNED                         __attribute__ ((aligned (MEM_ALIGN)))

#define ENABLE_IRQ()                        __enable_irq()
#define DISABLE_IRQ()                       __disable_irq()

#ifdef NESTED_IRQ_LOCK
#define LOCK()                              do {                                                        \
                                              DISABLE_IRQ();                                            \
                                              if (!__IRQLock++) __set_BASEPRI(MAX_IRQ_FILTER);          \
                                              ENABLE_IRQ();                                             \
                                            } while(0)

#define UNLOCK()                            do {                                                        \
                                              DISABLE_IRQ();                                            \
                                              if (!--__IRQLock) __set_BASEPRI(0);                       \
                                              ENABLE_IRQ();                                             \
                                            } while(0)

#define LOCK_SIMPLE()                      __set_BASEPRI(MAX_IRQ_FILTER)
#define UNLOCK_SIMPLE()                     __set_BASEPRI(0)
#else
#define LOCK()                             __set_BASEPRI(MAX_IRQ_FILTER)
#define UNLOCK()                            __set_BASEPRI(0)
#define LOCK_SIMPLE()                       LOCK()
#define UNLOCK_SIMPLE()                     UNLOCK()
#endif

#endif /* MACRO_CM3_H_INCLUDED */
