/* Copyright (C) 2017, Attila Kovs
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation  and/or other materials provided with the distribution.
 * 3. Neither the names of the copyright holders nor the names of any
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* This file is part of LwOS (Lightweight runtime Operating System).
 */

#ifndef PLATFORM_CM3_H_INCLUDED
#define PLATFORM_CM3_H_INCLUDED

#include "lwos.h"
#include "lwos_priv.h"

#define GET_PSP                           __get_PSP
#define GET_MSP                           __get_MSP
#define SET_PSP                           __set_PSP

#define __SVC(svccode)                    do { __ASM volatile ("svc %[code]"::[code] "I" (svccode)); } while(0)

#define __SVC_RET(svccode, retval)        do { __ASM volatile (                    \
                                              "svc %[code]        \n\t"       \
                                              "mov %[ret], r0"                \
                                              : [ret] "=r" (retval)           \
                                              : [code] "I" (svccode)          \
                                          ); } while(0)

void Platform_Init(void);
void SysTick_Init(void);

void* CreateContext(void *stackP, void *taskFunc, void *arg, void *returnFunc);
void SetTaskTimeSliceNum(uint16_t num);
#ifdef TASK_DEBUG
uint32_t SysTick_GetReference(uint8_t reset);
#endif

ALWAYSINLINE void RequestContextSwitch(void)
{
	SCB->ICSR |= SCB_ICSR_PENDSVSET_Msk;
}

ALWAYSINLINE void ResetContextSwitchRequest(void)
{
	SCB->ICSR |= SCB_ICSR_PENDSVCLR_Msk;
}

#endif /* PLATFORM_CM3_H_INCLUDED */
