#ifndef BOARD_H_INCLUDED
#define BOARD_H_INCLUDED

#include "stm32f10x.h"
#include "lwos.h"
#include "ext.h"
#include "defines.h"
#include <stdio.h>

#define strconc(str1,str2) str1 str2

// Sections (most of these resources changes rarely, keeping them apart from main code helps with uploading the software during development)
#define FONT                              __attribute__((section(".font")))
#define IMAGE                             __attribute__((section(".image")))
#define TEXT                              __attribute__((section(".str")))
#define TXT(s)                            (__extension__({static const char TEXT __c[] = (s); &__c[0];}))
//#define TXT(s)                            s

// Attributes
#define PACKED                            __attribute__((__packed__))
#define USED                              __attribute__((used))
#define UNUSED                            __attribute__((unused))
#define ALWAYSINLINE                      __attribute__((always_inline)) __STATIC_INLINE
#define ISR(x)                            void __attribute__ ((interrupt ("IRQ"))) x (void)
/*#define ISR(x)                            void ALWAYSINLINE x ## _code (void); \
                                          void __attribute__ ((interrupt ("IRQ"))) x (void) { \
                                            MONITOR_1_SET(); \
                                            x ## _code(); \
                                            MONITOR_1_CLR(); \
                                          } \
                                          void ALWAYSINLINE x ## _code (void)
*/
// Unique identifier
#define UNIQUE_ID                         0x1FFFF7E8

// Clock config faults
#define CLOCK_NO_FLT                      0x00
#define CLOCK_FLT_HSE_ENABLE              0x01
#define CLOCK_FLT_LSE_ON                  0x02

// DEBUG USART
#define USART_DEBUG                       USART1
#define USART_DEBUG_GPIO                  GPIOA
#define USART_DEBUG_CLK                   RCC_APB2Periph_USART1
#define USART_DEBUG_GPIO_CLK              RCC_APB2Periph_GPIOA
#define USART_DEBUG_RxPin                 GPIO_Pin_10
#define USART_DEBUG_TxPin                 GPIO_Pin_9
#define USART_DEBUG_IRQn                  USART1_IRQn
#define USART_DEBUG_IRQHandler            USART1_IRQHandler
#define USART_DEBUG_DMA_CLK               RCC_AHBPeriph_DMA1
#define USART_DEBUG_DMA_Channel           DMA1_Channel4     // Depends on USART! See DMA request mapping
#define USART_DEBUG_DMA_IRQn              DMA1_Channel4_IRQn
#define USART_DEBUG_DMA_IRQHandler        DMA1_Channel4_IRQHandler
#define USART_DEBUG_DMA_FLAG              DMA1_FLAG_TC4
#define USART_DEBUG_DR_Base               0x40013804        // &USART1->DR

// Monitoring
#define MONITORING_GPIO                   GPIOA
#define MONITORING_GPIO_CLK               RCC_APB2Periph_GPIOA
#define MONITORING_1_Pin                  GPIO_Pin_10
#define MONITORING_2_Pin                  GPIO_Pin_9
#if defined(MONITORING) && !defined(USARTDEBUG)
#define MONITOR
#define MONITOR_1_SET()                   GPIO_SetBits(MONITORING_GPIO, MONITORING_1_Pin)
#define MONITOR_2_SET()                   GPIO_SetBits(MONITORING_GPIO, MONITORING_2_Pin)
#define MONITOR_1_CLR()                   GPIO_ResetBits(MONITORING_GPIO, MONITORING_1_Pin)
#define MONITOR_2_CLR()                   GPIO_ResetBits(MONITORING_GPIO, MONITORING_2_Pin)
#else
#define MONITOR_1_SET()                   ((void) 0)
#define MONITOR_2_SET()                   ((void) 0)
#define MONITOR_1_CLR()                   ((void) 0)
#define MONITOR_2_CLR()                   ((void) 0)
#endif

// Timeout Timer
#define TIMER_TIMEOUT                     TIM2
#define TIMER_TIMEOUT_DBGSTOP             DBGMCU_TIM2_STOP
#define TIMER_TIMEOUT_CLK                 RCC_APB1Periph_TIM2
#define TIMER_TIMEOUT_IRQn                TIM2_IRQn
#define TIMER_TIMEOUT_IRQHandler          TIM2_IRQHandler
// WakeUp tick generator timer
#define TIMER_WAKEUP                      TIM5
#define TIMER_WAKEUP_CLK                  RCC_APB1Periph_TIM5
#define TIMER_WAKEUP_IRQn                 TIM5_IRQn
#define TIMER_WAKEUP_IRQHandler           TIM5_IRQHandler
// Keys
#define KEYS_GPIO                         GPIOB
#define KEYS_GPIO_CLK                     RCC_APB2Periph_GPIOB
#define KEYS_SW1_Pin                      GPIO_Pin_15
#define KEYS_SW2_Pin                      GPIO_Pin_14
#define KEYS_SW3_Pin                      GPIO_Pin_13
#define KEYS_EXTI_PortSource              GPIO_PortSourceGPIOB
#define KEYS_EXTI_SW1_PinSource           GPIO_PinSource15
#define KEYS_EXTI_SW2_PinSource           GPIO_PinSource14
#define KEYS_EXTI_SW3_PinSource           GPIO_PinSource13
#define KEYS_EXTI_SW1_Line                EXTI_Line15
#define KEYS_EXTI_SW2_Line                EXTI_Line14
#define KEYS_EXTI_SW3_Line                EXTI_Line13
#define KEYS_EXTI_IRQn                    EXTI15_10_IRQn
#define KEYS_EXTI_IRQHandler              EXTI15_10_IRQHandler
// Seven-segment display
#define SEVSEG_GPIO1                      GPIOA
#define SEVSEG_GPIO2                      GPIOB
#define SEVSEG_GPIO1_CLK                  RCC_APB2Periph_GPIOA
#define SEVSEG_GPIO2_CLK                  RCC_APB2Periph_GPIOB
#define SEVSEG_1_A_Pin                    GPIO_Pin_3
#define SEVSEG_1_B_Pin                    GPIO_Pin_1
#define SEVSEG_2_C_Pin                    GPIO_Pin_2
#define SEVSEG_2_D_Pin                    GPIO_Pin_11
#define SEVSEG_2_E_Pin                    GPIO_Pin_12
#define SEVSEG_1_F_Pin                    GPIO_Pin_2
#define SEVSEG_1_G_Pin                    GPIO_Pin_0
#define SEVSEG_2_DP_Pin                   GPIO_Pin_10
#define SEVSEG_1_Digit1_Pin               GPIO_Pin_4
#define SEVSEG_1_Digit2_Pin               GPIO_Pin_5
#define SEVSEG_1_Digit3_Pin               GPIO_Pin_6
#define SEVSEG_1_Digit4_Pin               GPIO_Pin_7
// LCD
#define LCD_SPI                           SPI1
#define LCD_SPI_CLK                       RCC_APB2Periph_SPI1
#define LCD_SPI_GPIO                      GPIOB                   //SPI
#define LCD_SPI_GPIO_CLK                  RCC_APB2Periph_GPIOB
#define LCD_SPI_CS_Pin                    GPIO_Pin_7              // Warning: Remapped IO!
#define LCD_SPI_SCK_Pin                   GPIO_Pin_3
#define LCD_SPI_MISO_Pin                  GPIO_Pin_4
#define LCD_SPI_MOSI_Pin                  GPIO_Pin_5
#define LCD_SPI_DMA                       DMA1
#define LCD_SPI_DMA_CLK                   RCC_AHBPeriph_DMA1
#define LCD_SPI_DMA_Channel               DMA1_Channel3           // Depends on SPI used! See DMA request mapping
#define LCD_SPI_DMA_IRQn                  DMA1_Channel3_IRQn
#define LCD_SPI_DMA_IRQHandler            DMA1_Channel3_IRQHandler
#define LCD_SPI_DMA_FLAG                  DMA1_FLAG_TC3
//#define LCD_SPI_DR_Base                   0x4001244C
#define LCD_GPIO1                         GPIOB                   //IO
#define LCD_GPIO1_CLK                     RCC_APB2Periph_GPIOB
#define LCD_GPIO2                         GPIOA                   //IO
#define LCD_GPIO2_CLK                     RCC_APB2Periph_GPIOA
#define LCD_1_RESET_Pin                   GPIO_Pin_6
#define LCD_2_DC_Pin                      GPIO_Pin_15
#define LCD_2_LEDCtrl_Pin                 GPIO_Pin_12

// OS Semaphores
typedef struct {
  LwOS_Resource_t usartDebug;
  LwOS_Resource_t timerTick;
} Resource_t;

typedef struct {
  LwOS_Resource_RR_t timerTick;
} ResourceRR_t;

extern __IO Resource_t resource;
extern __IO ResourceRR_t resourceRR;

// IRQ
void DisableIRQ(void);
void EnableIRQ(void);

// System clock initialization
uint8_t RCC_ClockInit(void);
uint8_t RTC_ClockInit(void);

// DEBUG - USART
void USART_DEBUG_Config(uint32_t bufferAddr);

// Monitoring
void Monitoring_Config(void);

void Timeout_Timer_Config(void);

#endif /* BOARD_H_INCLUDED */
