#ifndef MESSAGE_H_INCLUDED
#define MESSAGE_H_INCLUDED

#include "board.h"

#define LCD_BLACK               0x0000
#define LCD_BLUE                0x001F
#define LCD_LIGHTBLUE           0x39FF
#define LCD_RED                 0xF800
#define LCD_GREEN               0x07E0
#define LCD_CYAN                0x07FF
#define LCD_MAGENTA             0xF81F
#define LCD_YELLOW              0xFFE0
#define LCD_WHITE               0xFFFF
#define LCD_GRAY                0x7BEF
#define LCD_DARKGRAY            0x39E7
#define LCD_LIGHTGRAY           0xC618

#ifdef LCDOUT
void MSG_PrintC(const char *str, uint16_t color);
void MSG_Print(const char *str);
void MSG_PrintLnC(const char *str, uint16_t color);
void MSG_PrintLn(const char *str);
void MSG_Ok(void);
void MSG_Fail(void);
#else
#define MSG_PrintC(str, color) DBG_PrintC(str, color)
#define MSG_Print(str) DBG_Print(str)
#define MSG_PrintLnC(str, color) DBG_PrintLnC(str, color)
#define MSG_PrintLn(str) DBG_PrintLn(str)
#define MSG_Ok() DBG_Ok()
#define MSG_Fail() DBG_Fail()
#endif

#ifdef USARTDEBUG
void DBG_Init(void);
void DBG_PrintC(const char *str, uint16_t color);
void DBG_Print(const char *str);
void DBG_PrintLn(const char *str);
void DBG_PrintLnC(const char *str, uint16_t color);
void DBG_TimeRef(void);
void DBG_PrintChar(char c);
void DBG_BlockPrint(const char *str);
void DBG_Ok(void);
void DBG_Fail(void);
#else
#define DBG_Init()                ((void) 0)
#define DBG_PrintC(str, color)    ((void) 0)
#define DBG_PrintLnC(str, color)  ((void) 0)
#define DBG_Print(str)            ((void) 0)
#define DBG_PrintLn(str)          ((void) 0)
#define DBG_TimeRef()             ((void) 0)
#define DBG_BlockPrint(str)       ((void) 0)
#define DBG_Ok()                  ((void) 0)
#define DBG_Fail()                ((void) 0)
#endif

#ifdef MONITOR
void Monitoring_Init(void);
#else
#define Monitoring_Init()         ((void) 0)
#endif

#endif /* MESSAGE_H_INCLUDED */
