#include "board.h"
#include "nvic.h"

// IRQ lock
__IO uint16_t irqLock;
__IO Resource_t resource;
__IO ResourceRR_t resourceRR;

/*inline void DisableIRQ(void)
{
  if (!irqLock++) {
      __disable_irq();
  }
}

inline void EnableIRQ(void)
{
  if (!--irqLock) {
      __enable_irq();
  }
}*/

// System clock

uint8_t RCC_ClockInit(void)
{
  //GPIO_InitTypeDef GPIO_InitStructure;

  RCC_DeInit();
  NVIC_PriorityGroupConfig(NVIC_PriorityGroup_4);
  RCC_SYSCLKConfig(RCC_SYSCLKSource_HSI);

  /*RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
  //Output clock on MCO pin - Debug clock
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(GPIOA, &GPIO_InitStructure);
  //  RCC_MCOConfig(RCC_MCO_HSE); // Put on MCO pin the: freq. of external crystal
  //  RCC_MCOConfig(RCC_MCO_SYSCLK);  // Put on MCO pin the: System clock selected
  RCC_MCOConfig(RCC_MCO_PLLCLK_Div2);*/

  // Enable HSE
  RCC_HSEConfig(RCC_HSE_ON);
  ErrorStatus HSEStartUpStatus = RCC_WaitForHSEStartUp();
  if (HSEStartUpStatus == SUCCESS) {
    // Enable Prefetch Buffer
    FLASH_PrefetchBufferCmd(FLASH_PrefetchBuffer_Enable);
    // Flash 2 wait state, 0MHz - 24MHz => 0; 24+MHz - 48MHz => 1; 48+MHz - 72MHz => 2
    FLASH_SetLatency(FLASH_Latency_2);
    // HCLK = SYSCLK, AHB prescaler
    RCC_HCLKConfig(RCC_SYSCLK_Div1);
    // PCLK2 = HCLK, APB2 prescaler
    RCC_PCLK2Config(RCC_HCLK_Div1);
    // PCLK1 = HCLK / 2, APB1 prescaler
    RCC_PCLK1Config(RCC_HCLK_Div2);
    // ADCCLK = PCLK2/6 = (72MHz/6) = 12MHz
    RCC_ADCCLKConfig(RCC_PCLK2_Div6);
    // PLLCLK = (12MHz/1) * 6 = 72 MHz
    RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_6);
    // Enable PLL
    RCC_PLLCmd(ENABLE);
    // Wait till PLL is ready
    while (RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET) {
    }
    // Select PLL as system clock source
    RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);
    // Wait till PLL is used as system clock source
    while (RCC_GetSYSCLKSource() != 0x08) {
    }
  } else {
    SystemCoreClockUpdate();
    return CLOCK_FLT_HSE_ENABLE;
  }
  SystemCoreClockUpdate();
  return CLOCK_NO_FLT;
}

uint8_t RTC_ClockInit(void)
{
  //uint32_t counter = 0;

  // Enable PWR and BKP clocks
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_PWR | RCC_APB1Periph_BKP, ENABLE);
  // Allow access to BKP Domain
  PWR_BackupAccessCmd(ENABLE);
  // Reset Backup Domain
  BKP_DeInit();
  // Enable LSE
  //RCC_LSEConfig(RCC_LSE_ON);
  // Wait till LSE ready
  /*while(RCC_GetFlagStatus(RCC_FLAG_LSERDY) == RESET) {
    if (++counter == 0x100000) {
      RCC_LSEConfig(RCC_LSE_OFF);
      RCC_LSEConfig(RCC_LSE_ON);
    }
    if (counter > 0xF00000) return CLOCK_FLT_LSE_ON;
  }*/

  // Select HSE as RTC clock source
  RCC_RTCCLKConfig(RCC_RTCCLKSource_HSE_Div128);
  // Enable RTC Clock
  RCC_RTCCLKCmd(ENABLE);
  // Wait for RTC registers synchronization
  RTC_WaitForSynchro();
  // Wait until last write operation on RTC registers has finished
  RTC_WaitForLastTask();
  // Enable the RTC Second
  RTC_ITConfig(RTC_IT_SEC, ENABLE);
  // Wait until last write operation on RTC registers has finished
  RTC_WaitForLastTask();
  // Set RTC prescaler: set RTC period to 1sec
  RTC_SetPrescaler(93749); // RTC period = RTCCLK/RTC_PR = (93.75 KHz)/(93749+1)
  // Wait until last write operation on RTC registers has finished
  RTC_WaitForLastTask();

  return CLOCK_NO_FLT;
}

#ifdef USARTDEBUG
// DEBUG - USART
void USART_DEBUG_Config(uint32_t bufferAddr)
{
  GPIO_InitTypeDef GPIO_InitStruct;
  USART_InitTypeDef USART_InitStruct;
  DMA_InitTypeDef DMA_InitStructure;

  RCC_APB2PeriphClockCmd(USART_DEBUG_GPIO_CLK | RCC_APB2Periph_AFIO, ENABLE);
  RCC_APB2PeriphClockCmd(USART_DEBUG_CLK, ENABLE);

  //USART_ITConfig(USART1,USART_IT_RXNE,ENABLE);


  // PA.09(Tx)
  GPIO_InitStruct.GPIO_Mode = GPIO_Mode_AF_PP;
  GPIO_InitStruct.GPIO_Pin = USART_DEBUG_TxPin;
  GPIO_InitStruct.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(USART_DEBUG_GPIO, &GPIO_InitStruct);

  // PA.10(Rx)
  GPIO_InitStruct.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  GPIO_InitStruct.GPIO_Pin = USART_DEBUG_RxPin;
  GPIO_Init(USART_DEBUG_GPIO, &GPIO_InitStruct);

  // Enable the DMA Clock
  RCC_AHBPeriphClockCmd(USART_DEBUG_DMA_CLK, ENABLE);
  DMA_DeInit(USART_DEBUG_DMA_Channel);
  DMA_InitStructure.DMA_PeripheralBaseAddr = (uint32_t)&USART_DEBUG->DR;//USART_DEBUG_DR_Base;
  DMA_InitStructure.DMA_MemoryBaseAddr = bufferAddr;
  DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralDST;
  DMA_InitStructure.DMA_BufferSize = 0;
  DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
  DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
  DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_Byte;
  DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_Byte;
  DMA_InitStructure.DMA_Mode = DMA_Mode_Normal;
  DMA_InitStructure.DMA_Priority = DMA_Priority_Low;
  DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
  DMA_Init(USART_DEBUG_DMA_Channel, &DMA_InitStructure);
  DMA_ITConfig(USART_DEBUG_DMA_Channel, DMA_IT_TC, ENABLE);
  USART_DEBUG_DMA_NVIC_Configuration();
  USART_InitStruct.USART_BaudRate = USART_DEBUG_BAUDRATE;
  USART_InitStruct.USART_StopBits = USART_StopBits_1;
  USART_InitStruct.USART_WordLength = USART_WordLength_8b;
  USART_InitStruct.USART_Parity = USART_Parity_No;
  USART_InitStruct.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
  USART_InitStruct.USART_Mode = USART_Mode_Tx | USART_Mode_Rx;
  USART_Init(USART_DEBUG, &USART_InitStruct);
  USART_DMACmd(USART_DEBUG, USART_DMAReq_Tx, ENABLE);
  USART_ITConfig(USART_DEBUG,USART_IT_RXNE,ENABLE);
  USART_DEBUG_NVIC_Configuration();
  USART_Cmd(USART_DEBUG, ENABLE);
}
#endif

#ifdef MONITOR
// Monitoring
void Monitoring_Config(void)
{
  GPIO_InitTypeDef GPIO_InitStruct;

  RCC_APB2PeriphClockCmd(MONITORING_GPIO_CLK, ENABLE);

  GPIO_InitStruct.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStruct.GPIO_Pin = MONITORING_1_Pin | MONITORING_2_Pin;
  GPIO_InitStruct.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_Init(MONITORING_GPIO, &GPIO_InitStruct);
}
#endif

// Time tick, 1ms

void Timeout_Timer_Config(void)
{
  TIM_TimeBaseInitTypeDef  TIM_TimeBaseStructure;
  uint16_t prescaler = (uint16_t)(SystemCoreClock / 12000) - 1;

  RCC_APB1PeriphClockCmd(TIMER_TIMEOUT_CLK, ENABLE);

  TIM_TimeBaseStructure.TIM_Period = 12000 - 1; // 1s
  TIM_TimeBaseStructure.TIM_Prescaler = 0;
  TIM_TimeBaseStructure.TIM_ClockDivision = 0;
  TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;

  TIM_TimeBaseInit(TIMER_TIMEOUT, &TIM_TimeBaseStructure);

  TIM_PrescalerConfig(TIMER_TIMEOUT, prescaler, TIM_PSCReloadMode_Immediate);
  TIM_ITConfig(TIMER_TIMEOUT, TIM_IT_Update, ENABLE);

  DBGMCU_Config(TIMER_TIMEOUT_DBGSTOP, ENABLE);
  TIM_Cmd(TIMER_TIMEOUT, ENABLE);
  Timeout_NVIC_Configuration();
}

