#include "ext.h"
#include <string.h>
#include <ctype.h>

void delay_ms(uint16_t ms)
{
    uint16_t i,j;
    for( i = 0; i < ms; i++ )
    {
        for( j = 0; j < 9000; j++ ) __NOP();
    }
}

static char *long_to_string_with_divisor(char *p,
        long num,
        unsigned radix,
        long divisor)
{
    int i;
    char *q;
    long l, ll;

    l = num;
    if (divisor == 0)
    {
        ll = num;
    }
    else
    {
        ll = divisor;
    }

    q = p + 11;
    do
    {
        i = (int)(l % radix);
        i += '0';
        if (i > '9')
            i += 'A' - '0' - 10;
        *--q = i;
        l /= radix;
    }
    while ((ll /= radix) != 0);

    i = (int)(p + 11 - q);
    do
        *p++ = *q++;
    while (--i);
    *p++ = 0;

    return p;
}

char *ltoa(char *p, long num, unsigned radix)
{

    return long_to_string_with_divisor(p, num, radix, 0);
}

/** \brief Left pads string with characters until size reached
 *
 * \param p char* String to be padded
 * \param c char  Padding character
 * \param num int Final number of characters
 * \return char*  Pointer to string
 *
 */
char *strpadleft(char *p, char c, int num)
{
    int len = strlen(p);
    int i;
    char *d = p + len;
    char *t = p + num;

    if (len >= num) return p;

    for (i = 0; i < len + 1; i++)
    {
        *t-- = *d--;
    }

    t = p;
    for (i = len; i < num; i++)
        *t++ = c;

    return p;
}

/** \brief Right pads string with characters until size reached
 *
 * \param p char* String to be padded
 * \param c char  Padding character
 * \param num int Final number of characters
 * \return char*  Pointer to string
 *
 */
char *strpadright(char *p, char c, int num)
{
    int len = strlen(p);
    int i;
    char *t = p + len;

    if (len >= num) return p;

    for (i = len; i < num; i++)
        *t++ = c;
    *t = 0;

    return p;
}

/** \brief Adds leading zeros to string until size reached
 *
 * \param p char* String to be padded
 * \param num int Final number of characters
 * \return char*  Pointer to string
 *
 */
char *strleadingzeros(char *p, int num)
{
    return strpadleft(p, '0', num);
}

char *strpadspaces(char *p, int num)
{
    return strpadright(p, ' ', num);
}

int strncmpi (const char *a, const char *b, int len)
{
    for (; len && toupper(*a) == toupper(*b); --len, ++a, ++b);
    return (toupper(*a) - toupper(*b));
}
