
#include "stm32f10x_conf.h"
#include "board.h"
#include "timer.h"
#include "message.h"

LWTASK(Task1, 128, NORMAL_PRIORITY)
{
  uint32_t cnt1 = 0;

  RESOURCE(&resource.usartDebug,
    DBG_PrintLn("Task 1 started.");
  );
  while(1)
  {
    cnt1++;
    __NOP();
  }
}

LWTASK(Task2, 256, NORMAL_PRIORITY)
{
  uint32_t cnt2 = 0;
  uint32_t num = (uint32_t)arg;
  uint32_t taskaddr;

  RESOURCE(&resource.usartDebug,
    DBG_PrintLn("Task 2 started.");
  );

  while(cnt2 < num)
  {
    cnt2++;
    __NOP();
  }

  char str[20];
  ltoa(str, num, 10);

  RESOURCE(&resource.usartDebug,
    DBG_Print("Task 2 exiting: ");
    DBG_PrintLn(str);
  );

  taskaddr = (uint32_t)Task2((void*)(num + 1));
  ltoa(str, taskaddr, 16);

  RESOURCE(&resource.usartDebug,
    DBG_Print("New task address: 0x");
    DBG_PrintLn(str);
  );

#ifdef STACK_DEBUG
  num = LwOS_GetMaxStackUsage();
  ltoa(str, num, 10);
  RESOURCE(&resource.usartDebug,
    DBG_Print("Task 2 max stack usage: ");
    DBG_PrintLn(str);
  );
#endif

}

LWTASK(Task3, 256, NORMAL_PRIORITY)
{
  uint32_t id = (uint32_t)arg;
  char str[20];

  RESOURCE(&resource.usartDebug,
    DBG_PrintLn("Task 3 started.");
  );

  while (1) {
    uint8_t tick;

    RESOURCE_RR(&resourceRR.timerTick,
      do {
        tick = GetTick();
        LwOS_Yield();
      } while (!tick);

    );
    ltoa(str, id, 10);

    RESOURCE(&resource.usartDebug,
      DBG_Print("Task 3 caught it: ");
      DBG_PrintLn(str);
#ifdef STACK_DEBUG
      uint32_t num = LwOS_GetMaxStackUsage();
      ltoa(str, num, 10);
      DBG_Print("Task 3 max stack usage: ");
      DBG_PrintLn(str);
#endif
    );
  }
}

LWTASK(Task4, 256, NORMAL_PRIORITY)
{
  uint32_t slp = (uint32_t)arg;
  char str[20];

  RESOURCE(&resource.usartDebug,
    DBG_PrintLn("Task 4 started.");
  );

  while(1)
  {
    LwOS_SleepFor(slp);
    ltoa(str, slp, 10);
    RESOURCE(&resource.usartDebug,
      DBG_Print("Task 4 woke up: ");
      DBG_PrintLn(str);
    );
  }
}

LWTASK(Task5, 256, HIGH_PRIORITY)
{
  uint32_t slp = (uint32_t)arg;
  char str[20];

  RESOURCE(&resource.usartDebug,
    DBG_PrintLnC("Task 5 started.", LCD_RED);
  );

  while(1)
  {
    LwOS_SleepFor(slp);
    ltoa(str, slp, 10);
    RESOURCE(&resource.usartDebug,
      DBG_PrintC("Task 5 woke up: ", LCD_RED);
      DBG_PrintLn(str);
    );
  }
}

LWTASK(Task6, 256, HIGH_PRIORITY)
{
  uint32_t cnt2 = 0;
  uint32_t num = (uint32_t)arg;
  uint32_t taskaddr;

  LwOS_SleepFor(5000);

  RESOURCE(&resource.usartDebug,
    DBG_PrintLnC("Task 6 started.", LCD_LIGHTBLUE);
  );

  while(cnt2 < num)
  {
    cnt2++;
    __NOP();
  }

  char str[20];
  ltoa(str, num, 10);

  RESOURCE(&resource.usartDebug,
    DBG_PrintC("Task 6 exiting: ", LCD_LIGHTBLUE);
    DBG_PrintLn(str);
  );

  taskaddr = (uint32_t)Task6((void*)(num + 1));
  ltoa(str, taskaddr, 16);

  RESOURCE(&resource.usartDebug,
    DBG_Print("New task address: 0x");
    DBG_PrintLn(str);
  );

#ifdef STACK_DEBUG
  num = LwOS_GetMaxStackUsage();
  ltoa(str, num, 10);
  RESOURCE(&resource.usartDebug,
    DBG_Print("Task 6 max stack usage: ");
    DBG_PrintLn(str);
  );
#endif

}

LWTASK(TaskList, 512, LOW_PRIORITY)
{
  LwOS_Task_t *t;
  char str[20];

  do {
    LwOS_SleepFor(10000);
    RESOURCE(&resource.usartDebug,
      LwOS_SetExclusiveMode(EXCLUSIVE_MODE_ON);
      DBG_PrintLnC("******************* Task list *******************", LCD_GREEN);
#ifdef TASK_DEBUG
      strcpy(str, "ID");
      strpadspaces(str, 7);
      DBG_Print(str);
      strcpy(str, "Name");
      strpadspaces(str, 12);
      DBG_Print(str);
#endif
      strcpy(str, "Stack");
      strpadspaces(str, 9);
      DBG_Print(str);
#ifdef STACK_DEBUG
      strcpy(str, "Stk used");
      strpadspaces(str, 9);
      DBG_Print(str);
#endif
      strcpy(str, "State");
      strpadspaces(str, 10);
      DBG_Print(str);
      strcpy(str, "Priority");
      strpadspaces(str, 10);
      DBG_PrintLn(str);
      t = LwOS_GetHeadOfTaskList();
      while (t)
      {
#ifdef TASK_DEBUG
        ltoa(str, t->id, 10);
        strpadspaces(str, 7);
        DBG_Print(str);
        strcpy(str, t->name);
        strpadspaces(str, 12);
        DBG_Print(str);
#endif
        ltoa(str, (long)t->sp, 16);
        strleadingzeros(str, 8);
        strpadspaces(str, 9);
        DBG_Print(str);
#ifdef STACK_DEBUG
        ltoa(str, t->maxUsed, 10);
        strpadspaces(str, 9);
        DBG_Print(str);
#endif
        switch (t->state)
        {
          case TASK_BLOCKED: strcpy(str, "Blocked"); break;
          case TASK_READY: strcpy(str, "Ready"); break;
          case TASK_SLEEPING: strcpy(str, "Sleeping"); break;
          case TASK_ENDING: strcpy(str, "Ending"); break;
          case TASK_INACTIVE: strcpy(str, "Inactive"); break;
          case TASK_INVALID: strcpy(str, "Invalid"); break;
          default: strcpy(str, "Unknown"); break;
        }
        strpadspaces(str, 10);
        DBG_Print(str);
        switch (t->priority)
        {
          case LOW_PRIORITY: strcpy(str, "Low"); break;
          case NORMAL_PRIORITY: strcpy(str, "Normal"); break;
          case ELEVATED_PRIORITY: strcpy(str, "Elevated"); break;
          case HIGH_PRIORITY: strcpy(str, "High"); break;
          default: strcpy(str, "Unknown"); break;
        }
        strpadspaces(str, 10);
        DBG_PrintLn(str);
        t = t->next;
      }
      LwOS_SetExclusiveMode(EXCLUSIVE_MODE_OFF);
    );
  } while (1);
}

int main(void)
{
  RCC_ClockInit();
  Timeout_Timer_Config();
  DBG_Init();

  LwOS_Init();
  Task1(NULL);
  Task2((void*)1000000);
  Task2((void*)2500000);
  Task2((void*)3750000);
  Task2((void*)5000000);
  Task2((void*)6500000);
  Task3((void*)1);
  Task3((void*)2);
  Task3((void*)3);
  Task4((void*)1500);
  Task4((void*)5000);
  Task5((void*)10000);
  Task5((void*)20000);
  Task6((void*)6500000);
  TaskList(NULL);
  LwOS_Start();

  while(1)
  {
    uint8_t tick;

    RESOURCE_RR(&resourceRR.timerTick,
      do {
        tick = GetTick();
        LwOS_Yield();
      } while (!tick);
    );

    RESOURCE(&resource.usartDebug,
      DBG_PrintLn("Main task caught it!");
    );

  }
}
