#include "timer.h"

static uint8_t _tick = 0;

// ISR timer every 1ms, function which ticks the timer variables
ISR(TIMER_TIMEOUT_IRQHandler)
{
  TIM_ClearFlag(TIMER_TIMEOUT, TIM_FLAG_Update);
  _tick = 1;
  __DSB();
}

uint8_t GetTick(void)
{
  uint8_t val = _tick;

  _tick = 0;
  return val;
}



