
; Define RC5 address of Remote Control

;RemoteAddr	EQU	0x06
RemoteAddr	EQU	0x00	;URC22B, Cod: 0026

; Definition of Keys and key-codes on my remote control

NUM_0	EQU	0x00	;SEC_CL
NUM_1	EQU	0x01	;REL_ON
NUM_2	EQU	0x02	;REL_OFF
NUM_3	EQU	0x03
NUM_4	EQU	0x04
NUM_5	EQU	0x05	;WIDTH_DN
NUM_6	EQU	0x06	;WIDTH_UP
NUM_7	EQU	0x07	;PER_DN
NUM_8	EQU	0x08	;PER_UP
NUM_9	EQU	0x09	;TINDEX
NUM_10	EQU	0x0A	
STANDBY	EQU	0x0C
MUTE	EQU	0x0D	;ALM_SND
NUM_E	EQU 0x0E	;POWDNCOIL
TEXT	EQU	0x0F	;TextMode
VOL_UP	EQU	0x10	;SEC_UP
VOL_DN	EQU	0x11	;SEC_DN
BRI_UP	EQU	0x12	;DAY_UP
BRI_DN	EQU	0x13	;DAY_DN
SAT_UP	EQU	0x14	;MON_UP
SAT_DN	EQU	0x15	;MON_DN
BAL_RI	EQU	0x1A	;MIN_UP
BAL_LE	EQU	0x1B	;MIN_DN
CON_UP	EQU	0x20	;HOUR_UP
CON_DN	EQU	0x21	;HOUR_DN
HUE_DN	EQU	0x22	;YEAR_DN	
HUE_UP	EQU	0x38	;YEAR_UP
PAUSE	EQU	0x30	;TSecMode
PHA_UP	EQU	0x2A	;INDEX_UP
PHA_DN	EQU	0x2B	;INDEX_DN
SHA_UP	EQU	0x2C	;WDAY_UP	
SHA_DN	EQU	0x2D	;WDAY_DN	
ADJUST	EQU	0x26	;POWUPCOIL
EXIT	EQU	0x24	;TWDay
ADDR	EQU	0x3F	;SET_SP
ENTER	EQU	0x28	;TRotation
FREEZE	EQU	0x29	;TStaticText
F1		EQU	0x34	;BlueLine
F2		EQU	0x32	;DigiTime
F3		EQU	0x35	;DigiDate
F4		EQU	0x36	;AnaTime	
F5		EQU	0x37	;TTicks	
ASTRSK 	EQU	0x0B	;DemoM


BAS_UP	EQU	0x16
BAS_DN	EQU	0x17
TRE_UP	EQU	0x18
TRE_DN	EQU	0x19
HELP	EQU	0x2F
CUR_UP	EQU	0x50
CUR_DN	EQU	0x51
CUR_LE	EQU	0x55
CUR_RI	EQU	0x56


; Definition of Functions on the Propeller clock
;Clear second
SEC_CL		EQU	NUM_0
;Increment second
SEC_UP		EQU	VOL_UP
;Decrement second
SEC_DN		EQU	VOL_DN
;Increment minute
MIN_UP		EQU	BAL_RI
;Decrement minute
MIN_DN		EQU	BAL_LE
;Increment hour
HOUR_UP		EQU	CON_UP
;Decrement hour
HOUR_DN		EQU	CON_DN
;Increment day
DAY_UP		EQU	BRI_UP
;Decrement day
DAY_DN		EQU	BRI_DN
;Increment day of week
WDAY_UP		EQU	SHA_UP
;Decrement day of week
WDAY_DN		EQU	SHA_DN
;Increment month
MON_UP		EQU	SAT_UP
;Decrement month
MON_DN		EQU	SAT_DN
;Increment year
YEAR_UP		EQU	HUE_UP
;Decrement year
YEAR_DN		EQU	HUE_DN
;Increment display offset
INDEX_UP	EQU	PHA_UP
;Decrement display offset
INDEX_DN	EQU	PHA_DN

;Toggle outer led
BlueLine	EQU	F1
;Toggle digital time display
DigiTime	EQU	F2
;Toggle digital date display
DigiDate	EQU	F3
;Toggle analogue colck's hands
AnaTime		EQU	F4
;Toggle analogue colck's ticks
TTicks		EQU	F5
;Toggle dot/arc second hand mode
TSecMode	EQU PAUSE

;Toggel demo mode
; on 16F628(A)	  - Scrolling text1 - time - Scrolling text1 - time -
; on 16F684A 	  - Scrolling text1 - time - Scrolling text2 - time -
DemoM		EQU	ASTRSK	;Demo Mode
;Toggle scrolling text mode
TextMode	EQU	TEXT
;Toggle rotation speed display
TRotation	EQU ENTER
;Toggle static text mode
TStaticText	EQU FREEZE
;New commands -------------------------------j parancsok
;Toggle day of week and rotation display
TWDay		EQU EXIT
; Set scrolling speed
SET_SP		EQU	ADDR

;===============================================
; Definition of Functions on the Propeller clock's Base
; .10 commands
; Toggle index
TINDEX		EQU	NUM_9
; PWM pulse width up
WIDTH_UP	EQU	NUM_6
; PWM pulse width down
WIDTH_DN	EQU	NUM_5
; PWM period up
PER_UP		EQU	NUM_8
; PWM period down
PER_DN		EQU	NUM_7
; Relais ON
REL_ON		EQU	NUM_1
; Relais OFF
REL_OFF		EQU	NUM_2
; Alarm sound off
ALM_SND		EQU MUTE
; Power up coil
POWUPCOIL	EQU	ADJUST
; Power down coil
POWDNCOIL	EQU	NUM_E
