#ifndef _IR_NEC_H
#define _IR_NEC_H
#include "integer.h"

//konstansok

#define IR_LEADER1_MIN			913		//	562 us*13/8
#define IR_LEADER1_MAX			1334	//	562 us*19/8

#define IR_LEADER2_MIN			421		//	562 us *6/8
#define IR_LEADER2_MAX			702		//	562 us*10/8
	
#define IR_LEADER2_REPAETH_MIN	211		//  562 us *3/8
#define IR_LEADER2_REPEATH_MAX	351		//	562 us *5/8

#define IR_LEADER2_REPAETL_MIN	52		//  562 us *0,75/8
#define IR_LEADER2_REPEATL_MAX	87		//	562 us *1,25/8

#define IR_DATAL_MIN			52		//	562 us *0,75/8
#define IR_DATAL_MAX			87		//	562 us *1,25/8

#define IR_DATA_MIN				107		//	562 us *1,5/8
#define IR_DATA_MAX				315		//	562 us *4,5/8
//	Logical '0' - a 562,5s space followed a 562,5s pulse burst, with a total transmit time of 1,125ms
//	Logical '1' - a 562,5s space followed 1,6875ms burst followed by , with a total transmit time of 2,25ms

#define IR_DATA_1				140		// 562 us *2/8	A magas szint ideje, a "0"-hoz 1 tartozik a az "1"-hez 3

#define IR_OTHER_MIN			50		//	562 us*13/8

//-------------- IR commands 
//  (ir_ctrl.IrCmd[0]=045;ir_ctrl.IrCmd[1]=045
#define IR_ADDRESS1 45
#define IR_STOP		57
#define IR_REW		50			
#define IR_PLAY		49
#define IR_FWD		51
#define IR_SKIP_L	52
#define IR_SKIP_R	53
#define IR_EJECT	54
#define IR_SETUP	86
#define IR_UP		71
#define IR_DOWN		72
#define IR_LEFT		89
#define IR_RIGHT	90
#define IR_ENTER	88
#define IR_DISP		58
#define IR_0		68
#define IR_1		59
#define IR_2		60
#define IR_3		61
#define IR_4		62
#define IR_5		63
#define IR_6		64
#define IR_7		65
#define IR_8		66
#define IR_9		67
#define IR_RETURN	69
#define IR_TITLE	74
#define IR_PROGRAM	87
#define IR_MARKER	97
#define IR_SEARCH	98
#define IR_CLEAR	70
#define IR_REPEAT_  83 
#define IR_AUDIO	79
#define IR_SUBTIT	80
#define IR_ANGLE	76
#define IR_ZOOM		100

//  (ir_ctrl.IrCmd[0]=004;ir_ctrl.IrCmd[1]=251
#define IR_ADDRESS2	 4	
#define IR_PR_PLUS   0
#define IR_PR_MINUS  1
#define IR_VOL_PLUS  2
#define IR_VOL_MINUS 3
#define IR_POWER	 8
#define IR_MUTE		 9
#define IR_AV		11


//  (ir_ctrl.IrCmd[0]=110;ir_ctrl.IrCmd[1]=145
#define IR_ADDRESS3 110
#define IR_REC		9
#define IR_LOCK		63
#define IR_TV_VCR	21



//#define IR_DEBUG

typedef enum 
{		
	IR_IDLE=0,		
	IR_WAIT_LEADER_1,
	IR_WAIT_LEADER_2,
	IR_REPEAT,
	IR_RECEIVE_BITS,
	IR_WAIT_STOP_BIT,
	IR_DATA_OK,
} IR_MODE;


typedef enum 
{		
	NEC=0,		
	SAMSUNG,
} IR_PROTOCOL;


typedef struct
{
	IR_PROTOCOL IrType;
	BYTE IrBitNo;		
	BYTE IrByteNo;		
	BYTE IrData[4];
	BYTE IrCmd[4];
	BOOL IrStop;
} IR_STRUCT;

//Globals

volatile IR_STRUCT ir_ctrl;
volatile IR_MODE ir_mode;


void reset_IR()
{
	for(BYTE i=0;i<4;i++) ir_ctrl.IrData[i]=0;
	ir_ctrl.IrBitNo=0;
	ir_ctrl.IrByteNo=0;
	ir_ctrl.IrStop=FALSE;
	ir_mode=IR_IDLE;
}

#ifdef IR_DEBUG
	volatile WORD i_data[100][2];
	volatile BYTE i_data_db=0;
#endif


#endif
