#include "avr_compiler.h"
#include "xprintf.h"
#include "MCU_osc.h"
#include "adc_driver.h"
#include "mcp3421_driver.h"
#include "TWI_master_driver.h"
#include "TC_driver.h" 
#include "IR_NEC.h"
#include "WS2812X64.h"
#include "WS2812b_fonts.h"
#include "colors.h"
#include "primitives.h"
#include "random.h"
#include "test.h"
#include "DS18B20.h"


#define BAUDRATE	100000
#define TWI_BAUDSETTING TWI_BAUD(F_CPU, BAUDRATE)
TWI_Master_t twiMaster; 
LONG_BYTE u; 
extern GRB color2[9];

//volatile BOOL sleep_ok = FALSE;

extern GRB color[5];
BYTE sor=0;
BYTE scroll_speed;

extern GRB LEDEK[64];
extern BYTE led_buff[MAX_OSZLOP];
extern BYTE led_szin[MAX_OSZLOP];
extern WORD str_x;
extern GRB alap_ledek[MAX_ALAP_LED_NUM];
extern GRB green;
extern GRB red;
extern GRB blue;
extern GRB yellow;
extern GRB orange;
extern GRB lila;
extern GRB black;
extern WORD k;

uint temp;
char subzero;

 
void port_init()
{
	INIT_PORT_ONTART();
	INIT_PORT_WS2812();
	INIT_PORT_DS18B20();
	INIT_PORT_MCP3421();
	INIT_PORT_CHARGE();	
}

void timer_init()
{
	TCC1.PER = 312;	//100Hz-ES TIMER 312,5 lenne a j rtk 32 MHz-nl
	TCC1.CTRLA = TC_CLKSEL_DIV1024_gc;
	TCC1.INTCTRLA = TC_OVFINTLVL_MED_gc;
	PMIC.CTRL |= PMIC_HILVLEN_bm | PMIC_LOLVLEN_bm | PMIC_MEDLVLEN_bm;
}

void ir_timer_init()
{
	PORTC.PIN0CTRL = PORT_ISC_BOTHEDGES_gc;
	EVSYS.CH5MUX = EVSYS_CHMUX_PORTC_PIN0_gc;
	TC0_ConfigInputCapture(&TCE0, TC_EVSEL_CH5_gc);
	TC0_EnableCCChannels(&TCE0, TC0_CCAEN_bm);
	TC_SetPeriod(&TCE0, 0x7FFF);
	TC0_ConfigClockSource(&TCE0, TC_CLKSEL_DIV256_gc);
	TC0_SetCCAIntLevel(&TCE0, TC_CCAINTLVL_HI_gc);
	PMIC.CTRL |= PMIC_HILVLEN_bm;// | PMIC_LOLVLEN_bm | PMIC_MEDLVLEN_bm;
	reset_IR();
}

void adc_init()
{
	ADC_CalibrationValues_Load(&ADCA);
	
	ADCA.CTRLB&= ~(ADC_RESOLUTION_gm | ADC_CONMODE_bm);
	ADCA.CTRLB|= ADC_RESOLUTION_12BIT_gc | 0;
	
	ADCA.REFCTRL &= ~ADC_REFSEL_gm;
	ADCA.REFCTRL |= ADC_REFSEL_INT1V_gc; //Internal VCC / 1.6V */
	
	ADCA.PRESCALER &= ~ADC_PRESCALER_gm;
	ADCA.PRESCALER |=ADC_PRESCALER_DIV512_gc;
	
	ADCA.CH0.CTRL &= ~(ADC_CH_INPUTMODE_gm|ADC_CH_GAINFAC_gm);
	ADCA.CH0.CTRL |= ADC_CH_INPUTMODE_SINGLEENDED_gc | ADC_CH_GAIN_1X_gc;

	ADCA.CH0.MUXCTRL = ADC_CH_MUXPOS_PIN6_gc;	//AKKU
		
	ADC_Enable(&ADCA);
	ADC_Wait_32MHz(&ADCA);

	ADCA.CH0.INTCTRL=ADC_CH_INTMODE_COMPLETE_gc | ADC_CH_INTLVL_MED_gc;
}

void init()
{
	//clock_init_PLL_2(4);
	clock_init_32MHz();
	_delay_ms(100);
	EXT_RTC_init();
	timer_init();
	port_init();
	adc_init();
	ir_timer_init();
	ir_timer_init();
	TWI_MasterInit(&twiMaster,&TWIE,TWI_MASTER_INTLVL_LO_gc,TWI_BAUDSETTING);
	sei();
#ifdef USART_DEBUG
	//usart_init();
#endif
	mcp_3421_reg=READY | ONE_SHOT | SAMPLE18BIT | GAIN8X;
	mcp3421_WriteReg(mcp_3421_reg);
	_delay_ms(100);

	PR_PRPA|=PR_AC_bm;
	PR_PRPB|=PR_DAC_bm;
	PR_PRPC|=PR_TWI_bm|PR_USART1_bm|PR_USART0_bm|PR_HIRES_bm|PR_SPI_bm|PR_TC0_bm;
	PR_PRPD|=PR_TWI_bm|PR_USART1_bm|PR_USART0_bm|PR_HIRES_bm|PR_SPI_bm|PR_TC0_bm|PR_TC1_bm;
	//PR_PRPE|=PR_TC0_bm;
}

void get_akku_i()
{
	if(mcp3421_ReadData(mcp_3421_data))
	{	
		u.byte[3]=0;
		if(mcp_3421_data[0] & 0x2)
		{	
			u.byte[3]=255;
		} 
		u.byte[0]=mcp_3421_data[2];
		u.byte[1]=mcp_3421_data[1];
		u.byte[2]=mcp_3421_data[0];			
			
		akku_meres.akku_i=(u.val<<4)/105;	//18bit GAIN=8x,snt=0,115...(szmolt)
	}
	mcp3421_WriteReg(mcp_3421_reg);
	if(akku_meres.akku_i > 0) akku_meres.akku_cap+=akku_meres.akku_i/10;
	else 
	{
		if(!Timer) akku_meres.akku_cap--; else akku_meres.akku_cap-=30;
	}
	if(akku_meres.akku_cap < 0) akku_meres.akku_cap=0; else	if(akku_meres.akku_cap > AKKU_CAP) akku_meres.akku_cap=AKKU_CAP;
}

void data_megjel(BYTE p,GRB col)
{
	xsprintf(ora_str,"%02d",p);
	str_small(ora_str,0);
	for(BYTE n=0; n< 8;n++)
	{
		for(BYTE i = 0;i < 8;i++)
		{
			if(led_buff[7-n] & (1 << i)) LEDEK[(8*n+i)]=col; else LEDEK[(8*n+i)]=black;
		}
	}
	cli();
	for(BYTE i = 0;i < 64;i++)
	{
		ledek(i);
	}
	sei();
}


void ir_func()
{
	BYTE p;
	BYTE j=0;
	static WORD bat[8] = {3500,3600,3700,3800,3900,4000,4100,5000};

	if(ir_mode == IR_DATA_OK)
	{
		DS18B20_VCC_ON();
		start_meas();
		_delay_ms(200);
		if(ir_ctrl.IrCmd[0] == IR_ADDRESS1)
		{
			WS2812_VCC_ON();
			switch(ir_ctrl.IrCmd[2])
			{
				if((clock_mode == SET_HOUR) || (clock_mode == SET_MIN))
				{
					case IR_UP:
					{
						disp_clear();
						switch(clock_mode)
						{
							case SET_HOUR:
							{
								if(hour < 23) hour++; else hour=0;
								p=hour;	
								data_megjel(p,green);
								break;
							}
							case SET_MIN:
							{
								if(min < 59) min++; else min=0;
								p=min;
								data_megjel(p,yellow);	
								break;
							}	
						}
						break;
					}
					case IR_DOWN:
					{
						disp_clear();
						switch(clock_mode)
						{
							case SET_HOUR:
							{
								if(hour > 0) hour--; else hour=23;
								p=hour;
								data_megjel(p,green);
								break;
							}
							case SET_MIN:
							{
								if(min > 0) min--; else min=59;
								p=min;	
								data_megjel(p,yellow);
								break;
							}
						}
						break;
					}
					case IR_ENTER:
					{
						if(clock_mode != NORMAL)
						{
							sec=0;
							clock_mode = NORMAL;
						}	
						for(BYTE i=0;i < 17;i++) 
							setpixel_test(7);
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
				} else 
				{
					case IR_PLAY:
					{
						//while(akku_meres.akku_u >  bat[j]) {j++;}
						WORD n=akku_meres.akku_cap/3600;
						j=n/200;
						switch(clock_mode)
						{
						 	case NORMAL:
							{
								if(IS_CHARGE())	xsprintf(ora_str,"%02d:%02d %c ",hour,min,153);
									else xsprintf(ora_str,"%02d:%02d %c ",hour,min,145+j);
								str_save(ora_str);
								for(BYTE i=0; i < str_x;i++)
								{ 
									if(i < 12) led_szin[i]=7; else
									if(i < 18) led_szin[i]=6; else
									if(i < 30) led_szin[i]=2; else	led_szin[i]=j;
								}
								scroll_speed=8;
								break;
							}
							case NORMAL_SMALL:
							{	
								xsprintf(ora_str,"%02d:%02d:%02d ",hour,min,sec);
								str_small(ora_str,2);
								for(BYTE i=0; i < str_x;i++)
								{ 
									if(i < 8) led_szin[i]=7; else
									if(i < 12) led_szin[i]=6; else
									if(i < 20) led_szin[i]=2; else
									if(i < 24) led_szin[i]=6; else
									if(i < 32) led_szin[i]=0; else led_szin[i]=8;
								}
								scroll_speed=10;
								break;
							}
						}
						k=1;
						do
						{
							scroll(scroll_speed);
						} while(k);
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}	
					case IR_DISP:
					{
						if(clock_mode == NORMAL) clock_mode=NORMAL_SMALL; else clock_mode=NORMAL;
						for(BYTE i=0;i < 17;i++) 
							setpixel_test(7);
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
					case IR_0:
					{
						for(BYTE i=0;i < 7;i++) 
							tests();
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
					case IR_1:
					{
						for(BYTE i=0;i < 157;i++) 
							setpixel_test(7);
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
					case IR_2:
					{
						color_test();
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
					case IR_3:
					{
						for(BYTE i=0;i < 17;i++) 
							circle_test(13);
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
					case IR_4:
					{
						for(BYTE i=0;i < 170;i++) 
							rand_vu();					
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
					case IR_5:
					{
						for(BYTE i=0;i < 23;i++) 
							rect_test(11);
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
					case IR_6:
					{
						WORD n=akku_meres.akku_cap/3600;
						xsprintf(ora_str,"%3dmA,%4dmV,%4dmAh ",akku_meres.akku_i/10,akku_meres.akku_u,n);
						//while(akku_meres.akku_u >  bat[j]) {j++;}
						j=n/200;		//200mAh lpsekben lehet 7 lpcsben bemutatni a tltttsget
						str_save(ora_str);
						for(BYTE i=0; i < str_x; i++)
						{
							led_szin[i]=j;	
						}
						k=1;
						do
						{
							scroll_color(8,color2[j]);
						} while(k);
						disp_clear();
						WS2812_VCC_OFF();
						break;
					}
					case IR_7:
					{
						if(!temp_error)
						{
							if (temp & 0x8000)  
							{
								subzero='-';      // mark negative
								temp ^= 0xffff;  // convert to positive => (twos complement)++
								temp++;
							}	
							else subzero='+';
							xsprintf(ora_str,"%c%2d.%01ldC' ",subzero,(uint8_t)(temp >> 4),(long)625*(temp & 0x000F)/1000);
						} else xsprintf(ora_str,"hiba %03d",temp_error);
						str_save(ora_str);
						for(BYTE i=0; i < str_x;i++)
						{ 
							led_szin[i]=7;
						}
						k=1;
						do
						{
							scroll(8);
						} while(k);
						disp_clear();
						WS2812_VCC_OFF();
						start_meas();
						break;
					}	
				}
				case IR_SETUP:
				{
					disp_clear();
					switch(clock_mode)
					{
					 	case NORMAL:
						case NORMAL_SMALL:
						{	
							clock_mode=SET_HOUR;
							p=hour;	
							data_megjel(p,green);
							break;
						}
						case SET_HOUR:
						{
							clock_mode=SET_MIN;
							p=min;	
							data_megjel(p,yellow);
							break;
						}
						case SET_MIN:
						{
							clock_mode=NORMAL;
							break;
						}
					}
					break;
				}
			}
		}
		if(ir_ctrl.IrCmd[0] == IR_ADDRESS2)
		{
			switch(ir_ctrl.IrCmd[2])
			{
				case IR_VOL_PLUS :
				{
					break;
				}
			}
		}
		if(ir_ctrl.IrCmd[0] == IR_ADDRESS3)
		{
			switch(ir_ctrl.IrCmd[2])
			{
				case IR_REC :	
				{
					break;
				}
			}
		}
		reset_IR();
		Timer=DEF_TIMER;
		temp_error=read_meas(&temp);
		//DS18B20_VCC_OFF();
	}
}

void sleeping_rutin(void)
{
	if(!Timer)
	{
		INIT_INFRA_INT_ON();
		SLEEP.CTRL = (SLEEP.CTRL & ~SLEEP_SMODE_gm) | SLEEP_SMODE_PSAVE_gc;
		SLEEP.CTRL |= SLEEP_SEN_bm;
		sleep();
		if(sec<4) ADC_Ch_Conversion_Start(&ADCA.CH0);
	}
}

int main()
{
	init();
	ONTART_ON();
	WS2812_VCC_ON();
	for(BYTE i=0;i < 17;i++) 
		setpixel_test(7);
	disp_clear();
	WS2812_VCC_OFF();
	DS18B20_VCC_ON();
	start_meas();
	akku_meres.akku_cap=4000000;
	while(1)
	{
		ir_func();
		if(OK)
		{
			OK=FALSE;
			get_akku_i();
			//if(akku_meres.akku_u <= LOW_BATT_CAUTION) 
			
			if(akku_meres.akku_u < LOW_BATT_OFF) 
			{
				if(lb_time) lb_time--; 
				else 
				{
					WS2812_VCC_ON();
					for(BYTE i=0;i < 17;i++) 
						setpixel_test(7);
					disp_clear();
					WS2812_VCC_OFF();
					ONTART_OFF();
				}
			}
		}
		sleeping_rutin();
	}
}

ISR(TCC1_OVF_vect)	//100Hz-es 
{
	WORD n;
	
	timer0_szam++;
	if(!(timer0_szam%24)) 
	{
		ADC_Ch_Conversion_Start(&ADCA.CH0);	// akku_adc 0,24 sec
		timer0_szam=0;
	}

	//------------------ ltalnos softveres timer(ek) ---------------
	n = Timer;
	if (n) Timer = --n;
} 

ISR(ADCA_CH0_vect)		//AKKU_fesz
{	
	static WORD temp;
	static BYTE n;
	temp+=ADCA.CH0.RES;
	n++;
	if(n == 4)
	{
		temp/=4;
		if(temp > adc_offset) temp-=adc_offset; else temp=0;
		akku_adc=temp;
		temp=0;
		n=0;
		akku_meres.akku_u=(akku_adc*1.0625);
	}
}

ISR(RTC_OVF_vect)  	
{
	OK=TRUE;
	if(++sec > 59)
	{	
		sec=0;
		if(++min > 59)
		{
			min=0;
			if(++hour > 23) hour=0;
		} 
	}
}

ISR(TWIE_TWIM_vect)
{
	TWI_MasterInterruptHandler(&twiMaster);
}

ISR(TCE0_CCA_vect)
{
	static WORD temp;
	static WORD time_hi;
	static WORD time_lo;
	BOOL rising_edge;
	WORD IR_Capture;

	TC_Restart(&TCE0);	
	if(ir_ctrl.IrStop) return;
	IR_Capture = TC_GetCaptureA(&TCE0);
	if(IR_Capture & 0x8000)
	{
		rising_edge=TRUE;
		time_lo=(IR_Capture & 0x7FFF);
	} else 
	{
		rising_edge=FALSE;
		time_hi=(IR_Capture & 0x7FFF);
	}
	switch(ir_mode)
	{
		case IR_IDLE:
		{
			if (!rising_edge)		// lefut l
			{
				ir_mode=IR_WAIT_LEADER_1;
			} 
			break;
		}
		case IR_WAIT_LEADER_1 :
		{
			if (rising_edge)		// felfut l
			{
				if((time_lo > IR_LEADER1_MIN) && (time_lo < IR_LEADER1_MAX))
				{
					ir_mode=IR_WAIT_LEADER_2;
					ir_ctrl.IrType=NEC;		//ide lehetne enumerate tipust felvenni NEC=0;
				} else
				if((time_lo > IR_LEADER2_MIN) && (time_lo < IR_LEADER2_MAX))
				{
					ir_ctrl.IrType=SAMSUNG;		//ide lehetne enumerate tipust felvenni SAMSUNG=1;
					ir_mode=IR_WAIT_LEADER_2;
				} 
				else if(time_lo > IR_OTHER_MIN)
				{
					reset_IR();
					ir_ctrl.IrCmd[0]=IR_ADDRESS1;
					ir_ctrl.IrCmd[2]=IR_PLAY;
					ir_mode=IR_DATA_OK;
				}
			}
			break;
		}
		case IR_WAIT_LEADER_2:
		{
			if (!rising_edge)		// lefut l
			{ 
				if((time_hi > IR_LEADER2_MIN) && (time_hi < IR_LEADER2_MAX))
				{
					ir_mode=IR_RECEIVE_BITS;
				} else 
				if((time_hi > IR_LEADER2_REPAETH_MIN) && (time_hi < IR_LEADER2_REPEATH_MAX))
				{
					ir_mode=IR_REPEAT;
				}else reset_IR();
			}
			break;
		}
		case IR_REPEAT:
		{
			if (rising_edge)		// felfut l
			{
				if((time_lo > IR_LEADER2_REPAETL_MIN) && (time_lo < IR_LEADER2_REPEATL_MAX))
				{
					ir_mode=IR_DATA_OK;
					ir_ctrl.IrStop=TRUE;
				}
			}
			break;
		}
		case IR_RECEIVE_BITS:
		{
			if (rising_edge)		// felfut l
			{ 
				temp=time_lo;
				if(!((time_lo > IR_DATAL_MIN) && (time_lo < IR_DATAL_MAX))) reset_IR();

			}
			if (!rising_edge)		// lefut l
			{ 
				temp=temp+time_hi;
				if((temp > IR_DATA_MIN) && (temp < IR_DATA_MAX))
				{
					ir_ctrl.IrData[ir_ctrl.IrByteNo]|=(((time_hi > IR_DATA_1) ? 1 : 0) << ir_ctrl.IrBitNo);
					ir_ctrl.IrBitNo++;
					if(ir_ctrl.IrBitNo == 8) 
					{
						ir_ctrl.IrBitNo=0;
						ir_ctrl.IrByteNo++;
						if(ir_ctrl.IrByteNo == 4)
						{
							if(ir_ctrl.IrType == 0)		//NEC
							{
								ir_mode=IR_DATA_OK;
								ir_ctrl.IrStop=TRUE;	
								for(BYTE i=0;i<4;i++) ir_ctrl.IrCmd[i]=ir_ctrl.IrData[i];		
							} else 	ir_mode=IR_WAIT_STOP_BIT;			//SAMSUNG-nl mg kell egy stop bit is
						}
					}
				}
			} else temp=(IR_Capture & 0x7FFF);	

			break;
		}
		case IR_WAIT_STOP_BIT:
		{
			if (rising_edge)		// felfut l
			{ 
				temp=time_lo;
				if((time_lo > IR_DATAL_MIN) && (time_lo < IR_DATAL_MAX))
				{
					ir_mode=IR_DATA_OK;
					ir_ctrl.IrStop=TRUE;		
					for(BYTE i=0;i<4;i++) ir_ctrl.IrCmd[i]=ir_ctrl.IrData[i];
				} else reset_IR();

			}	
			break;
		}
	}
	
}

ISR(PORTC_INT0_vect)
{	
	INIT_INFRA_INT_OFF();
	Timer=DEF_TIMER;
}
