#include "integer.h" 


#define GAIN1X			0
#define GAIN2X			1
#define GAIN4X			2
#define GAIN8X			3
//                        76543210
#define SAMPLE12BIT		0b00000000
#define SAMPLE14BIT		0b00000100
#define SAMPLE16BIT		0b00001000
#define SAMPLE18BIT		0b00001100
#define CONTINUOS		0b00010000
#define ONE_SHOT		0b00000000
#define READY			0b10000000

#define MCP3421_WRITE	  0b11010000
#define MCP3421_READ	  0b11010001

#define INIT_PORT_MCP3421() 	PORTE.DIRSET = PIN0_bm;PORTE.DIRSET = PIN1_bm

//RDY: Ready Bit
//This bit is the data ready flag. In read mode, this bit indicates if the output register has been updated
//with a latest conversion result. In One-Shot Conversion mode, writing this bit to 1 initiates a new
//conversion.
//Reading RDY bit with the read command:
//1 = Output register has not been updated.
//0 = Output register has been updated with the latest conversion result.
//Writing RDY bit with the write command:
//Continuous Conversion mode: No effect
//One-Shot Conversion mode:
//1 = Initiate a new conversion.
//0 = No effect.

//R/W O/C RDY Operation
//0 0 0 		No effect if all other bits remain
//			the same - operation continues
//			with the previous settings
//0 0 1 Initiate One-Shot Conversion
//0 1 0 Initiate Continuous Conversion
//0 1 1 Initiate Continuous Conversion



BYTE mcp3421_WriteReg(BYTE reg);
BYTE mcp3421_ReadData(BYTE *dat);
