#include <avr/interrupt.h> 
#include "primitives.h"

GRB BLACK = {NULLA,NULLA,NULLA};

void LED1()
{
	PORTA.OUTSET=PIN5_bm;		//4
	asm("NOP");					//5
	PORTA.OUTSET=PIN5_bm;		//6
	asm("NOP");					//7
	PORTA.OUTSET=PIN5_bm;		//8
	asm("NOP");					//9
	PORTA.OUTSET=PIN5_bm;		//10
	asm("NOP");					//11
	PORTA.OUTSET=PIN5_bm;		//12
	asm("NOP");					//13
	PORTA.OUTSET=PIN5_bm;		//14
	asm("NOP");					//15
	PORTA.OUTSET=PIN5_bm;		//16
	asm("NOP");					//17
	PORTA.OUTSET=PIN5_bm;		//18
	asm("NOP");					//19
	PORTA.OUTSET=PIN5_bm;		//20
	asm("NOP");					//21
	PORTA.OUTSET=PIN5_bm;		//22
	asm("NOP");					//23
	PORTA.OUTSET=PIN5_bm;		//24


	PORTA.OUTCLR=PIN5_bm;		//1
	asm("NOP");					//2
	PORTA.OUTCLR=PIN5_bm;		//3
	asm("NOP");					//4
	PORTA.OUTCLR=PIN5_bm;		//5
	asm("NOP");					//6
	PORTA.OUTCLR=PIN5_bm;		//7
	asm("NOP");					//8
	PORTA.OUTCLR=PIN5_bm;		//9
	asm("NOP");					//10
	PORTA.OUTCLR=PIN5_bm;		//11
	asm("NOP");					//12
	PORTA.OUTCLR=PIN5_bm;		//13
	
}
void LED0()
{
	PORTA.OUTSET=PIN5_bm;		//4
	asm("NOP");					//5
	PORTA.OUTSET=PIN5_bm;		//6
	asm("NOP");					//7
	PORTA.OUTSET=PIN5_bm;		//8
	asm("NOP");					//9
	PORTA.OUTSET=PIN5_bm;		//10
	asm("NOP");					//11
	PORTA.OUTSET=PIN5_bm;		//12
	asm("NOP");					//13
		
	
	PORTA.OUTCLR=PIN5_bm;		//1
	asm("NOP");					//2
	PORTA.OUTCLR=PIN5_bm;		//3
	asm("NOP");					//4
	PORTA.OUTCLR=PIN5_bm;		//5
	asm("NOP");					//6
	PORTA.OUTCLR=PIN5_bm;		//7
	asm("NOP");					//8
	PORTA.OUTCLR=PIN5_bm;		//9
	asm("NOP");					//10
	PORTA.OUTCLR=PIN5_bm;		//11
	asm("NOP");					//12
	PORTA.OUTCLR=PIN5_bm;		//13
	asm("NOP");					//14
	PORTA.OUTCLR=PIN5_bm;		//15	
	asm("NOP");					//16
	PORTA.OUTCLR=PIN5_bm;		//17
	asm("NOP");					//18
	PORTA.OUTCLR=PIN5_bm;		//19
	asm("NOP");					//20
	PORTA.OUTCLR=PIN5_bm;		//21
	asm("NOP");					//22
	PORTA.OUTCLR=PIN5_bm;		//23
	asm("NOP");					//24
		
}

void ledek(BYTE led)
{
	BYTE s;
	BYTE mask;

	s=LEDEK[led].g;
	mask=0x80;
	for(BYTE bit=0;bit < 8;bit++)
	{
		if(s & mask) {LED1();}
			else {LED0();}
		mask=mask >> 1;
	}
	s=LEDEK[led].r;
	mask=0x80;
	for(BYTE bit=0;bit < 8;bit++)
	{
		if(s & mask) {LED1();}
			else {LED0();}
		mask=mask >> 1;
	}
	s=LEDEK[led].b;
	mask=0x80;
	for(BYTE bit=0;bit < 8;bit++)
	{
		if(s & mask) {LED1();}
			else {LED0();}
		mask=mask >> 1;
	}	
}

void disp_clear()
{

	for(BYTE i = 0;i < 64;i++)
	{
		LEDEK[i]=BLACK;
	}
	cli();
	for(BYTE j=0; j<64;j++)
	{
		ledek(j);
	}
	sei();
}

void setpixel(int x, int y, GRB color)
{
	if(!((x >= 0) && (x < 8) && (y >= 0) && (y < 8))) return;
	if((WORD)(x*8+y) < 64)
	LEDEK[x*8+y]=color;
}

void plot4points(int cx, int cy, int x, int y, GRB color)
{
  setpixel(((cx + x)), cy + y,color);
  if (x != 0) setpixel(((cx - x)), cy + y,color);  	//11*(cx - x)/10 ez amiatt van, mert a pixel
  if (y != 0) setpixel(((cx + x)), cy - y,color);	//x s y irny mrete eltr dx=96 pont = 20mm =96/20=4,8
  if (x != 0 && y != 0) setpixel(((cx - x)), cy - y,color);	//dy=68 pont = 16 mm  =68/16=4,25; 4,8/4,25=1,1294-> 1,1
}


void plot8points(int cx, int cy, int x, int y, GRB color)
{
  plot4points(cx, cy, x, y,color);
  if (x != y) plot4points(cx, cy, y, x,color);
}


void circle(int cx, int cy, int radius, GRB color)
{
  int error = -radius;
  int x = radius;
  int y = 0;
 
  //cx=(cx*230)>>8;
  while (x >= y)
  {
    plot8points(cx, cy, x, y,color);
 
    error += y;
    ++y;
    error += y;
 
    if (error >= 0)
    {
      --x;
      error -= x;
      error -= x;
    }
  }
}

void hline(BYTE x0,BYTE y0,BYTE x1,GRB color)
{
	BYTE xmin, xmax;
	
	xmin = (x0 <= x1) ? x0 : x1;
	xmax = (x0 > x1) ? x0 : x1;

	BYTE x = xmax-xmin+1;
	while(x--)
	{
		setpixel(xmin+x,y0,color);
	}	
}

void vline(BYTE x0,BYTE y0,BYTE y1,GRB color)
{
	BYTE ymin, ymax;	
	ymin = (y0 <= y1) ? y0 : y1;
	ymax = (y0 > y1) ? y0 : y1;

	BYTE y = ymax-ymin+1;
	while(y--)
	{
		setpixel(x0,ymin+y,color);
	}
}

void line(int x0,int y0,int x1,int y1, GRB color)
{
   	int dx = abs(x1-x0);
   	int dy = abs(y1-y0); 
   	int sx, sy, err, e2;

	
   	if(x0 < x1) sx = 1; else sx = -1;
   	if(y0 < y1) sy = 1; else sy = -1;
   	err = dx-dy;
 	while(1)
   	{
    	setpixel(x0,y0,color);
     	if((x0 == x1) && (y0 == y1)) return;
     	e2 = 2*err;
     	if(e2 > -dy)
	 	{
       		err = err - dy;
       		x0  = x0 + sx;
     	}
     	if(e2 < dx)
	 	{
       		err = err + dx;
       		y0 = y0 + sy;
	 	}
   } 
}

void rectangle(int x0,int y0,int x1,int y1,GRB color,BOOL fill)
{
	int xmin, xmax, ymin, ymax, x;	
	xmin = (x0 <= x1) ? x0 : x1;
	xmax = (x0 > x1) ? x0 : x1;
	ymin = (y0 <= y1) ? y0 : y1;
	ymax = (y0 > y1) ? y0 : y1;
		
	hline(xmin,ymin,xmax,color);
	vline(xmin,ymin,ymax,color);
	vline(xmax,ymin,ymax,color);
	hline(xmin,ymax,xmax,color);
	if(fill)
	{
		for(x=xmin+1;x<xmax;x++)
			vline(x,ymin,ymax,color);
	}
}
