#include "test.h"
#include "primitives.h"
#include "xprintf.h"
#include "random.h"
#include <avr/interrupt.h> 
#include <util/delay.h> 
#include "WS2812b_fonts.h"

extern char ora_str[32];
extern GRB LEDEK[64];
extern WORD k;
extern GRB alap_ledek[MAX_ALAP_LED_NUM];
extern volatile BYTE hour;
extern volatile BYTE min;
extern volatile BYTE sec;
extern volatile BOOL OK;
extern void scroll(BYTE speed);
extern GRB color[5];

extern GRB green;
extern GRB red;
extern GRB blue;
extern GRB yellow;
extern GRB orange;
extern GRB lila;
extern BYTE sor;

WORD r,x,y;
BYTE max_A[8]={0,0,0,0,0,0,0,0};
BYTE szam_A[8]={0,0,0,0,0,0,0,0};
BOOL light[8]={0,0,0,0,0,0,0,0};
BYTE o=0;

extern void str_save(const char * message);
extern void str_small(const char * message,BYTE sor);
extern WORD str_x;
extern BYTE led_szin[MAX_OSZLOP];

TEST_MODE test_mode=TIME_STR;

void rand_vu()
{
	BYTE n[8] = {0,2,3,4,5,12,19,16};
	for(BYTE j=0; j < 8;j++)
	{
		szam_A[j]++;
		r=(rand_16()/19)%8;
		if(max_A[j] < r) {max_A[j] = r;szam_A[j]=0;}
		if(szam_A[j] > 6) {szam_A[j]--;if(max_A[j]) max_A[j]--;}
		light[j]=TRUE;
		for(BYTE i = 0;i < 8;i++)
		{
			if(i >= r) light[j]=FALSE;
			if(light[j]) 
			{
				LEDEK[i+8*j]=alap_ledek[n[j]];
			}
			else LEDEK[i+8*j]=color[4];
			LEDEK[max_A[j]+8*j]=red;
		}
	}
	cli();
	for(BYTE j=63; j>0;j--)
		ledek(j);
	sei();
	_delay_ms(80);
}

void setpixel_test(BYTE db)
{
	for(BYTE i = 0;i < 64;i++)
	{
		LEDEK[i]=color[4];
	}
	for(BYTE i=0;i < db;i++)
	{
		x=(rand_16()/41)%8;
		y=(rand_16()/13)%8;
		r=rand_16()%MAX_ALAP_LED_NUM;
		setpixel(x,y,alap_ledek[r]);
	}
	cli();
	for(BYTE j=0; j<64;j++)
	{
		ledek(j);
	}
	sei();
	_delay_ms(20);
}

void circle_test(BYTE db)
{
	BYTE s;
	for(BYTE i = 0;i < 64;i++)
	{
		LEDEK[i]=color[4];
	}
	for(BYTE i=0;i < db;i++)
	{
		x=(rand_16()/7)%8;
		y=(rand_16()/13)%8;
		r=(rand_16()/17)%3;
		s=rand_16()%MAX_ALAP_LED_NUM;
		circle(x,y,r,alap_ledek[s]);
	}
	cli();
	for(BYTE j=0; j<64;j++)
	{
		ledek(j);
	}
	sei();
	_delay_ms(500);
}

void rect_test(BYTE db)
{
	WORD x1,y1;
	for(BYTE i = 0;i < 64;i++)
	{
		LEDEK[i]=color[4];
	}
	for(BYTE i=0;i < db;i++)
	{
		x=(rand_16()/7)%5;
		y=(rand_16()/11)%5;
		x1=(rand_16()/13)%5;
		y1=(rand_16()/19)%5;
		r=rand_16()%MAX_ALAP_LED_NUM;
		rectangle(x,y,x+x1,y+y1,alap_ledek[r],(x1&1 ? TRUE : FALSE));
	}
	cli();
	for(BYTE j=0; j<64;j++)
	{
		ledek(j);
	}
	sei();
	_delay_ms(500);
}


void color_test()
{
	for(BYTE i=0; i<MAX_ALAP_LED_NUM-1; i++)
	{
		LEDEK[i*3]=alap_ledek[i];
		LEDEK[i*3+1]=alap_ledek[i];
		LEDEK[i*3+2]=alap_ledek[i];
	}
	cli();
	for(BYTE j=0; j<64;j++)
	{
		ledek(j);
	}
	sei();
	_delay_ms(3000);
}

void tests()
{
	switch(test_mode)
	{
		case TIME_STR:
		{
			xsprintf(ora_str,"%02d:%02d:%02d ra prba ",hour,min,sec);
			str_save(ora_str);
			for(BYTE i=0; i < str_x;i++)
			{
				if(i < 12) led_szin[i]=7; else
				if(i < 18) led_szin[i]=6; else
				if(i < 30) led_szin[i]=2; else	
				if(i < 36) led_szin[i]=6; else	
				if(i < 48) led_szin[i]=3; else	
				if(i < 60) led_szin[i]=0; else	
				if(i < 66) led_szin[i]=1; else	
				if(i < 72) led_szin[i]=2; else	
				if(i < 78) led_szin[i]=3; else	
				if(i < 84) led_szin[i]=4; else	
				if(i < 90) led_szin[i]=5; else	
				if(i < 96) led_szin[i]=6; else	
				if(i < 102) led_szin[i]=7; else	
				led_szin[i]=5;
			}	
			k=1;
			do
			{
				scroll(8);
			} while(!(OK && (k==0)));
			test_mode++;
			break;
		}
		case SET_PIXEL:
		{
			for(BYTE i=0;i < 157;i++) 
				setpixel_test(7);
			test_mode++;
			disp_clear();
			break;
		}
		case TIME_SMALL_STR:
		{
			xsprintf(ora_str,"%02d:%02d:%02d  ",hour,min,sec);
			str_small(ora_str,sor);
			for(BYTE i=0; i < str_x;i++)
			{ 
				if(i < 8) led_szin[i]=7; else
				if(i < 12) led_szin[i]=6; else
				if(i < 20) led_szin[i]=2; else
				if(i < 24) led_szin[i]=6; else
				if(i < 32) led_szin[i]=0; else led_szin[i]=8;
			}
			sor++;
			sor=sor%4;
			k=1;
			do
			{
				scroll(10);
			} while(!(OK && (k==0)));
			test_mode++;
			break;
		}
		case COLOR_TEST:
		{
			color_test();
			test_mode++;
			break;
		}
		case SET_CIRCLE:
		{
			for(BYTE i=0;i < 17;i++) 
				circle_test(13);
			test_mode++;
			break;
		}
		case SET_VU:
		{
			for(BYTE i=0;i < 170;i++) 
				rand_vu();					
			test_mode++;
			break;
		}
		case SET_RECT:
		{
			for(BYTE i=0;i < 23;i++) 
				rect_test(11);
			test_mode=TIME_STR;
			disp_clear();
			break;
		}
	}
}

