#include <avr/io.h>
#include "MCU_osc.h" 



void clock_init_PLL_2(BYTE multi)
{
	OSC.CTRL |= OSC_RC2MEN_bm;
	while(!(OSC.STATUS & OSC_RC2MRDY_bm));	//ha 32MHz-es a PLL bemen rajele, akkor ezt a rendszer leosztja 4-gyel, teht 8MHz megy be

	OSC.PLLCTRL = OSC_PLLSRC_RC2M_gc | multi ;
	OSC.CTRL |= OSC_PLLEN_bm ;
	while( (OSC.STATUS & OSC_PLLRDY_bm) == 0 ){} 
	CCP = CCP_IOREG_gc;	
	CLK.CTRL = CLK_SCLKSEL_PLL_gc;	
}

void clock_init_32MHz(void)
{
	
	OSC.CTRL |= OSC_RC32MEN_bm;
	
	while(!(OSC.STATUS & OSC_RC32MRDY_bm));
	
	CCP = CCP_IOREG_gc;
	
	CLK.CTRL = (CLK.CTRL & ~CLK_SCLKSEL_gm) | CLK_SCLKSEL_RC32M_gc;
	//freq=32;
}

void EXT_RTC_init()
{
// Enable external 32 kHz XTAL oscillator in low-power mode.
	OSC.XOSCCTRL = OSC_XOSCSEL_32KHz_gc | OSC_X32KLPM_bm;
    OSC.CTRL |= OSC_XOSCEN_bm;
    // Wait for oscillator to stabilize before setting as RTC clock source.
     do { } while (!( OSC.STATUS & OSC_XOSCRDY_bm ));
     CLK.RTCCTRL = CLK_RTCSRC_TOSC_gc | CLK_RTCEN_bm;
	
	RTC.PER = 1023;
	RTC.CNT = 0;
	RTC.COMP = 0;
	RTC.CTRL = (RTC.CTRL & ~RTC_PRESCALER_gm) | RTC_PRESCALER_DIV1_gc;
	RTC.INTCTRL = (RTC.INTCTRL & ~(RTC_COMPINTLVL_gm | RTC_OVFINTLVL_gm)) | RTC_OVFINTLVL_LO_gc | RTC_COMPINTLVL_OFF_gc;
	PMIC.CTRL |= PMIC_LOLVLEN_bm;
}



