#ifndef WS2812X64_H

#define WS2812X64_H

#include <avr/io.h>
#include "integer.h"

#define sleep() __asm__ __volatile__ ("SLEEP")

//-------------- uC VCC ------------------
#define ONTART_PORT				PORTA
#define ONTART_PIN				PIN3_bm
#define INIT_PORT_ONTART()		ONTART_PORT.DIRSET=ONTART_PIN
#define ONTART_ON()				ONTART_PORT.OUTSET=ONTART_PIN
#define ONTART_OFF()			ONTART_PORT.DIRCLR=ONTART_PIN;ONTART_PORT.OUTCLR=ONTART_PIN

//-------------- WS2812_MATRIX ------------------
#define WS2812_VCC_PORT			PORTA
#define WS2812_VCC_PIN			PIN4_bm
#define WS2812_DATA_PORT		PORTA
#define WS2812_DATA_PIN			PIN5_bm
#define INIT_PORT_WS2812()		WS2812_VCC_PORT.DIRSET=WS2812_VCC_PIN;WS2812_DATA_PORT.DIRSET=WS2812_DATA_PIN
#define WS2812_VCC_ON()			WS2812_VCC_PORT.DIRSET=WS2812_VCC_PIN;WS2812_VCC_PORT.OUTSET=WS2812_VCC_PIN
#define WS2812_VCC_OFF()		WS2812_VCC_PORT.DIRCLR=WS2812_VCC_PIN;WS2812_VCC_PORT.OUTCLR=WS2812_VCC_PIN

//-------------- DS18B20 ------------------
#define DS18B20_VCC_PORT		PORTB
#define DS18B20_VCC_PIN			PIN0_bm
#define INIT_PORT_DS18B20()		DS18B20_VCC_PORT.DIRSET=DS18B20_VCC_PIN
#define DS18B20_VCC_ON()		DS18B20_VCC_PORT.DIRSET=DS18B20_VCC_PIN;DS18B20_VCC_PORT.OUTSET=DS18B20_VCC_PIN
#define DS18B20_VCC_OFF()		DS18B20_VCC_PORT.DIRCLR=DS18B20_VCC_PIN;ONTART_PORT.OUTCLR=DS18B20_VCC_PIN

#define INIT_INFRA_INT_ON()		PORTC.PIN2CTRL=PORT_ISC_LEVEL_gc;PORTC.INT0MASK=PIN2_bm;PORTC.INTCTRL=PORT_INT0LVL_LO_gc	//Az infra a PC0-on van, de a PC2-re is tktttem, hogy fel tudjon bredmi
#define INIT_INFRA_INT_OFF()	PORTC.PIN2CTRL=0;PORTC.INT0MASK=0;PORTC.INTCTRL=0

//-------------- CHARGE ------------------
#define	CHARGE_PORT			PORTC
#define CHARGE_PIN			PIN1_bm
#define INIT_PORT_CHARGE()	CHARGE_PORT.PIN1CTRL= PORT_OPC_PULLUP_gc
#define IS_CHARGE() 		((CHARGE_PORT.IN & CHARGE_PIN) ? FALSE : TRUE)

volatile BOOL OK=FALSE;
volatile BYTE hour=12;
volatile BYTE min=29;
volatile BYTE sec=00;
volatile BYTE sec_100=00;
volatile WORD year=2016;
volatile BYTE month=11;
volatile BYTE day=1;

#define  DEF_TIMER			500	

BYTE temp_error;

char ora_str[32];


volatile WORD Timer;		// 100Hz decrement timer 
volatile WORD timer0_szam = 0;

BYTE mcp_3421_reg;
BYTE mcp_3421_data[4]; 


//_____________________ AKKU

#define LOW_BATT_CAUTION	3500		//(3,5V) 
#define LOW_BATT_OFF 		3300		//(3,3V) 
#define LOW_BATT_TIME		60			//60 sec-> 1 min 
volatile BYTE lb_time=LOW_BATT_TIME;


#define adc_offset 			135
volatile WORD akku_adc;

typedef struct
{
	WORD akku_u;
	int akku_i;
	LONG akku_cap;
} MERES_DATA;

volatile MERES_DATA akku_meres;

#define AKKU_CAP		5000000		//1388,9 mAh, csak ez mAs-ban van
typedef union LONG_BYTE
{
    LONG val;
    BYTE byte[4];
    struct
    {
		BYTE LB;
		BYTE HB;
		BYTE UB;
		BYTE MB;
    } Byte; 
} LONG_BYTE;

#define USART_DEBUG

#ifdef USART_DEBUG

	//#include "usart_driver.h"


	#define USART 			USARTE0
	#define USARTPORT 		PORTE

	void usart_init()
	{	
		USARTPORT.DIRSET=PIN3_bm;		//USART TX kimenet;
		USARTPORT.DIRCLR=PIN2_bm;		//USART RX bemenet
	
		USART.CTRLC = (uint8_t) USART_CHSIZE_8BIT_gc | USART_PMODE_DISABLED_gc | false;
		USART.CTRLB |= USART_TXEN_bm | USART_RXEN_bm;
		USART.BAUDCTRLA =103;							//FBAUB=FCPU/(16*(BAUDCTRLA+1)) most 19.200
	}

	void kiir(const char* c)
	{
		register uint8_t *p = c;
		while(*p) 
		{
			while((USART.STATUS & USART_DREIF_bm) == 0 ) {}
        	USART.DATA = *p;    
			p++;
		}
	}


#endif


typedef enum 
{
	NORMAL=0,
	NORMAL_SMALL,
	SET_HOUR,
	SET_MIN,
} CLOCK_MODE;
CLOCK_MODE clock_mode = NORMAL;


#endif

