#include <avr/interrupt.h> 
#include <avr/pgmspace.h>
#include <util/delay.h>
#include "integer.h" 
#include "WS2812b_fonts.h"
#include "colors.h"
#include "xprintf.h"

BYTE led_buff[MAX_OSZLOP];
BYTE led_szin[MAX_OSZLOP];
WORD str_x=0;
WORD k=0;
extern GRB color[5];
extern GRB color2[9];
extern GRB LEDEK[64];
extern void ledek(BYTE led);

static const BYTE NormalFont[122][5] PROGMEM  = {
{0x00, 0x00, 0x00, 0x00, 0x00},// (space)
{0x00, 0x00, 0x5F, 0x00, 0x00},// !
{0x00, 0x07, 0x00, 0x07, 0x00},// "
{0x14, 0x7F, 0x14, 0x7F, 0x14},// #
{0x24, 0x2A, 0x7F, 0x2A, 0x12},// $
{0x23, 0x13, 0x08, 0x64, 0x62},// %
{0x36, 0x49, 0x55, 0x22, 0x50},// &
{0x00, 0x05, 0x03, 0x00, 0x00},// '
{0x00, 0x1C, 0x22, 0x41, 0x00},// (
{0x00, 0x41, 0x22, 0x1C, 0x00},// )
{0x08, 0x2A, 0x1C, 0x2A, 0x08},// *
{0x08, 0x08, 0x3E, 0x08, 0x08},// +
{0x00, 0x50, 0x30, 0x00, 0x00},// ,
{0x08, 0x08, 0x08, 0x08, 0x08},// -
{0x00, 0x30, 0x30, 0x00, 0x00},// .
{0x20, 0x10, 0x08, 0x04, 0x02},// /
{0x3E, 0x51, 0x49, 0x45, 0x3E},// 0
{0x00, 0x42, 0x7F, 0x40, 0x00},// 1
{0x42, 0x61, 0x51, 0x49, 0x46},// 2
{0x21, 0x41, 0x45, 0x4B, 0x31},// 3
{0x18, 0x14, 0x12, 0x7F, 0x10},// 4
{0x27, 0x45, 0x45, 0x45, 0x39},// 5
{0x3C, 0x4A, 0x49, 0x49, 0x30},// 6
{0x01, 0x71, 0x09, 0x05, 0x03},// 7
{0x36, 0x49, 0x49, 0x49, 0x36},// 8
{0x06, 0x49, 0x49, 0x29, 0x1E},// 9
{0x00, 0x36, 0x36, 0x00, 0x00},// :
{0x00, 0x56, 0x36, 0x00, 0x00},// ;
{0x00, 0x08, 0x14, 0x22, 0x41},// <
{0x14, 0x14, 0x14, 0x14, 0x14},// =
{0x41, 0x22, 0x14, 0x08, 0x00},// >
{0x02, 0x01, 0x51, 0x09, 0x06},// ?
{0x32, 0x49, 0x79, 0x41, 0x3E},// @
{0x7E, 0x11, 0x11, 0x11, 0x7E},// A
{0x7F, 0x49, 0x49, 0x49, 0x36},// B
{0x3E, 0x41, 0x41, 0x41, 0x22},// C
{0x7F, 0x41, 0x41, 0x22, 0x1C},// D
{0x7F, 0x49, 0x49, 0x49, 0x41},// E
{0x7F, 0x09, 0x09, 0x01, 0x01},// F
{0x3E, 0x41, 0x41, 0x51, 0x32},// G
{0x7F, 0x08, 0x08, 0x08, 0x7F},// H
{0x00, 0x41, 0x7F, 0x41, 0x00},// I
{0x20, 0x40, 0x41, 0x3F, 0x01},// J
{0x7F, 0x08, 0x14, 0x22, 0x41},// K
{0x7F, 0x40, 0x40, 0x40, 0x40},// L
{0x7F, 0x02, 0x04, 0x02, 0x7F},// M
{0x7F, 0x04, 0x08, 0x10, 0x7F},// N
{0x3E, 0x41, 0x41, 0x41, 0x3E},// O
{0x7F, 0x09, 0x09, 0x09, 0x06},// P
{0x3E, 0x41, 0x51, 0x21, 0x5E},// Q
{0x7F, 0x09, 0x19, 0x29, 0x46},// R
{0x46, 0x49, 0x49, 0x49, 0x31},// S
{0x01, 0x01, 0x7F, 0x01, 0x01},// T
{0x3F, 0x40, 0x40, 0x40, 0x3F},// U
{0x1F, 0x20, 0x40, 0x20, 0x1F},// V
{0x7F, 0x20, 0x18, 0x20, 0x7F},// W
{0x63, 0x14, 0x08, 0x14, 0x63},// X
{0x03, 0x04, 0x78, 0x04, 0x03},// Y
{0x61, 0x51, 0x49, 0x45, 0x43},// Z
{0x00, 0x00, 0x7F, 0x41, 0x41},// [
{0x02, 0x04, 0x08, 0x10, 0x20},// "\"
{0x41, 0x41, 0x7F, 0x00, 0x00},// ]
{0x04, 0x02, 0x01, 0x02, 0x04},// ^
{0x40, 0x40, 0x40, 0x40, 0x40},// _
{0x00, 0x01, 0x02, 0x04, 0x00},// `
{0x20, 0x54, 0x54, 0x54, 0x78},// a
{0x7F, 0x48, 0x44, 0x44, 0x38},// b
{0x38, 0x44, 0x44, 0x44, 0x20},// c
{0x38, 0x44, 0x44, 0x48, 0x7F},// d
{0x38, 0x54, 0x54, 0x54, 0x18},// e
{0x08, 0x7E, 0x09, 0x01, 0x02},// f
{0x08, 0x14, 0x54, 0x54, 0x3C},// g
{0x7F, 0x08, 0x04, 0x04, 0x78},// h
{0x00, 0x44, 0x7D, 0x40, 0x00},// i
{0x20, 0x40, 0x44, 0x3D, 0x00},// j
{0x00, 0x7F, 0x10, 0x28, 0x44},// k
{0x00, 0x41, 0x7F, 0x40, 0x00},// l
{0x7C, 0x04, 0x18, 0x04, 0x78},// m
{0x7C, 0x08, 0x04, 0x04, 0x78},// n
{0x38, 0x44, 0x44, 0x44, 0x38},// o
{0x7C, 0x14, 0x14, 0x14, 0x08},// p
{0x08, 0x14, 0x14, 0x18, 0x7C},// q
{0x7C, 0x08, 0x04, 0x04, 0x08},// r
{0x48, 0x54, 0x54, 0x54, 0x20},// s
{0x04, 0x3F, 0x44, 0x40, 0x20},// t
{0x3C, 0x40, 0x40, 0x20, 0x7C},// u
{0x1C, 0x20, 0x40, 0x20, 0x1C},// v
{0x3C, 0x40, 0x30, 0x40, 0x3C},// w
{0x44, 0x28, 0x10, 0x28, 0x44},// x
{0x0C, 0x50, 0x50, 0x50, 0x3C},// y
{0x44, 0x64, 0x54, 0x4C, 0x44},// z
{0x00, 0x08, 0x36, 0x41, 0x00},// {
{0x00, 0x00, 0x7F, 0x00, 0x00},// |
{0x00, 0x41, 0x36, 0x08, 0x00},// }
{0x08, 0x08, 0x2A, 0x1C, 0x08},// ->
{0x08, 0x1C, 0x2A, 0x08, 0x08}, // <-
{32,84,86,85,108}, // 
{56,84,86,85,24},	// 
{56,68,70,69,56}, // 
{56,69,68,69,56}, // 
{56,70,69,70,57}, // 
{60,64,66,65,124}, // 
{60,65,64,65,124},	// 
{60,66,65,66,125},	// 
{120,20,18,22,121},	// 
{126,74,75,75,66},	// 
{60,66,70,67,60}, // 
{60,67,66,67,60}, // 
{60,66,67,66,61},	// 
{62,64,66,65,62},	// 
{62,65,64,65,62},	// 
{62,67,64,67,63},	// 

{0,0,0,0,0}, 		// 				0  semmi
{254,1,1,1,254}, 		// akku0		0  char
{254,129,129,129,254}, 	// akku1		1  char
{254,193,193,193,254}, 	// akku2		2  char
{254,225,225,225,254}, 	// akku3		3  char	
{254,241,241,241,254}, 	// akku4		4  char	
{254,249,249,249,254}, 	// akku5		5  char
{254,253,253,253,254}, 	// akku6		6 char
{254,255,255,255,126}, 	// akku7		7 char	
{12,31,124,95,76} // hlzat		8 char

};

static const BYTE SmallFont[12][3] PROGMEM  = {
{31,17,31},	//0
{18,31,16},	//1	
{29,21,23},	//2
{21,21,31},	//3
{7,4,31},	//4
{23,21,29},	//5
{31,21,29},	//6
{1,1,31},	//7	
{31,21,31},	//8
{23,21,31},	//9
{0,10,10},	//:
{0,0,0}
};


char ekezetes_fv(char c)
{
	if(c > 128)
	{
		if(c == '') c = 96+32; else
		if(c == '') c = 97+32; else
		if(c == '') c = 98+32; else
		if(c == '') c = 99+32; else
		if(c == '') c = 100+32; else
		if(c == '') c = 101+32; else
		if(c == '') c = 102+32; else
		if(c == '') c = 103+32; else
		if(c == '') c = 104+32; else
		if(c == '') c = 105+32; else
		if(c == '') c = 106+32; else
		if(c == '') c = 107+32; else
		if(c == '') c = 108+32; else
		if(c == '') c = 109+32; else
		if(c == '') c = 110+32; else
		if(c == '') c = 111+32;
	}
	return c;
}

void str_save(const char * message)
{
	char c;

	for (BYTE i = 0; i < MAX_OSZLOP; i++ ) led_buff[i]=0;
	str_x=0;
	while (*message)
	{     
		c=ekezetes_fv(*message++); 
		for (BYTE i = 0; i < 5; i++ )
		{
			led_buff[str_x]=(pgm_read_byte(&NormalFont[c-32][i]));
			str_x++;
		}
		str_x++;
	}
}

void str_small(const char * message,BYTE sor)
{
	char c;
	
	for (BYTE i = 0; i < MAX_OSZLOP; i++ ) led_buff[i]=0;
	str_x=1;
	led_buff[str_x]=0;
	while (*message)
	{     
		c=ekezetes_fv(*message++); 
		for (BYTE i = 0; i < 3; i++ )
		{
			if(c < 48) c=59;
			led_buff[str_x]=(1 << (3-sor))*(pgm_read_byte(&SmallFont[c-48][i]));
			str_x++;
		}
		str_x++;
	}
}

void scroll(BYTE speed)
{
	static WORD n=0;

	if(k >= n)
	{
		for(BYTE i = 0;i < 8;i++)
		{
			if(led_buff[k-n] & (1 << i)) LEDEK[8*n+i]=color2[led_szin[k-n]]; else LEDEK[8*n+i]=color[4];
		}
	}
	cli();
	for(BYTE i = 0;i < 64;i++)
	{
		ledek(i);
	}
	sei();
	if(++n > 7) 
	{
		n=0;
		if(++k > str_x) k=0;
	}	
	for(BYTE i=0; i < speed;i++)
		_delay_ms(1);
}


void scroll_color(BYTE speed,GRB c)
{
	static WORD n=0;

	if(k >= n)
	{
		for(BYTE i = 0;i < 8;i++)
		{
			if(led_buff[k-n] & (1 << i)) LEDEK[8*n+i]=c; else LEDEK[8*n+i]=color[4];
		}
	}
	cli();
	for(BYTE i = 0;i < 64;i++)
	{
		ledek(i);
	}
	sei();
	if(++n > 7) 
	{
		n=0;
		if(++k > str_x) k=0;
	}	
	for(BYTE i=0; i < speed;i++)
		_delay_ms(1);
}




