
#ifndef ADC_DRIVER_H
#define ADC_DRIVER_H

#include "avr_compiler.h"
#include "integer.h" 


#define COMMON_MODE_CYCLES 16


#define ADC_Enable(_adc) 					((_adc)->CTRLA |= ADC_ENABLE_bm)
#define ADC_Disable(_adc) 					((_adc)->CTRLA = (_adc)->CTRLA & (~ADC_ENABLE_bm))

#define ADC_Ch_Conversion_Start(_adc_ch) ((_adc_ch)->CTRL |= ADC_CH_START_bm)

#define ADC_Conversions_Start(_adc, _channelMask)                         \
	(_adc)->CTRLA |= _channelMask &                                   \
	              (ADC_CH0START_bm | ADC_CH1START_bm |                \
	               ADC_CH2START_bm | ADC_CH3START_bm)

#define ADC_BandgapReference_Enable(_adc) ((_adc)->REFCTRL |= ADC_BANDGAP_bm)

#define ADC_BandgapReference_Disable(_adc) 	((_adc)->REFCTRL &= ~ADC_BANDGAP_bm)
#define ADC_TempReference_Enable(_adc) 		((_adc)->REFCTRL |= ADC_TEMPREF_bm)
#define ADC_TempReference_Disable(_adc) 	((_adc)->REFCTRL = (_adc)->REFCTRL & (~ADC_TEMPREF_bm))

BYTE SP_ReadCalibrationByte( BYTE index );

void ADC_CalibrationValues_Load(ADC_t * adc);

void ADC_Wait_32MHz(ADC_t * adc);

/* Deprecated functions: Compatibility with previous application note version */

#endif

/* Offset addresses for production signature row on GCC */
#ifndef ADCACAL0_offset

#define ADCACAL0_offset 0x20
#define ADCACAL1_offset 0x21
#define ADCBCAL0_offset 0x24
#define ADCBCAL1_offset 0x25

#endif
