	/*
 * AtmegaBoard.cpp
 *
 * Created: 4/8/2013 4:31:13 PM
 *  Author: radhoo
 */ 


#include <avr/io.h>
#include "timeout.h"
#include "HD44780/hd44780.h"

#include <stdlib.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include "readdigipin.h"

HD44780 lcd;
ReadDigiPin pin_motor_1, pin_motor_2, pin_reset;

long counter = 1;
int sens = 1;

/*
	This interrupt handler is triggered each time a rising edge is
	detected on INT0, which on a ATmega8 is PD2
*/
ISR(INT0_vect)
{
	counter+= 1*sens;
	if (counter == 0) {
		lcd.lcd_clrscr();lcd.lcd_cursor_home();
	}		
}

int main(void)
{
	_delay_ms(100);
	
	// define the 6 LCD Data pins: RS, E , D4, D5, D6, D7: these are pins: 4,6,11,12,13,14 on the HD44780
    lcd.lcd_init(&PORTB, PB1, //rs
		&PORTB, PB2, //e
		&PORTD, PD3, //d4
		&PORTD, PD4, //d5
		&PORTD, PD5, //d6
		&PORTD, PD6);//d7
    
	
	/*
	 *  1.CONFIGURE INTERRUPT INT0  to count pulses from Geiger Counter, connected on PIN PD2
	 */
	// Configure INT0 to trigger on rising edge
	MCUCR |= _BV(ISC00) | _BV(ISC01);
	// Configure INT0 to fire interrupts
	GICR |= _BV(INT0);
	sei();

	

	// image demo
	lcd.lcd_clrscr();lcd.lcd_cursor_home();
	lcd.lcd_string("pocketmagic.net  ");
	_delay_ms(1000);
	
	lcd.lcd_clrscr();lcd.lcd_cursor_home();
	
	// define polarity pins
	pin_motor_1.Init(&PIND, PD0);
	pin_motor_2.Init(&PIND, PD1);
	pin_reset.Init(&PINC, PC5);

	while (1) {
		
		// check polarity
		if (pin_motor_1.Get() == 1)
			sens = 1;
		else if (pin_motor_2.Get() == 1)
			sens = -1;
		//check reset
		if (pin_reset.Get() == 1) {
			sens = 1;
			counter = 0;
			lcd.lcd_clrscr();lcd.lcd_cursor_home();
		}			
		
		
		
		// limite
		if (counter >=99999) { counter = 0; lcd.lcd_clrscr();lcd.lcd_cursor_home(); }
		if (counter <=-99999) { counter = 0; lcd.lcd_clrscr();lcd.lcd_cursor_home(); }
		
		
		
		
		
		int d1 = abs((counter /10000) % 10),
			d2 = abs((counter / 1000) % 10),
			d3 = abs((counter /  100) % 10),
			d4 = abs((counter /   10) % 10),
			d5 = abs(counter % 10);
		char semn = '+';
		if (counter < 0)
			semn = '-'; 
		
		// sens rotatie
		lcd.lcd_cursor_home();
		lcd.lcd_string_format("%c%d%d%d%d%d sens:%c   ", semn, 
								d1,d2,d3,d4,d5,semn);
		
		
		
		
		_delay_ms(100);
		
	}		
	
}