/*
 * delay_32h - Időzítő eljárások
 *
 * Utolsó módosítás: 2017.05.09.
 *
 * Author: Tamási András
 *
 */

#ifndef XC_HEADER_TEMPLATE_H
#define	XC_HEADER_TEMPLATE_H

#include <xc.h> // include processor files - each processor file is guarded.
#include <plib.h>


#define GetSystemClock() (40000000UL)   /* Fcy = 40MHz */
#define us_SCALE   (GetSystemClock()/2000000)
#define ms_SCALE   (GetSystemClock()/2000)


#ifdef __cplusplus
extern "C" {
#endif


void delay_us(unsigned long int usDelay )
{
    register unsigned int startCnt = ReadCoreTimer();
    register unsigned int waitCnt = usDelay * us_SCALE;

    while(ReadCoreTimer() - startCnt < waitCnt);
}



void delay_ms (unsigned long int msDelay)
{
    register unsigned int startCntms = ReadCoreTimer();
    register unsigned int waitCntms = msDelay * ms_SCALE;

    while(ReadCoreTimer() - startCntms < waitCntms );
}



unsigned long int millis()
{
    return (ReadCoreTimer() / ms_SCALE);
}


#ifdef __cplusplus
}
#endif


#endif	/* XC_HEADER_TEMPLATE_H */
