#ifndef _SOROS_
#define _SOROS_

#include <stdint.h>
char msgBuf[80]; // general purpose string buffer
uint8_t k,adat,vansoros=0;
extern uint16_t _ch1filt, _ch2filt, _ch3filt, _ch4filt, _ch5filt, _ch6filt;
uint8_t fogadUART[100],readRX=0,rxchar,hol=0;

void delay_ms(uint32_t t);
void showMenu(void);
void processMenuCmd(char cmd);
void SetupUSART(void);
void USART_PutChar(char c);
void USART_PutStr(char *str);
void USART_PutHexByte(unsigned char byte);
void USART_PutHexWord(uint16_t word);
int USART_GetStr(char *buf, int len);
void USART_PutMsgAndVal(char *msg, uint16_t val, char addNL);
void send_string(char *str);

void Sorostask()
{
	hol = 0;
	USART_ClearFlag(USART1,USART_FLAG_TC);
	USART_ITConfig(USART1, USART_IT_TXE, DISABLE);
	if ((readRX == 1))
	     {
	             if (fogadUART[0] == '#' && fogadUART[1] == '?')
	             {
	                if (fogadUART[2] == 'v')                       // hexba: 23 3F 76 0A
	                {
	                			send_string("20171110-xxxx\n\r");
	                }

	                if (fogadUART[2] == 't')                       // hexba: 23 3F 74 0A
	                {
	                	 USART_PutChar(0x33);
	                	 USART_PutChar(0x55);
	                	 USART_PutChar(0xAA);

	                	 USART_PutChar(17+33);
	                	 USART_PutChar(11+33);
	                	 USART_PutChar(11+33);
	                	 USART_PutChar(11+33);
	                	 USART_PutChar(11+33);
	                	 USART_PutChar(11+33);
	                	 USART_PutChar(0x0A);

	                  }

	                for(uint8_t i=0;i<100;i++) fogadUART[i] = 0;
	                readRX = 0;
	             }
	     }

}

// ***********************************************************************
//  SetupUSART()
//
// USART1 configured as follow:
// BaudRate = 19200 baud, Word Length = 8 Bits, One Stop Bit, No parity
// Hardware flow control disabled (RTS and CTS signals)
// Receive and transmit enabled
// USART Clock disabled
// USART CPOL: Clock is active low
// USART CPHA: Data is captured on the middle
// USART LastBit: The clock pulse of the last data bit is not output to
//                           the SCLK pin
// ***********************************************************************
void SetupUSART()
{
 GPIO_InitTypeDef  GPIO_InitStructure;
 USART_InitTypeDef USART_InitStructure;
 NVIC_InitTypeDef NVIC_InitStructure;

 // Enable USART1 and GPIOA clock
 RCC_APB2PeriphClockCmd (RCC_APB2Periph_USART1 | RCC_APB2Periph_GPIOA, ENABLE);

 // Configure USART1 Rx (PA10) as input floating
 GPIO_InitStructure.GPIO_Pin   = GPIO_Pin_10;
 GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_IN_FLOATING;
 GPIO_Init(GPIOA, &GPIO_InitStructure);

 // Configure USART1 Tx (PA9) as alternate function push-pull            */
 GPIO_InitStructure.GPIO_Pin   = GPIO_Pin_9;
 GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
 GPIO_InitStructure.GPIO_Mode  = GPIO_Mode_AF_PP;
 GPIO_Init(GPIOA, &GPIO_InitStructure);

 USART_InitStructure.USART_BaudRate            = 19200;
 USART_InitStructure.USART_WordLength          = USART_WordLength_8b;
 USART_InitStructure.USART_StopBits            = USART_StopBits_1;
 USART_InitStructure.USART_Parity              = USART_Parity_No ;
 USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
 USART_InitStructure.USART_Mode                = USART_Mode_Rx | USART_Mode_Tx;
 USART_Init(USART1, &USART_InitStructure);

 USART_ITConfig(USART3,USART_IT_TXE, DISABLE);
  // Enable the USART RX Interrupt
  USART_ITConfig(USART1, USART_IT_RXNE, ENABLE);

 USART_Cmd(USART1, ENABLE);


 NVIC_InitStructure.NVIC_IRQChannel = USART1_IRQn;
 NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
 NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
 NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
 NVIC_Init(&NVIC_InitStructure);
}

// ***********************************************************************
// ******** USART Utility functions **************************************
// ***********************************************************************
// ***********************************************************************
// USART_PutChar(char *c)
// ***********************************************************************
void USART_PutChar(char c)
{
  // write a character to the USART
	//while (!(USART1->ISR & USART_ISR_TXE));

	USART_SendData(USART1, (uint8_t) c);

  ///Loop until the end of transmission
  //while(USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET);
	while(USART_GetFlagStatus(USART1, USART_FLAG_TXE) == RESET);
  USART_ClearFlag(USART1,USART_FLAG_TC);

}

// ***********************************************************************
// USART_PutStr(char *str)
// ***********************************************************************
void USART_PutStr(char *str)
{
  while(*str)
  {
    USART_PutChar(*str);
	str++;
  }
}

void send_string(char *str)
{
    uint8_t i = 0,mit;
    while(str[i] != 0x0D) {
        mit = str[i];
        USART_PutChar(mit);
        i++;
    }
}

// ***********************************************************************
// USART_PutHexByte(char byte)
// ***********************************************************************
void USART_PutHexByte(unsigned char byte)
{
  char n = (byte >> 4) & 0x0F;
  // Write high order digit
  if(n < 10)
 	USART_PutChar(n + '0');
  else
	USART_PutChar(n - 10 + 'A');

  // Write low order digit
  n = (byte & 0x0F);
  if(n < 10)
 	USART_PutChar(n + '0');
  else
	USART_PutChar(n - 10 + 'A');
}

// ***********************************************************************
// USART_PutHexWord(word)
// ***********************************************************************
void USART_PutHexWord(uint16_t word)
{
 uint8_t byte;
 byte = (word >> 8)& 0x00FF;
 USART_PutHexByte(byte);
 byte = word & 0x00FF;
 USART_PutHexByte(byte);
}


// ***********************************************************************
//	USART_GetStr(char *buf, int len)
//  Return length of input string
// ***********************************************************************
int USART_GetStr(char *buf, int len)
{
 int i=0;
 char k = 0;

 while(k != 0x0D)
    {
	  // Is a byte available from UART?
	 if(USART_GetFlagStatus(USART1, USART_FLAG_RXNE) == SET)
	   {
		k = USART_ReceiveData(USART1);  // get input char
		USART_PutChar(k);               // echo input char
		buf[i]=k;                       // store input char

		if((k=='\r')||(k=='\n')||(k==0x1B)) // CR,LF or Esc = EXIT
			break;

		if((k==0x7F)&&(i>1))  // Backspace (maybe specific to PuTTY)
		  {
			i--;
			continue;
		  }

		if(++i==len)  // Buffer Full = EXIT
	      break;
	   }
    }

  buf[i]=0;
  return i;
}

// ***********************************************************************
// USART_PutMsgAndVal(char *msg, int val, uint8_t addNL)
// output a string followed by a HEX value.
// NOTE: useful for error message and error code
// ***********************************************************************
void USART_PutMsgAndVal(char *msg, uint16_t val, char addNL)
{
  USART_PutStr("\r\n");
  USART_PutStr(msg);
  if(val <256)
	USART_PutHexWord((uint8_t)val);
  else
	USART_PutHexWord((uint16_t)val);

  if(addNL)
    USART_PutStr("\r\n");
}

//USART1 Interrupt Handler
void USART1_IRQHandler(void)
{
      if(USART_GetITStatus(USART1, USART_IT_RXNE) != RESET)//enter interrupt when STM32 receice data.
      {
         rxchar = fogadUART[hol] = USART_ReceiveData(USART1); //receive a char
         if (hol < 100) hol++;
         if (rxchar == 0x0A) {
             readRX = 1;
             hol = 0;
         }
         USART_ClearITPendingBit(USART1, USART_IT_RXNE);
      }
}

#endif
