#ifndef _DIGITAL_
#define _DIGITAL_

#define LED_PORT GPIOB                         // ?gy minden kimenetet felvenni...
#define GOMB_PORT GPIOC
#define LED_PORT_CLOCK RCC_APB2Periph_GPIOB
#define GOMB_PORT_CLOCK RCC_APB2Periph_GPIOC

#define _1led_PIN GPIO_Pin_9
#define _2led_PIN GPIO_Pin_8
#define _1_LED LED_PORT,_1led_PIN
#define _2_LED LED_PORT,_2led_PIN

#define _1gomb_PIN GPIO_Pin_0
#define _2gomb_PIN GPIO_Pin_1
#define _1_GOMB GOMB_PORT,_1gomb_PIN
#define _2_GOMB GOMB_PORT,_2gomb_PIN

#define SET(mit) (GPIO_WriteBit(mit, Bit_SET))
#define RESET(mit) (GPIO_WriteBit(mit, Bit_RESET))
#define GET(mit) (GPIO_ReadInputDataBit(GOMB_PORT,mit))

GPIO_InitTypeDef GPIO_InitStructure;

void DIOInit()
{
	RCC_APB2PeriphClockCmd(LED_PORT_CLOCK |GOMB_PORT_CLOCK, ENABLE);

	GPIO_InitStructure.GPIO_Pin = _1led_PIN | _2led_PIN;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
    GPIO_Init(LED_PORT, &GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin = _1gomb_PIN | _2gomb_PIN;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
    GPIO_Init(GOMB_PORT, &GPIO_InitStructure);


}

#endif
