#ifndef _SYSTICK_
#define _SYSTICK_

volatile uint32_t ticks;

void SysTick_Handler(void)
{
   ticks++;
}

void systickInit (uint16_t frequency)
{
   RCC_ClocksTypeDef RCC_Clocks;
   RCC_GetClocksFreq (&RCC_Clocks);
   (void) SysTick_Config (RCC_Clocks.HCLK_Frequency / frequency);
}

// return the system clock as milliseconds
uint32_t millis(void)
{
   return ticks;
}

void delay_ms (uint32_t t)
{
  uint32_t start, end;
  start = millis();
  end = start + t;
  if (start < end) {
    while ((millis() >= start) && (millis() < end)) {
      // do nothing
    }
  } else {
    while ((millis() >= start) || (millis() < end)) {
      // do nothing
    };
  }
}

#endif
